/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.JepMessages;
import com.singularsys.jep.PostfixMathCommandI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Operator
implements Serializable {
    private static final long serialVersionUID = 300L;
    public static final int NO_ARGS = 0;
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int NARY = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int ASSOCIATIVE = 16;
    public static final int COMMUTATIVE = 32;
    public static final int REFLEXIVE = 64;
    public static final int SYMMETRIC = 128;
    public static final int TRANSITIVE = 256;
    public static final int EQUIVALENCE = 448;
    public static final int PREFIX = 512;
    public static final int SUFFIX = 1024;
    public static final int SELF_INVERSE = 2048;
    public static final int COMPOSITE = 4096;
    public static final int USE_BINDING_FOR_PRINT = 8192;
    public static final int NOT_IN_PARSER = 16384;
    public static final int TERNARY = 32768;
    protected final String name;
    protected String symbol;
    protected String printSymbol = null;
    protected PostfixMathCommandI pfmc;
    protected int flags;
    protected int precedence = -1;
    protected int key;
    List<String> altSymbols;
    private Operator[] distribOver = new Operator[0];
    private Operator rootOperator = null;
    private Operator inverseOperator = null;
    private Operator binaryInverseOperator = null;

    public Operator(String string, PostfixMathCommandI postfixMathCommandI, int n) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.symbol = string;
        this.flags = n;
        if (postfixMathCommandI != null) {
            postfixMathCommandI.setName(string);
        }
    }

    public Operator(String string, PostfixMathCommandI postfixMathCommandI, int n, int n2) {
        this(string, postfixMathCommandI, n);
        this.precedence = n2;
    }

    public Operator(String string, String string2, PostfixMathCommandI postfixMathCommandI, int n) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        this.symbol = string2;
        this.flags = n;
        if (postfixMathCommandI != null) {
            postfixMathCommandI.setName(string);
        }
    }

    public Operator(String string, String string2, PostfixMathCommandI postfixMathCommandI, int n, int n2) {
        this.name = string;
        this.pfmc = postfixMathCommandI;
        if (postfixMathCommandI != null) {
            postfixMathCommandI.setName(string);
        }
        this.symbol = string2;
        this.precedence = n2;
        this.flags = n;
    }

    public final String getSymbol() {
        return this.symbol;
    }

    public final void setSymbol(String string) {
        this.symbol = string;
    }

    public final String getName() {
        return this.name;
    }

    public String getPrintSymbol() {
        return this.printSymbol;
    }

    public void setPrintSymbol(String string) {
        this.printSymbol = string;
    }

    public final PostfixMathCommandI getPFMC() {
        return this.pfmc;
    }

    public final void setPFMC(PostfixMathCommandI postfixMathCommandI) {
        this.pfmc = postfixMathCommandI;
        if (postfixMathCommandI != null) {
            postfixMathCommandI.setName(this.name);
        }
    }

    public final int getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    public final void setDistributiveOver(Operator operator) {
        int n = this.distribOver.length;
        Operator[] operatorArray = new Operator[n + 1];
        for (int i = 0; i < n; ++i) {
            operatorArray[i] = this.distribOver[i];
        }
        operatorArray[n] = operator;
        this.distribOver = operatorArray;
    }

    public boolean isDistributiveOver(Operator operator) {
        for (int i = 0; i < this.distribOver.length; ++i) {
            if (operator != this.distribOver[i]) continue;
            return true;
        }
        return false;
    }

    public void setRootOp(Operator operator) {
        this.rootOperator = operator;
    }

    public void setInverseOp(Operator operator) {
        this.inverseOperator = operator;
    }

    public void setBinaryInverseOp(Operator operator) {
        this.binaryInverseOperator = operator;
    }

    public Operator getRootOp() {
        return this.rootOperator;
    }

    public Operator getInverseOp() {
        return this.inverseOperator;
    }

    public Operator getBinaryInverseOp() {
        return this.binaryInverseOperator;
    }

    public final int getFlags() {
        return this.flags;
    }

    @Deprecated
    public final int getBinding() {
        return this.flags & 0xC;
    }

    public final boolean isLeftBinding() {
        return (this.flags & 4) == 4;
    }

    public final boolean isRightBinding() {
        return (this.flags & 8) == 8;
    }

    public final boolean isAssociative() {
        return (this.flags & 0x10) == 16;
    }

    public final boolean isCommutative() {
        return (this.flags & 0x20) == 32;
    }

    public final boolean isBinary() {
        return (this.flags & 3) == 2;
    }

    public final boolean isUnary() {
        return (this.flags & 3) == 1;
    }

    public final boolean isNary() {
        return (this.flags & 3) == 3;
    }

    public final int numArgs() {
        return this.flags & 3;
    }

    public final boolean isTransitive() {
        return (this.flags & 0x100) == 256;
    }

    public final boolean isSymmetric() {
        return (this.flags & 0x80) == 128;
    }

    public final boolean isReflexive() {
        return (this.flags & 0x40) == 64;
    }

    public final boolean isEquivalence() {
        return (this.flags & 0x1C0) == 448;
    }

    public final boolean isPrefix() {
        return (this.flags & 0x200) == 512;
    }

    public final boolean isSuffix() {
        return (this.flags & 0x400) == 1024;
    }

    public final boolean isTernary() {
        return (this.flags & 0x8000) == 32768;
    }

    public final boolean isComposite() {
        return (this.flags & 0x1000) == 4096;
    }

    public final boolean isSelfInverse() {
        return (this.flags & 0x800) == 2048;
    }

    public final boolean useBindingForPrint() {
        return (this.flags & 0x2000) == 8192;
    }

    public final boolean notInParser() {
        return (this.flags & 0x4000) == 16384;
    }

    public void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public String toFullString() {
        int n;
        String string = JepMessages.getString("Operator.Space");
        String string2 = JepMessages.getString("Operator.Comma");
        String string3 = JepMessages.getString("Operator.Quote");
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JepMessages.getString("Operator.Operator"));
        stringBuffer.append(string);
        if (!this.getName().equals(this.getSymbol())) {
            stringBuffer.append(this.getName());
            stringBuffer.append(string);
        }
        stringBuffer.append(string3 + this.getSymbol() + string3);
        if (this.altSymbols != null && this.altSymbols.size() > 0) {
            for (n = 0; n < this.altSymbols.size(); ++n) {
                stringBuffer.append(string2 + string);
                stringBuffer.append(string3 + this.altSymbols.get(n) + string3);
            }
        }
        stringBuffer.append(JepMessages.getString("Operator.Colon") + string);
        switch (this.numArgs()) {
            case 0: {
                arrayList.add(JepMessages.getString("Operator.NoArguments"));
                break;
            }
            case 1: {
                arrayList.add(JepMessages.getString("Operator.Unary"));
                break;
            }
            case 2: {
                arrayList.add(JepMessages.getString("Operator.Binary"));
                break;
            }
            case 3: {
                arrayList.add(JepMessages.getString("Operator.VariableNumberOfArguments"));
            }
        }
        if (this.isTernary()) {
            arrayList.add(JepMessages.getString("Operator.Ternary"));
        } else if (this.isPrefix()) {
            arrayList.add(JepMessages.getString("Operator.Prefix"));
        } else if (this.isSuffix()) {
            arrayList.add(JepMessages.getString("Operator.Suffix"));
        } else {
            arrayList.add(JepMessages.getString("Operator.Infix"));
        }
        if (this.isLeftBinding()) {
            arrayList.add(JepMessages.getString("Operator.LeftBinding"));
        } else if (this.isRightBinding()) {
            arrayList.add(JepMessages.getString("Operator.RightBinding"));
        }
        if (this.isAssociative()) {
            arrayList.add(JepMessages.getString("Operator.Associative"));
        }
        if (this.isCommutative()) {
            arrayList.add(JepMessages.getString("Operator.Commuative"));
        }
        if (this.isEquivalence()) {
            arrayList.add(JepMessages.getString("Operator.EquivalenceRelation"));
        } else {
            if (this.isReflexive()) {
                arrayList.add(JepMessages.getString("Operator.Reflexive"));
            }
            if (this.isSymmetric()) {
                arrayList.add(JepMessages.getString("Operator.Symmetric"));
            }
            if (this.isTransitive()) {
                arrayList.add(JepMessages.getString("Operator.Transitive"));
            }
        }
        arrayList.add(JepMessages.getString("Operator.Precedence") + string + this.getPrecedence());
        for (n = 0; n < arrayList.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(string2 + string);
            }
            stringBuffer.append((String)arrayList.get(n));
        }
        stringBuffer.append(JepMessages.getString("Operator.FullStop"));
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toFullString();
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int n) {
        this.key = n;
    }

    public List<String> getAltSymbols() {
        return this.altSymbols;
    }

    public boolean addAltSymbol(String string) {
        if (this.altSymbols == null) {
            this.altSymbols = new ArrayList<String>(1);
        }
        boolean bl = this.altSymbols.add(string);
        return bl;
    }
}

