/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Variable;
import com.singularsys.jep.VariableFactory;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

public class VariableTable
extends Observable
implements JepComponent {
    private static final long serialVersionUID = 300L;
    protected HashMap<String, Variable> table = new HashMap();
    protected transient VariableFactory vf;

    public VariableTable() {
    }

    public VariableTable(VariableTable variableTable) {
        this();
        try {
            for (Variable variable : variableTable.getVariables()) {
                if (variable.isConstant()) {
                    this.addConstant(variable.getName(), variable.getValue());
                    continue;
                }
                this.addVariable(variable.getName(), variable.getValue());
            }
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
    }

    @Override
    public void init(Jep jep) {
        this.setVariableFactory(jep.getVariableFactory());
    }

    public void setVariableFactory(VariableFactory variableFactory) {
        this.vf = variableFactory;
    }

    public VariableFactory getVariableFactory() {
        return this.vf;
    }

    public Variable addVariable(String string) {
        Variable variable = this.table.get(string);
        if (variable == null) {
            variable = this.vf.createVariable(string);
            this.table.put(string, variable);
            this.setChanged();
            this.notifyObservers(variable);
        }
        return variable;
    }

    public Variable addVariable(String string, Object object) throws JepException {
        Variable variable = this.table.get(string);
        if (variable == null) {
            variable = this.vf.createVariable(string, object);
            this.table.put(string, variable);
            this.setChanged();
            this.notifyObservers(variable);
        } else if (!variable.setValue(object)) {
            throw new JepException(MessageFormat.format(JepMessages.getString("VariableTable.AttemptToSetTheValueOfAConstantVariable"), string));
        }
        return variable;
    }

    public Variable addConstant(String string, Object object) throws JepException {
        Variable variable = this.addVariable(string, object);
        if (variable == null) {
            return null;
        }
        variable.setValidValue(true);
        variable.setIsConstant(true);
        return variable;
    }

    public Variable getVariable(String string) {
        return this.table.get(string);
    }

    public void clear() {
        this.table.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public Set<String> keySet() {
        return this.table.keySet();
    }

    public Collection<Variable> getVariables() {
        return this.table.values();
    }

    public Variable remove(String string) {
        Variable variable = this.table.remove(string);
        this.setChanged();
        this.notifyObservers(variable);
        return variable;
    }

    public Variable remove(Variable variable) {
        return this.remove(variable.getName());
    }

    @Deprecated
    public Collection<Variable> values() {
        return this.table.values();
    }

    public int size() {
        return this.table.size();
    }

    public boolean containsKey(String string) {
        return this.table.containsKey(string);
    }

    public boolean containsVariable(Variable variable) {
        return this.table.containsValue(variable);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JepMessages.getString("VariableTable.ListStart"));
        int n = 0;
        for (Variable variable : this.getVariables()) {
            if (n++ > 0) {
                stringBuffer.append(JepMessages.getString("VariableTable.ListSeparator"));
            }
            stringBuffer.append(variable);
        }
        stringBuffer.append(JepMessages.getString("VariableTable.ListEnd"));
        return stringBuffer.toString();
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new VariableTable();
    }

    public void copyConstantsFrom(VariableTable variableTable) {
        for (Variable variable : variableTable.getVariables()) {
            if (!variable.isConstant()) continue;
            Variable variable2 = this.vf.copyVariable(variable);
            this.table.put(variable.getName(), variable2);
            this.setChanged();
            this.notifyObservers(variable2);
        }
    }

    public void copyVariablesFrom(VariableTable variableTable) {
        for (Variable variable : variableTable.getVariables()) {
            Variable variable2 = this.vf.copyVariable(variable);
            this.table.put(variable.getName(), variable2);
            this.setChanged();
            this.notifyObservers(variable2);
        }
    }

    public void clearValues() {
        for (Variable variable : this.getVariables()) {
            if (variable.isConstant()) continue;
            variable.setValidValue(false);
        }
    }

    public void removeNonConstants() {
        Iterator<Map.Entry<String, Variable>> iterator = this.table.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Variable> entry = iterator.next();
            if (entry.getValue().isConstant()) continue;
            iterator.remove();
        }
    }
}

