/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal;

import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.bigdecimal.functions.BigDecAbs;
import com.singularsys.jep.bigdecimal.functions.BigDecAdd;
import com.singularsys.jep.bigdecimal.functions.BigDecDiv;
import com.singularsys.jep.bigdecimal.functions.BigDecRound;
import com.singularsys.jep.bigdecimal.functions.BigDecRoundSigFig;
import com.singularsys.jep.bigdecimal.functions.BigDecSignum;
import com.singularsys.jep.bigdecimal.functions.BigDecTieBreakComparative;
import com.singularsys.jep.functions.Average;
import com.singularsys.jep.functions.If;
import com.singularsys.jep.functions.MinMax;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigDecFunctionTable
extends FunctionTable {
    private static final long serialVersionUID = 300L;
    MathContext mc;

    public BigDecFunctionTable(MathContext mathContext) {
        this.mc = mathContext;
        this.addFunction("if", new If());
        this.addFunction("abs", new BigDecAbs());
        this.addFunction("signum", new BigDecSignum());
        this.addFunction("min", new MinMax(new BigDecTieBreakComparative(0)));
        this.addFunction("max", new MinMax(new BigDecTieBreakComparative(1)));
        this.addFunction("avg", new Average(new BigDecAdd(mathContext), new BigDecDiv(mathContext)));
        this.addFunction("round", new BigDecRound());
        this.addFunction("rint", new BigDecRound(RoundingMode.HALF_EVEN));
        this.addFunction("ceil", new BigDecRound(RoundingMode.CEILING));
        this.addFunction("floor", new BigDecRound(RoundingMode.FLOOR));
        this.addFunction("roundSF", new BigDecRoundSigFig(RoundingMode.HALF_UP));
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }
}

