/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.UMinus;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecNegate
extends UMinus {
    private static final long serialVersionUID = 300L;
    MathContext mc;

    public BigDecNegate(MathContext mathContext) {
        this.mc = mathContext;
        this.numberOfParameters = 1;
    }

    @Override
    public Object umin(Object object) throws EvaluationException {
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            BigDecimal bigDecimal2 = this.mc != null ? bigDecimal.negate(this.mc) : bigDecimal.negate();
            return bigDecimal2;
        }
        if (object instanceof Double) {
            return this.umin(BigDecimal.valueOf((Double)object));
        }
        if (object instanceof Integer) {
            return this.umin(BigDecimal.valueOf(((Integer)object).intValue()));
        }
        if (object instanceof Float) {
            return this.umin(BigDecimal.valueOf(((Float)object).floatValue()));
        }
        if (object instanceof Short) {
            return this.umin(BigDecimal.valueOf(((Short)object).shortValue()));
        }
        if (object instanceof Long) {
            return this.umin(BigDecimal.valueOf((Long)object));
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, BigDecimal.class, object);
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public void setMathContext(MathContext mathContext) {
        this.mc = mathContext;
    }
}

