/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.IllegalParameterException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigDecRoundSigFig
extends BinaryFunction {
    private static final long serialVersionUID = 350L;
    RoundingMode mode;

    public BigDecRoundSigFig(RoundingMode roundingMode) {
        this.mode = roundingMode;
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        if (object instanceof BigDecimal) {
            if (!(object2 instanceof Number)) {
                throw new IllegalParameterException((PostfixMathCommandI)this, 1, Number.class, object2);
            }
            int n = ((Number)object2).intValue();
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.precision() < n) {
                BigDecimal bigDecimal2 = bigDecimal.setScale(bigDecimal.scale() + (n - bigDecimal.precision()), this.mode);
                return bigDecimal2;
            }
            BigDecimal bigDecimal3 = bigDecimal.round(new MathContext(n, this.mode));
            return bigDecimal3;
        }
        if (object instanceof Double) {
            return this.eval(BigDecimal.valueOf((Double)object), object2);
        }
        if (object instanceof Integer) {
            return this.eval(BigDecimal.valueOf(((Integer)object).intValue()), object2);
        }
        if (object instanceof Float) {
            return this.eval(BigDecimal.valueOf(((Float)object).floatValue()), object2);
        }
        if (object instanceof Short) {
            return this.eval(BigDecimal.valueOf(((Short)object).shortValue()), object2);
        }
        if (object instanceof Long) {
            return this.eval(BigDecimal.valueOf((Long)object), object2);
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, BigDecimal.class, object);
    }
}

