/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.matchers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.configurableparser.matchers.RegExpTokenMatcher;
import com.singularsys.jep.configurableparser.tokens.NumberToken;
import com.singularsys.jep.configurableparser.tokens.Token;

public class HexNumberTokenMatcher
extends RegExpTokenMatcher {
    private static final long serialVersionUID = 300L;
    private transient NumberFactory nf;

    public HexNumberTokenMatcher() {
        super("0x[0-9a-fA-F]+");
    }

    @Override
    public Token buildToken(String string) {
        try {
            Long l = Long.parseLong(string.substring(2), 16);
            return new NumberToken(string, this.nf.createNumber(l));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public void init(Jep jep) {
        this.nf = jep.getNumberFactory();
    }
}

