/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.matchers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.configurableparser.matchers.RegExpTokenMatcher;
import com.singularsys.jep.configurableparser.tokens.NumberToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import java.util.regex.Pattern;

public class NumberTokenMatcher
extends RegExpTokenMatcher {
    private static final long serialVersionUID = 300L;
    private transient NumberFactory nf;

    public NumberTokenMatcher(Pattern pattern) {
        super(pattern);
    }

    public NumberTokenMatcher(String string) {
        super(string);
    }

    @Override
    public Token buildToken(String string) {
        try {
            return new NumberToken(string, this.nf.createNumber(string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static NumberTokenMatcher defaultNumberTokenMatcher() {
        return new NumberTokenMatcher("(\\d+\\.?\\d*)|(\\.\\d+)");
    }

    public static NumberTokenMatcher exponentNumberTokenMatcher() {
        return new NumberTokenMatcher("((\\d+\\.?\\d*)|(\\.\\d+))(?:[eE][+-]?\\d+)?");
    }

    @Override
    public void init(Jep jep) {
        this.nf = jep.getNumberFactory();
    }
}

