/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.matchers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.configurableparser.GrammarParser;
import com.singularsys.jep.configurableparser.Lookahead2Iterator;
import com.singularsys.jep.configurableparser.matchers.GrammarException;
import com.singularsys.jep.configurableparser.matchers.GrammarMatcher;
import com.singularsys.jep.configurableparser.tokens.FunctionToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.parser.Node;

public class SingleArgFunctionMatcher
implements GrammarMatcher {
    private static final long serialVersionUID = 350L;
    private transient NodeFactory nf;
    private final Token open;

    public SingleArgFunctionMatcher(Token token) {
        this.open = token;
    }

    @Override
    public Node match(Lookahead2Iterator<Token> lookahead2Iterator, GrammarParser grammarParser) throws ParseException {
        Token token = lookahead2Iterator.peekNext();
        if (token == null) {
            return null;
        }
        if (!token.isFunction()) {
            return null;
        }
        String string = token.getSource();
        PostfixMathCommandI postfixMathCommandI = ((FunctionToken)token).getPfmc();
        if (!postfixMathCommandI.checkNumberOfParameters(1)) {
            return null;
        }
        Node[] nodeArray = new Node[1];
        Token token2 = lookahead2Iterator.nextnext();
        if (this.open.equals(token2)) {
            return null;
        }
        lookahead2Iterator.consume();
        nodeArray[0] = grammarParser.parsePrefixSuffix();
        if (nodeArray[0] != null) {
            return this.nf.buildFunctionNode(string, postfixMathCommandI, nodeArray);
        }
        throw new GrammarException(String.format(JepMessages.getString("configurableparser.matchers.SingleArgFunctionMatcher.badArgument"), postfixMathCommandI.getName()), token2);
    }

    @Override
    public void init(Jep jep) {
        this.nf = jep.getNodeFactory();
    }
}

