/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.matchers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.configurableparser.matchers.TokenMatcher;
import com.singularsys.jep.configurableparser.tokens.StringToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import java.text.MessageFormat;

public class StringTokenMatcher2
implements TokenMatcher {
    private static final long serialVersionUID = 300L;
    private final char delim;
    boolean includeQuotes;

    public StringTokenMatcher2(char c, boolean bl) {
        this.delim = c;
        this.includeQuotes = bl;
    }

    @Override
    public Token match(String string) throws ParseException {
        if (string.charAt(0) != this.delim) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.delim) {
                return this.buildToken(string.substring(0, i + 1), stringBuilder.toString());
            }
            if (c == '\\') {
                char c2 = string.charAt(++i);
                switch (c2) {
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case '\'': {
                        stringBuilder.append('\'');
                        break;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        break;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        break;
                    }
                    case 'u': {
                        int n3;
                        try {
                            if (string.length() < i + 5) {
                                throw new ParseException(MessageFormat.format(JepMessages.getString("configurableparser.matchers.StringTokenMatcher2.MalformedUnicodeEscape"), string));
                            }
                            n3 = Integer.parseInt(string.substring(i + 1, i + 5), 16);
                            char[] cArray = Character.toChars(n3);
                            stringBuilder.append(cArray);
                            i += 4;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException(MessageFormat.format(JepMessages.getString("configurableparser.matchers.StringTokenMatcher2.MalformedUnicodeEscape"), string));
                        }
                    }
                    default: {
                        int n;
                        int n2;
                        int n3 = string.length() > i + 1 ? (int)string.charAt(i + 1) : 90;
                        int n4 = n2 = string.length() > i + 2 ? (int)string.charAt(i + 2) : 90;
                        if (c2 < '0' || c2 > '8') {
                            throw new ParseException(MessageFormat.format(JepMessages.getString("configurableparser.matchers.StringTokenMatcher2.IllegalEscapeSequence"), Character.valueOf(c2)));
                        }
                        if (n3 >= 48 && n3 <= 56) {
                            if (n2 >= 48 && n2 <= 56) {
                                n = Integer.parseInt(string.substring(i, i + 3), 8);
                                i += 2;
                            } else {
                                n = Integer.parseInt(string.substring(i, i + 2), 8);
                                ++i;
                            }
                        } else {
                            n = Integer.parseInt(string.substring(i, i + 1), 8);
                        }
                        if (n > 255) {
                            return null;
                        }
                        char[] cArray = Character.toChars(n);
                        stringBuilder.append(cArray);
                        break;
                    }
                }
                continue;
            }
            stringBuilder.append(c);
        }
        return null;
    }

    private Token buildToken(String string, String string2) {
        return new StringToken(string, string2, this.delim, this.includeQuotes);
    }

    public static StringTokenMatcher2 doubleQuoteStringMatcher() {
        return new StringTokenMatcher2('\"', false);
    }

    public static StringTokenMatcher2 singleQuoteStringMatcher() {
        return new StringTokenMatcher2('\'', false);
    }

    public static StringTokenMatcher2 singleQuoteStringMatcher(boolean bl) {
        return new StringTokenMatcher2('\'', bl);
    }

    @Override
    public void init(Jep jep) {
    }
}

