/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.tokens;

import com.singularsys.jep.Operator;
import com.singularsys.jep.configurableparser.tokens.Token;
import java.util.List;

public class OperatorToken
extends Token {
    private static final long serialVersionUID = 300L;
    Operator binaryOp = null;
    Operator prefixOp = null;
    Operator suffixOp = null;
    Operator ternaryOp = null;

    public OperatorToken(List<Operator> list, String string) {
        super(string);
        for (Operator operator : list) {
            this.setOp(operator);
        }
    }

    private OperatorToken(OperatorToken operatorToken) {
        super(operatorToken.getSource());
        this.binaryOp = operatorToken.binaryOp;
        this.prefixOp = operatorToken.prefixOp;
        this.suffixOp = operatorToken.suffixOp;
        this.ternaryOp = operatorToken.ternaryOp;
    }

    private void setOp(Operator operator) {
        if (operator.isBinary()) {
            this.binaryOp = operator;
        } else if (operator.isPrefix()) {
            this.prefixOp = operator;
        } else if (operator.isSuffix()) {
            this.suffixOp = operator;
        } else if (operator.isTernary()) {
            this.ternaryOp = operator;
        }
    }

    public Operator getBinaryOp() {
        return this.binaryOp;
    }

    public Operator getPrefixOp() {
        return this.prefixOp;
    }

    public Operator getSuffixOp() {
        return this.suffixOp;
    }

    public Operator getTernaryOp() {
        return this.ternaryOp;
    }

    @Override
    public boolean isOperator() {
        return true;
    }

    @Override
    public boolean isBinary() {
        return this.binaryOp != null;
    }

    @Override
    public boolean isPrefix() {
        return this.prefixOp != null;
    }

    @Override
    public boolean isSuffix() {
        return this.suffixOp != null;
    }

    @Override
    public boolean isTernary() {
        return this.ternaryOp != null;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        return stringBuffer.toString();
    }

    public Token cloneToken() {
        return new OperatorToken(this);
    }
}

