/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class ArcCosineH
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 300L;
    final boolean strict;

    public ArcCosineH() {
        this.strict = false;
    }

    public ArcCosineH(boolean bl) {
        this.strict = bl;
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.acosh(object);
    }

    public Object acosh(Object object) throws EvaluationException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 1.0) {
                double d2 = Math.log(d + Math.sqrt(d * d - 1.0));
                return d2;
            }
            if (this.strict) {
                return Double.NaN;
            }
            Complex complex = new Complex(((Number)object).doubleValue(), 0.0);
            return complex.acosh();
        }
        if (object instanceof Complex) {
            return ((Complex)object).acosh();
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d) {
        if (d >= 1.0) {
            return Math.log(d + Math.sqrt(d * d - 1.0));
        }
        return Double.NaN;
    }
}

