/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class ArrayFunctionBase
extends PostfixMathCommand {
    private static final long serialVersionUID = 330L;
    ZeroLengthErrorBehaviour zeroLengthErrorBehaviour = ZeroLengthErrorBehaviour.EXCEPTION;

    public ArrayFunctionBase() {
        this.numberOfParameters = -1;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n > 0;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.curNumberOfParameters; ++i) {
            this.addToArray(arrayList, stack.pop());
        }
        Object object = this.calc(arrayList);
        stack.push(object);
    }

    protected void addToArray(List<Object> list, Object object) {
        if (object instanceof List) {
            for (Object e : (List)object) {
                this.addToArray(list, e);
            }
        } else {
            list.add(object);
        }
    }

    protected abstract Object calc(List<Object> var1) throws EvaluationException;

    protected void throwAtLeastOneExcep() throws EvaluationException {
        throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.AtLestOneArgumentIsRequired"), this.getName()));
    }

    public ZeroLengthErrorBehaviour getZeroLengthErrorBehaviour() {
        return this.zeroLengthErrorBehaviour;
    }

    public void setZeroLengthErrorBehaviour(ZeroLengthErrorBehaviour zeroLengthErrorBehaviour) {
        this.zeroLengthErrorBehaviour = zeroLengthErrorBehaviour;
    }

    public static enum ZeroLengthErrorBehaviour {
        EXCEPTION,
        NAN;

    }
}

