/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.BinaryFunction;
import java.text.MessageFormat;

public class Binomial
extends BinaryFunction {
    private static final long serialVersionUID = 300L;
    static final int initN = 20;
    static int[][] coeffs = new int[21][];

    public Binomial() {
        Binomial.coeffs[0] = new int[1];
        Binomial.coeffs[0][0] = 1;
        Binomial.coeffs[1] = new int[2];
        Binomial.coeffs[1][0] = 1;
        Binomial.coeffs[1][1] = 1;
        for (int i = 2; i <= 20; ++i) {
            Binomial.coeffs[i] = new int[i + 1];
            Binomial.coeffs[i][0] = 1;
            Binomial.coeffs[i][i] = 1;
            for (int j = 1; j < i; ++j) {
                Binomial.coeffs[i][j] = coeffs[i - 1][j - 1] + coeffs[i - 1][j];
            }
        }
    }

    static synchronized void expand(int n) {
        int n2;
        int n3 = coeffs.length - 1;
        if (n <= n3) {
            return;
        }
        int[][] nArrayArray = new int[n + 1][];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArrayArray[n2] = coeffs[n2];
        }
        for (n2 = n3 + 1; n2 <= n; ++n2) {
            nArrayArray[n2] = new int[n2 + 1];
            nArrayArray[n2][0] = 1;
            nArrayArray[n2][n2] = 1;
            for (int i = 1; i < n2; ++i) {
                nArrayArray[n2][i] = nArrayArray[n2 - 1][i - 1] + nArrayArray[n2 - 1][i];
            }
        }
        coeffs = nArrayArray;
    }

    static synchronized int getCoeff(int n, int n2) {
        return coeffs[n2][n];
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        int n = this.asStrictInt(0, object);
        int n2 = this.asStrictInt(1, object2);
        if (n < 0 || n2 < 0 || n2 > n) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Binomial.IllegalValuesForArguments"), this.getName(), n, n2));
        }
        Binomial.expand(n);
        int n3 = Binomial.getCoeff(n2, n);
        return n3;
    }

    public static int binom(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Binomial.expand(n);
        int n3 = Binomial.getCoeff(n2, n);
        return n3;
    }
}

