/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.Multiply;
import com.singularsys.jep.functions.Subtract;
import java.text.MessageFormat;
import java.util.Vector;

public class Cross
extends BinaryFunction {
    private static final long serialVersionUID = 300L;
    protected Subtract sub = new Subtract();
    protected Multiply mul = new Multiply();

    public Cross() {
        this.sub.setName("-");
        this.mul.setName("*");
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        return this.cross(object, object2);
    }

    public Object cross(Object object, Object object2) throws EvaluationException {
        if (!(object instanceof Vector)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, 0, Vector.class, object);
        }
        if (!(object2 instanceof Vector)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, Vector.class, object2);
        }
        return this.cross((Vector)object, (Vector)object2);
    }

    public Object cross(Vector<?> vector, Vector<?> vector2) throws EvaluationException {
        int n = vector.size();
        if (n != vector2.size()) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.DimensionsOfVectorsDoNotMatch"), this.getName(), n, vector2.size()));
        }
        if (n == 3) {
            Vector<Object> vector3 = new Vector<Object>(3);
            vector3.setSize(3);
            vector3.setElementAt(this.sub.sub(this.mul.mul(vector.elementAt(1), vector2.elementAt(2)), this.mul.mul(vector.elementAt(2), vector2.elementAt(1))), 0);
            vector3.setElementAt(this.sub.sub(this.mul.mul(vector.elementAt(2), vector2.elementAt(0)), this.mul.mul(vector.elementAt(0), vector2.elementAt(2))), 1);
            vector3.setElementAt(this.sub.sub(this.mul.mul(vector.elementAt(0), vector2.elementAt(1)), this.mul.mul(vector.elementAt(1), vector2.elementAt(0))), 2);
            return vector3;
        }
        if (n == 2) {
            return this.sub.sub(this.mul.mul(vector.elementAt(0), vector2.elementAt(1)), this.mul.mul(vector.elementAt(1), vector2.elementAt(0)));
        }
        throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Cross.BothSidesMustBe2or3Dim"), this.getName(), n));
    }
}

