/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import java.text.MessageFormat;

public class If
extends PostfixMathCommand
implements CallbackEvaluationI {
    private static final long serialVersionUID = 300L;
    protected Object falseValue = null;

    public If() {
        this.numberOfParameters = -1;
    }

    public If(Object object) {
        this.falseValue = object;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n == 3 || n == 4 || n == 2 && this.falseValue != null;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        double d;
        int n = node.jjtGetNumChildren();
        if (!this.checkNumberOfParameters(n)) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.IncorrectNumberOfArguments"), this.getName(), n));
        }
        Object object = evaluator.eval(node.jjtGetChild(0));
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return evaluator.eval(node.jjtGetChild(1));
            }
            return evaluator.eval(node.jjtGetChild(2));
        }
        if (object instanceof Complex) {
            d = ((Complex)object).re();
        } else if (object instanceof Number) {
            d = ((Number)object).doubleValue();
            if (Double.isNaN(d)) {
                return d;
            }
        } else {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.If.ConditionMustBeBooleanOrNumber"), this.getName(), object.toString()));
        }
        if (d > 0.0) {
            return evaluator.eval(node.jjtGetChild(1));
        }
        if (n == 2) {
            return this.falseValue;
        }
        if (n == 3 || d < 0.0) {
            return evaluator.eval(node.jjtGetChild(2));
        }
        return evaluator.eval(node.jjtGetChild(3));
    }

    public Object getFalseValue() {
        return this.falseValue;
    }
}

