/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.text.MessageFormat;

public class IllegalParameterException
extends EvaluationException {
    private static final long serialVersionUID = 330L;
    PostfixMathCommandI pfmc;
    String functionName;
    int argumentNumber = -1;
    Class<?> expectedClass = null;
    Object actualObject;
    Object actualObject2 = null;
    String expectedMsg = null;

    public IllegalParameterException(PostfixMathCommandI postfixMathCommandI, int n, Class<?> clazz, Object object) {
        this.pfmc = postfixMathCommandI;
        this.functionName = postfixMathCommandI.getName();
        this.argumentNumber = n;
        this.expectedClass = clazz;
        this.actualObject = object;
    }

    public IllegalParameterException(PostfixMathCommandI postfixMathCommandI, int n, String string, Object object) {
        this.pfmc = postfixMathCommandI;
        this.functionName = postfixMathCommandI.getName();
        this.argumentNumber = n;
        this.expectedMsg = string;
        this.actualObject = object;
    }

    public IllegalParameterException(PostfixMathCommand postfixMathCommand, int n, Object object) {
        this.pfmc = postfixMathCommand;
        this.functionName = postfixMathCommand.getName();
        this.argumentNumber = n;
        this.expectedClass = null;
        this.actualObject = object;
    }

    public IllegalParameterException(PostfixMathCommand postfixMathCommand, Object object, Object object2) {
        this.pfmc = postfixMathCommand;
        this.functionName = postfixMathCommand.getName();
        this.actualObject = object;
        this.actualObject2 = object2;
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.functionName != null) {
            stringBuilder.append(this.functionName);
        } else if (this.pfmc != null) {
            stringBuilder.append(this.pfmc.getClass().getSimpleName());
        } else {
            stringBuilder.append(JepMessages.getString("functions.IllegalParameterException.UnknownFunction"));
        }
        if (this.actualObject2 != null) {
            stringBuilder.append(JepMessages.getString("functions.IllegalParameterException.IllegalArguments"));
        } else {
            stringBuilder.append(JepMessages.getString("functions.IllegalParameterException.IllegalArgument"));
        }
        if (this.actualObject == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(MessageFormat.format(JepMessages.getString("functions.IllegalParameterException.ActualValueClass"), this.actualObject.toString(), this.actualObject.getClass().getSimpleName()));
        }
        if (this.actualObject2 != null) {
            stringBuilder.append(JepMessages.getString("functions.IllegalParameterException.Comma"));
            stringBuilder.append(MessageFormat.format(JepMessages.getString("functions.IllegalParameterException.ActualValueClass"), this.actualObject2.toString(), this.actualObject2.getClass().getSimpleName()));
        }
        if (this.expectedClass != null) {
            stringBuilder.append(MessageFormat.format(JepMessages.getString("functions.IllegalParameterException.Expected"), this.expectedClass.getSimpleName()));
        } else if (this.expectedMsg != null) {
            stringBuilder.append(MessageFormat.format(JepMessages.getString("functions.IllegalParameterException.ExpectedMsg"), this.expectedMsg));
        }
        if (this.argumentNumber >= 0) {
            stringBuilder.append(MessageFormat.format(JepMessages.getString("functions.IllegalParameterException.ArgumentNumber"), this.argumentNumber));
        }
        return stringBuilder.toString();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getArgumentNumber() {
        return this.argumentNumber;
    }

    public Class<?> getExpectedClass() {
        return this.expectedClass;
    }

    public Object getActualObject() {
        return this.actualObject;
    }

    public Class<?> getActualClass() {
        return this.actualObject.getClass();
    }

    public PostfixMathCommandI getPfmc() {
        return this.pfmc;
    }
}

