/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;

public class LazyLogical
extends PostfixMathCommand
implements CallbackEvaluationI {
    private static final long serialVersionUID = 300L;
    protected int id;
    public static final int AND = 0;
    public static final int OR = 1;
    protected boolean allowNumbers = true;

    public LazyLogical(int n) {
        this.id = n;
        this.numberOfParameters = 2;
    }

    public LazyLogical(int n, boolean bl) {
        this.id = n;
        this.numberOfParameters = 2;
        this.allowNumbers = !bl;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        boolean bl;
        boolean bl2;
        if (node.jjtGetNumChildren() != 2) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.IncorrectNumberOfArgumentsExpected"), this.getName(), 2));
        }
        Object object = evaluator.eval(node.jjtGetChild(0));
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        } else if (this.allowNumbers && object instanceof Number) {
            bl2 = ((Number)object).doubleValue() != 0.0;
        } else {
            throw new IllegalParameterException((PostfixMathCommandI)this, 0, this.allowNumbers ? JepMessages.getString("functions.ANumberOrBoolean") : JepMessages.getString("functions.ABoolean"), object);
        }
        switch (this.id) {
            case 0: {
                if (bl2) break;
                return Boolean.FALSE;
            }
            case 1: {
                if (!bl2) break;
                return Boolean.TRUE;
            }
        }
        Object object2 = evaluator.eval(node.jjtGetChild(1));
        if (object2 instanceof Boolean) {
            bl = (Boolean)object2;
        } else if (this.allowNumbers && object2 instanceof Number) {
            bl = ((Number)object2).doubleValue() != 0.0;
        } else {
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, this.allowNumbers ? JepMessages.getString("functions.ANumberOrBoolean") : JepMessages.getString("functions.ABoolean"), object2);
        }
        return bl;
    }

    public int getId() {
        return this.id;
    }

    public boolean isAllowNumbers() {
        return this.allowNumbers;
    }
}

