/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class NaturalLogarithm
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 300L;

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.ln(object);
    }

    public Object ln(Object object) throws EvaluationException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 0.0) {
                return Math.log(d);
            }
            if (Double.isNaN(d)) {
                return NaN;
            }
            Complex complex = new Complex(d);
            return complex.log();
        }
        if (object instanceof Complex) {
            return ((Complex)object).log();
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d) {
        return Math.log(d);
    }
}

