/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.standard.Complex;

public class Power
extends BinaryFunction
implements RealBinaryFunction {
    private static final long serialVersionUID = 300L;
    protected boolean strict = false;

    public Power() {
        this.strict = false;
    }

    public Power(boolean bl) {
        this.strict = bl;
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        return this.power(object, object2);
    }

    public Object power(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number) {
            if (object2 instanceof Number) {
                return this.power((Number)object, (Number)object2);
            }
            if (object2 instanceof Complex) {
                return Power.power((Number)object, (Complex)object2);
            }
        } else if (object instanceof Complex) {
            if (object2 instanceof Complex) {
                return Power.power((Complex)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return Power.power((Complex)object, (Number)object2);
            }
        } else {
            throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 1, object2);
    }

    public Object power(Number number, Number number2) {
        short s = number2.shortValue();
        double d = number2.doubleValue();
        if (number.doubleValue() < 0.0 && d != (double)s) {
            if (this.strict) {
                return NaN;
            }
            Complex complex = new Complex(number.doubleValue(), 0.0);
            return complex.power(number2.doubleValue());
        }
        if (d == (double)s) {
            if (d >= 0.0) {
                return new Double(Power.power(number.doubleValue(), s));
            }
            return new Double(1.0 / Power.power(number.doubleValue(), -s));
        }
        return new Double(Math.pow(number.doubleValue(), number2.doubleValue()));
    }

    public static Object power(Complex complex, Complex complex2) {
        Complex complex3 = complex.power(complex2);
        if (complex3.im() == 0.0) {
            return new Double(complex3.re());
        }
        return complex3;
    }

    public static Object power(Complex complex, Number number) {
        Complex complex2 = complex.power(number.doubleValue());
        if (complex2.im() == 0.0) {
            return new Double(complex2.re());
        }
        return complex2;
    }

    public static Object power(Number number, Complex complex) {
        Complex complex2 = new Complex(number.doubleValue(), 0.0);
        Complex complex3 = complex2.power(complex);
        if (complex3.im() == 0.0) {
            return new Double(complex3.re());
        }
        return complex3;
    }

    public static double power(double d, int n) {
        double d2 = d;
        switch (n) {
            case 0: {
                d2 = 1.0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                d2 *= d2;
                break;
            }
            case 3: {
                d2 *= d2 * d2;
                break;
            }
            case 4: {
                d2 *= d2 * d2 * d2;
                break;
            }
            case 5: {
                d2 *= d2 * d2 * d2 * d2;
                break;
            }
            case 6: {
                d2 *= d2 * d2 * d2 * d2 * d2;
                break;
            }
            case 7: {
                d2 *= d2 * d2 * d2 * d2 * d2 * d2;
                break;
            }
            case 8: {
                d2 *= d2 * d2 * d2 * d2 * d2 * d2 * d2;
                break;
            }
            default: {
                int n2 = n;
                double d3 = d2;
                double d4 = (n2 & 1) != 0 ? d2 : 1.0;
                n2 >>>= 1;
                while (n2 != 0) {
                    d3 *= d3;
                    if ((n2 & 1) != 0) {
                        d4 *= d3;
                    }
                    n2 >>>= 1;
                }
                d2 = d4;
            }
        }
        return d2;
    }

    @Override
    public double evaluate(double d, double d2) {
        int n = (int)d2;
        if (d2 == (double)n) {
            if (n >= 0) {
                return Power.power(d, n);
            }
            return 1.0 / Power.power(d, -n);
        }
        return Math.pow(d, d2);
    }

    public boolean isAllowComplexResults() {
        return !this.strict;
    }

    public void setAllowComplexResults(boolean bl) {
        this.strict = !bl;
    }
}

