/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.NaryFunction;
import java.util.Stack;

public class Round
extends NaryFunction {
    private static final long serialVersionUID = 300L;

    public Round() {
        this.numberOfParameters = -1;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n == 1 || n == 2;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        if (this.curNumberOfParameters == 1) {
            Object object = stack.pop();
            stack.push(this.round(object));
        } else {
            Object object = stack.pop();
            Object object2 = stack.pop();
            stack.push(this.round(object2, object));
        }
    }

    public Object round(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number && object2 instanceof Number) {
            int n = ((Number)object2).intValue();
            double d = ((Number)object).doubleValue();
            double d2 = Math.pow(10.0, n);
            return this.round(d * d2) / d2;
        }
        if (!(object instanceof Number)) {
            throw new IllegalParameterException((PostfixMathCommandI)this, 0, Number.class, object);
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 1, Number.class, object2);
    }

    public Object round(Object object) throws EvaluationException {
        if (object instanceof Number) {
            return new Double(this.round(((Number)object).doubleValue()));
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, Number.class, object);
    }

    protected double round(double d) {
        return Math.round(d);
    }

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        if (objectArray.length == 1) {
            return this.round(objectArray[0]);
        }
        if (objectArray.length == 2) {
            return this.round(objectArray[0], objectArray[1]);
        }
        return null;
    }
}

