/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class SquareRoot
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 300L;
    final boolean strict;

    public SquareRoot() {
        this.strict = false;
    }

    public SquareRoot(boolean bl) {
        this.strict = bl;
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.sqrt(object);
    }

    public Object sqrt(Object object) throws EvaluationException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d < 0.0) {
                if (this.strict) {
                    return NaN;
                }
                return new Complex(d).sqrt();
            }
            return Math.sqrt(d);
        }
        if (object instanceof Complex) {
            return ((Complex)object).sqrt();
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d) {
        return Math.sqrt(d);
    }
}

