/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class StrictNaturalLogarithm
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 300L;
    private final double logBase;

    public StrictNaturalLogarithm(double d) {
        this.logBase = Math.log(d);
    }

    public StrictNaturalLogarithm() {
        this.logBase = 1.0;
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.ln(object);
    }

    public Object ln(Object object) throws EvaluationException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 0.0) {
                return Math.log(d) / this.logBase;
            }
            return NaN;
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            return new Complex(Math.log(complex.abs()) / this.logBase, complex.arg());
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d) {
        return Math.log(d) / this.logBase;
    }
}

