/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.configurableparser.GrammarParser;
import com.singularsys.jep.configurableparser.Lookahead2Iterator;
import com.singularsys.jep.configurableparser.matchers.GrammarException;
import com.singularsys.jep.configurableparser.matchers.GrammarMatcher;
import com.singularsys.jep.configurableparser.tokens.OperatorToken;
import com.singularsys.jep.configurableparser.tokens.TerminatorToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class OperatorAsFunctionGrammarMatcher
implements GrammarMatcher {
    private static final long serialVersionUID = 300L;
    private final Token open;
    private final Token close;
    private final Token comma;
    private List<Operator> operators;
    private transient NodeFactory nf;

    public OperatorAsFunctionGrammarMatcher(Token token, Token token2, Token token3, List<Operator> list) {
        this.open = token;
        this.close = token2;
        this.comma = token3;
        this.operators = list;
    }

    @Override
    public void init(Jep jep) {
        this.nf = jep.getNodeFactory();
    }

    protected Token errorToken(Lookahead2Iterator<Token> lookahead2Iterator) {
        Token token = lookahead2Iterator.peekNext();
        if (token == null) {
            Token token2 = lookahead2Iterator.prev();
            token = new TerminatorToken(JepMessages.getString("configurableparser.matchers.FunctionGrammarMatcher.TerminatorTokenName"));
            token.setPosition(token2.getLineNumber(), token2.getColumnNumber());
        }
        return token;
    }

    @Override
    public Node match(Lookahead2Iterator<Token> lookahead2Iterator, GrammarParser grammarParser) throws ParseException {
        ArrayList<Node> arrayList;
        PostfixMathCommandI postfixMathCommandI;
        String string;
        block11: {
            Token token = lookahead2Iterator.peekNext();
            if (token == null) {
                return null;
            }
            if (!token.isOperator()) {
                return null;
            }
            OperatorToken operatorToken = (OperatorToken)token;
            Operator operator = null;
            for (Operator serializable2 : this.operators) {
                if (operatorToken.getBinaryOp() != serializable2 && operatorToken.getPrefixOp() != serializable2 && operatorToken.getSuffixOp() != serializable2) continue;
                operator = serializable2;
            }
            if (operator == null) {
                return null;
            }
            string = token.getSource();
            postfixMathCommandI = operator.getPFMC();
            if (!this.open.equals(lookahead2Iterator.nextnext())) {
                return null;
            }
            lookahead2Iterator.consume();
            lookahead2Iterator.consume();
            if (this.close.equals(lookahead2Iterator.peekNext())) {
                if (!postfixMathCommandI.checkNumberOfParameters(0)) {
                    int arrayList2 = postfixMathCommandI.getNumberOfParameters();
                    if (arrayList2 >= 0) {
                        throw new GrammarException(MessageFormat.format(JepMessages.getString("FunctionRequiresNArgumentsFoundN"), postfixMathCommandI.getName(), arrayList2, 0), this.errorToken(lookahead2Iterator));
                    }
                    throw new GrammarException(MessageFormat.format(JepMessages.getString("FunctionIllegalNumberOfArguments"), postfixMathCommandI.getName(), 0), this.errorToken(lookahead2Iterator));
                }
                lookahead2Iterator.consume();
                return this.nf.buildFunctionNode(string, postfixMathCommandI, new Node[0]);
            }
            arrayList = new ArrayList<Node>();
            while (true) {
                Node n = grammarParser.parseSubExpression();
                arrayList.add(n);
                if (this.close.equals(lookahead2Iterator.peekNext())) break block11;
                if (!this.comma.equals(lookahead2Iterator.peekNext())) break;
                lookahead2Iterator.consume();
            }
            throw new GrammarException(MessageFormat.format(JepMessages.getString("configurableparser.matchers.FunctionGrammarMatcher.Function"), postfixMathCommandI.getName()), this.close, this.errorToken(lookahead2Iterator));
        }
        lookahead2Iterator.consume();
        if (!postfixMathCommandI.checkNumberOfParameters(arrayList.size())) {
            int n = postfixMathCommandI.getNumberOfParameters();
            if (n >= 0) {
                throw new GrammarException(MessageFormat.format(JepMessages.getString("FunctionRequiresNArgumentsFoundN"), postfixMathCommandI.getName(), n, arrayList.size()), this.errorToken(lookahead2Iterator));
            }
            throw new GrammarException(MessageFormat.format(JepMessages.getString("FunctionIllegalNumberOfArguments"), postfixMathCommandI.getName(), arrayList.size()), lookahead2Iterator.prev());
        }
        return this.nf.buildFunctionNode(string, postfixMathCommandI, arrayList.toArray(new Node[arrayList.size()]));
    }
}

