/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Variable;
import com.singularsys.jep.VariableTable;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class VariableTableObserver
implements Observer {
    boolean watchValues = true;
    Set<Observable> targets = new HashSet<Observable>();

    public VariableTableObserver(VariableTable variableTable) {
        this.addObservers(variableTable);
    }

    public VariableTableObserver(Jep jep) {
        this(jep.getVariableTable());
    }

    public VariableTableObserver(VariableTable variableTable, boolean bl) {
        this.addObservers(variableTable);
        this.watchValues = bl;
    }

    public VariableTableObserver(Jep jep, boolean bl) {
        this(jep.getVariableTable());
        this.watchValues = bl;
    }

    public void addObserver(Observable observable) {
        observable.addObserver(this);
        this.targets.add(observable);
    }

    public void addObservers(VariableTable variableTable) {
        this.addObserver(variableTable);
        if (this.watchValues) {
            for (Variable variable : variableTable.getVariables()) {
                this.addObserver(variable);
            }
        }
    }

    public void deleteObserver(Observable observable) {
        observable.addObserver(this);
        this.targets.remove(observable);
    }

    public void deleteObservers() {
        for (Observable observable : this.targets) {
            observable.deleteObserver(this);
        }
        this.targets.clear();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof VariableTable) {
            VariableTable variableTable = (VariableTable)observable;
            Variable variable = (Variable)object;
            if (variable == null) {
                this.deleteObservers();
                this.addObservers(variableTable);
                this.tableCleared(variableTable);
            } else if (variableTable.containsVariable(variable)) {
                if (this.watchValues) {
                    this.addObserver(variable);
                }
                this.variableAdded(variable);
            } else if (this.targets.contains(variable)) {
                if (this.watchValues) {
                    this.deleteObserver(variable);
                }
                this.variableRemoved(variable);
            }
        } else if (observable instanceof Variable) {
            this.variableChanged((Variable)observable);
        }
    }

    protected void variableChanged(Variable variable) {
        System.out.println(MessageFormat.format(JepMessages.getString("misc.VariableTableObserver.VariableValueChanged"), variable.getName(), variable.getValue()));
    }

    protected void variableAdded(Variable variable) {
        System.out.println(MessageFormat.format(JepMessages.getString("misc.VariableTableObserver.NewVariableAdded"), variable.getName(), variable.getValue()));
    }

    protected void variableRemoved(Variable variable) {
        System.out.println(MessageFormat.format(JepMessages.getString("misc.VariableTableObserver.VariableRemoved"), variable.getName()));
    }

    protected void tableCleared(VariableTable variableTable) {
        System.out.println(JepMessages.getString("misc.VariableTableObserver.VariableTableCleared."));
    }

    public Iterator<Observable> iterator() {
        return this.targets.iterator();
    }

    public boolean isWatchingValues() {
        return this.watchValues;
    }
}

