/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.bitwise;

import com.singularsys.jep.EmptyOperatorTable;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTable2;
import com.singularsys.jep.misc.bitwise.BitAnd;
import com.singularsys.jep.misc.bitwise.BitComp;
import com.singularsys.jep.misc.bitwise.BitOr;
import com.singularsys.jep.misc.bitwise.BitXor;
import com.singularsys.jep.misc.bitwise.LShift;
import com.singularsys.jep.misc.bitwise.RShift;
import com.singularsys.jep.misc.bitwise.URShift;
import com.singularsys.jep.standard.StandardOperatorTable2;

public class BitwiseOperatorTable
extends StandardOperatorTable2 {
    private static final long serialVersionUID = 300L;

    public BitwiseOperatorTable(String string, String string2) {
        super.setSpecialPfmcs();
        super.setPsudoPfmcs();
        this.addBitOperators(string, string2);
        this.setBitPfmcs();
    }

    public BitwiseOperatorTable(OperatorTable2 operatorTable2, String string, String string2) {
        super(operatorTable2);
        this.addBitOperators(string, string2);
        this.setBitPfmcs();
    }

    @Override
    protected void setBasicPfmcs() {
    }

    @Override
    protected void setSpecialPfmcs() {
    }

    @Override
    protected void setPsudoPfmcs() {
    }

    protected void addBitOperators(String string, String string2) {
        Operator operator = new Operator("~", null, 513);
        Operator operator2 = new Operator("<<", null, 6);
        Operator operator3 = new Operator(">>", null, 6);
        Operator operator4 = new Operator(">>>", null, 6);
        Operator operator5 = new Operator("&", null, 6);
        Operator operator6 = new Operator("|", null, 6);
        Operator operator7 = new Operator("XOR", null, null, 6);
        this.addOperator(BitwiseOperators.BITCOMP, operator, this.getNot());
        this.insertOperator(BitwiseOperators.LSHIFT, operator2, this.getLT());
        this.addOperator(BitwiseOperators.RSHIFT, operator3, operator2);
        this.addOperator(BitwiseOperators.URSHIFT, operator4, operator2);
        this.insertOperator(BitwiseOperators.BITOR, operator6, this.getOperator(OperatorTable2.BasicOperators.AND));
        this.insertOperator(BitwiseOperators.BITXOR, operator7, operator6);
        this.insertOperator(BitwiseOperators.BITAND, operator5, operator7);
        this.getPower().setSymbol(string);
        this.getBitXor().setSymbol(string2);
    }

    protected void setBitPfmcs() {
        this.getBitComp().setPFMC(new BitComp());
        this.getBitOr().setPFMC(new BitOr());
        this.getBitXor().setPFMC(new BitXor());
        this.getBitAnd().setPFMC(new BitAnd());
        this.getLShift().setPFMC(new LShift());
        this.getRShift().setPFMC(new RShift());
        this.getURShift().setPFMC(new URShift());
    }

    public Operator getBitAnd() {
        return this.getOperator(BitwiseOperators.BITAND);
    }

    public Operator getBitOr() {
        return this.getOperator(BitwiseOperators.BITOR);
    }

    public Operator getBitXor() {
        return this.getOperator(BitwiseOperators.BITXOR);
    }

    public Operator getBitComp() {
        return this.getOperator(BitwiseOperators.BITCOMP);
    }

    public Operator getLShift() {
        return this.getOperator(BitwiseOperators.LSHIFT);
    }

    public Operator getRShift() {
        return this.getOperator(BitwiseOperators.RSHIFT);
    }

    public Operator getURShift() {
        return this.getOperator(BitwiseOperators.URSHIFT);
    }

    public static enum BitwiseOperators implements EmptyOperatorTable.OperatorKey
    {
        BITAND,
        BITOR,
        BITXOR,
        BITCOMP,
        LSHIFT,
        RSHIFT,
        URSHIFT;

    }
}

