/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;

public class Case
extends PostfixMathCommand
implements CallbackEvaluationI {
    private static final long serialVersionUID = 330L;
    boolean hasDefault = false;
    Object defaultVal = null;
    NullBehaviour nullBehaviour = NullBehaviour.ERROR;

    public Case() {
        super(-1);
    }

    public Case(NullBehaviour nullBehaviour) {
        super(-1);
        this.nullBehaviour = nullBehaviour;
    }

    public Case(Object object) {
        super(-1);
        this.hasDefault = true;
        this.defaultVal = object;
    }

    public Case(Object object, NullBehaviour nullBehaviour) {
        super(-1);
        this.hasDefault = true;
        this.defaultVal = object;
        this.nullBehaviour = nullBehaviour;
    }

    public boolean isHasDefault() {
        return this.hasDefault;
    }

    public Object getDefaultVal() {
        return this.defaultVal;
    }

    public NullBehaviour getNullBehaviour() {
        return this.nullBehaviour;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n >= 3;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        int n = node.jjtGetNumChildren();
        Object object = evaluator.eval(node.jjtGetChild(0));
        if (object == null) {
            switch (this.nullBehaviour) {
                case ERROR: {
                    throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
                }
                case RETURN_NULL: {
                    return null;
                }
            }
        }
        for (int i = 1; i < n - 1; i += 2) {
            Object object2 = evaluator.eval(node.jjtGetChild(i));
            if ((object == null || !object.equals(object2)) && (object != null || object2 != null)) continue;
            Object object3 = evaluator.eval(node.jjtGetChild(i + 1));
            return object3;
        }
        if (n % 2 == 0) {
            Object object4 = evaluator.eval(node.jjtGetChild(n - 1));
            return object4;
        }
        if (this.hasDefault) {
            return this.defaultVal;
        }
        throw new EvaluationException(MessageFormat.format(JepMessages.getString("misc.functions.Case.NoArgumentsMatch"), this.getName(), object));
    }

    public static enum NullBehaviour {
        ERROR,
        RETURN_NULL,
        TEST_ARG;

    }
}

