/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.NaryFunction;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.text.MessageFormat;

public class ToBase
extends NaryFunction {
    private static final long serialVersionUID = 320L;
    int globalBase = -1;
    String prefix = "";

    public ToBase() {
        this.numberOfParameters = -1;
    }

    public ToBase(int n) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException(MessageFormat.format(JepMessages.getString("misc.functions.ToBase.BaseMustBeBetween"), "ToBase", n, 2, 36));
        }
        this.globalBase = n;
        this.numberOfParameters = -1;
    }

    public ToBase(int n, String string) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException(MessageFormat.format(JepMessages.getString("misc.functions.ToBase.BaseMustBeBetween"), "ToBase", n, 2, 36));
        }
        this.globalBase = n;
        this.numberOfParameters = -1;
        this.prefix = string;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        if (this.globalBase == -1) {
            return n == 2 || n == 3;
        }
        return n == 1 || n == 2;
    }

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        Object object;
        int n = this.curNumberOfParameters;
        int n2 = 0;
        int n3 = 0;
        if (n == 3 || this.globalBase != -1 && n == 2) {
            n2 = this.asStrictInt(n - 1, objectArray[n - 1]);
        }
        if (this.globalBase == -1) {
            object = objectArray[1];
            n3 = this.asStrictInt(1, object);
        } else {
            n3 = this.globalBase;
        }
        if (n3 < 2 || n3 > 36) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("misc.functions.ToBase.BaseMustBeBetween"), this.getName(), n3, 2, 36));
        }
        object = objectArray[0];
        String string = null;
        if (object instanceof Integer || object instanceof Short || object instanceof Long) {
            string = this.toBase(((Number)object).longValue(), n3);
        } else if (object instanceof Float || object instanceof Double || object instanceof Number) {
            string = this.toBase(((Number)object).doubleValue(), n3, n2);
        } else {
            throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
        }
        return string;
    }

    public String toBase(long l, int n) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException(MessageFormat.format(JepMessages.getString("misc.functions.ToBase.BaseMustBeBetween"), this.getName(), n, 2, 36));
        }
        if (l < 0L) {
            return '-' + this.prefix + Long.toString(-l, n);
        }
        return this.prefix + Long.toString(l, n);
    }

    public String toBase(double d, int n, int n2) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException(MessageFormat.format(JepMessages.getString("misc.functions.ToBase.BaseMustBeBetween"), this.getName(), n, 2, 36));
        }
        double d2 = d;
        StringBuffer stringBuffer = new StringBuffer();
        if (d2 < 0.0) {
            d2 = -d;
            stringBuffer.append('-');
        }
        stringBuffer.append(this.prefix);
        long l = Math.round(d2 *= Math.pow(n, n2));
        String string = Long.toString(l, n);
        if (string.length() <= n2) {
            stringBuffer.append("0.");
            for (int i = 0; i < n2 - string.length(); ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        } else if (n2 > 0) {
            stringBuffer.append(string);
            stringBuffer.insert(stringBuffer.length() - n2, '.');
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

