/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.lineNumbering;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.configurableparser.ConfigurableParser;
import com.singularsys.jep.configurableparser.GrammarParser;
import com.singularsys.jep.configurableparser.GrammarParserFactory;
import com.singularsys.jep.configurableparser.ShuntingYard;
import com.singularsys.jep.configurableparser.matchers.GrammarMatcher;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.misc.lineNumbering.LineNumberingNodeFactory;
import com.singularsys.jep.parser.Node;
import java.util.List;
import java.util.Stack;

public class LineNumberingShuntingYard
extends ShuntingYard {
    protected Stack<Position> posns = new Stack();
    private LineNumberingNodeFactory lnnf;

    public LineNumberingShuntingYard(Jep jep, List<GrammarMatcher> list) {
        super(jep, list);
        if (!(jep.getNodeFactory() instanceof LineNumberingNodeFactory)) {
            throw new RuntimeException(JepMessages.getString("LineNumberingShuntingYard.NodeFactoryDoesNotSupportLineNumbering"));
        }
        this.lnnf = (LineNumberingNodeFactory)jep.getNodeFactory();
    }

    @Override
    public Node parseSubExpression() throws ParseException {
        int n = this.lnnf.getCurrentLine();
        int n2 = this.lnnf.getCurrentColumn();
        try {
            Node node = super.parseSubExpression();
            this.lnnf.setCurrentPosition(n, n2);
            return node;
        }
        catch (ParseException parseException) {
            parseException.setPosition(this.lnnf.getCurrentLine(), this.lnnf.getCurrentColumn());
            throw parseException;
        }
    }

    @Override
    protected void popOp() throws ParseException {
        Position position = this.posns.pop();
        this.lnnf.setCurrentPosition(position.line, position.col);
        super.popOp();
    }

    @Override
    protected void prefix() throws ParseException {
        Token token = (Token)this.it.peekNext();
        if (token == null) {
            throw new ParseException(JepMessages.getString("misc.lineNumbering.LineNumberingShuntingYard.UnexpectedEndOfInput"));
        }
        this.lnnf.setCurrentPosition(token.getLineNumber(), token.getColumnNumber());
        super.prefix();
    }

    @Override
    protected void pushOp(Operator operator, Token token) throws ParseException {
        Position position = new Position(token.getLineNumber(), token.getColumnNumber());
        super.pushOp(operator, token);
        this.posns.push(position);
    }

    public static class LineNumberGrammarParserFactory
    implements GrammarParserFactory {
        private static final long serialVersionUID = 340L;

        @Override
        public GrammarParser newInstance(ConfigurableParser configurableParser) {
            return new LineNumberingShuntingYard(configurableParser.getJep(), configurableParser.getGrammarMatchers());
        }

        @Override
        public void init(Jep jep) {
        }

        @Override
        public JepComponent getLightWeightInstance() {
            return this;
        }
    }

    class Position {
        int line;
        int col;

        public Position(int n, int n2) {
            this.line = n;
            this.col = n2;
        }
    }
}

