/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.nullwrapper.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.misc.nullwrapper.functions.NullWrappedFunctionI;
import com.singularsys.jep.parser.Node;

public class NullWrappedLazyLogical
extends PostfixMathCommand
implements CallbackEvaluationI,
NullWrappedFunctionI {
    private static final long serialVersionUID = 350L;
    public static final int AND = 0;
    public static final int OR = 1;
    protected int id;
    protected boolean allowNumbers = true;

    public NullWrappedLazyLogical(int n) {
        this.id = n;
        this.numberOfParameters = 2;
    }

    public NullWrappedLazyLogical(int n, boolean bl) {
        this.id = n;
        this.numberOfParameters = 2;
        this.allowNumbers = !bl;
    }

    @Override
    public PostfixMathCommandI getRoot() {
        return this;
    }

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        boolean bl;
        Object object = evaluator.eval(node.jjtGetChild(0));
        boolean bl2 = false;
        boolean bl3 = false;
        if (object == null) {
            bl3 = true;
        } else {
            if (object instanceof Boolean) {
                bl2 = (Boolean)object;
            } else if (this.allowNumbers && object instanceof Number) {
                bl2 = ((Number)object).doubleValue() != 0.0;
            } else {
                throw new IllegalParameterException((PostfixMathCommandI)this, 0, this.allowNumbers ? JepMessages.getString("functions.ANumberOrBoolean") : JepMessages.getString("functions.ABoolean"), object);
            }
            switch (this.id) {
                case 0: {
                    if (bl2) break;
                    return Boolean.FALSE;
                }
                case 1: {
                    if (!bl2) break;
                    return Boolean.TRUE;
                }
            }
        }
        Object object2 = evaluator.eval(node.jjtGetChild(1));
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Boolean) {
            bl = (Boolean)object2;
        } else if (this.allowNumbers && object2 instanceof Number) {
            bl = ((Number)object2).doubleValue() != 0.0;
        } else {
            throw new IllegalParameterException((PostfixMathCommandI)this, 1, this.allowNumbers ? JepMessages.getString("functions.ANumberOrBoolean") : JepMessages.getString("functions.ABoolean"), object2);
        }
        switch (this.id) {
            case 0: {
                if (!bl) {
                    return Boolean.FALSE;
                }
                if (!bl3) {
                    return bl2;
                }
                return null;
            }
            case 1: {
                if (bl) {
                    return Boolean.TRUE;
                }
                if (!bl3) {
                    return bl2;
                }
                return null;
            }
        }
        return bl;
    }
}

