/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.threadsafeeval;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.Assign;
import com.singularsys.jep.functions.LValueI;
import com.singularsys.jep.misc.threadsafeeval.ThreadSafeEvaluator;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;

public class ThreadSafeAssign
extends Assign {
    private static final long serialVersionUID = 350L;

    @Override
    public Object evaluate(Node node, Evaluator evaluator) throws EvaluationException {
        if (node.jjtGetNumChildren() != 2) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.IncorrectNumberOfArgumentsExpected"), this.getName(), 2));
        }
        Object object = evaluator.eval(node.jjtGetChild(1));
        Node node2 = node.jjtGetChild(0);
        if (node2 instanceof ASTVarNode) {
            ASTVarNode aSTVarNode = (ASTVarNode)node2;
            Variable variable = aSTVarNode.getVar();
            if (evaluator instanceof ThreadSafeEvaluator) {
                variable = ((ThreadSafeEvaluator)evaluator).getVariable(variable.getName());
            }
            if (!variable.setValue(object)) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.AttemptToSetValueOfAConstantVariable"), this.getName(), variable.getName()));
            }
            return object;
        }
        if (node2 instanceof ASTFunNode && ((ASTFunNode)node2).getPFMC() instanceof LValueI) {
            ((LValueI)((Object)((ASTFunNode)node2).getPFMC())).set(evaluator, node2, object);
            return object;
        }
        throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.AssignmentShouldHaveAnLValue"), this.getName(), node2.toString()));
    }
}

