/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.reals;

import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.functions.Abs;
import com.singularsys.jep.functions.ArcCosine;
import com.singularsys.jep.functions.ArcCosineH;
import com.singularsys.jep.functions.ArcSine;
import com.singularsys.jep.functions.ArcSineH;
import com.singularsys.jep.functions.ArcTanH;
import com.singularsys.jep.functions.ArcTangent;
import com.singularsys.jep.functions.ArcTangent2;
import com.singularsys.jep.functions.Average;
import com.singularsys.jep.functions.Binomial;
import com.singularsys.jep.functions.Ceil;
import com.singularsys.jep.functions.Cosecant;
import com.singularsys.jep.functions.Cosine;
import com.singularsys.jep.functions.CosineH;
import com.singularsys.jep.functions.Cotangent;
import com.singularsys.jep.functions.Exp;
import com.singularsys.jep.functions.Floor;
import com.singularsys.jep.functions.If;
import com.singularsys.jep.functions.LogBase2;
import com.singularsys.jep.functions.Logarithm;
import com.singularsys.jep.functions.MinMax;
import com.singularsys.jep.functions.Modulus;
import com.singularsys.jep.functions.Power;
import com.singularsys.jep.functions.RInt;
import com.singularsys.jep.functions.Random;
import com.singularsys.jep.functions.Round;
import com.singularsys.jep.functions.Secant;
import com.singularsys.jep.functions.Signum;
import com.singularsys.jep.functions.Sine;
import com.singularsys.jep.functions.SineH;
import com.singularsys.jep.functions.SquareRoot;
import com.singularsys.jep.functions.StrictNaturalLogarithm;
import com.singularsys.jep.functions.Sum;
import com.singularsys.jep.functions.TanH;
import com.singularsys.jep.functions.Tangent;
import com.singularsys.jep.functions.VSum;

public class RealFunctionTable
extends FunctionTable {
    private static final long serialVersionUID = 300L;

    public RealFunctionTable() {
        this.addFunction("sin", new Sine());
        this.addFunction("cos", new Cosine());
        this.addFunction("tan", new Tangent());
        this.addFunction("asin", new ArcSine(true));
        this.addFunction("acos", new ArcCosine(true));
        this.addFunction("atan", new ArcTangent());
        this.addFunction("atan2", new ArcTangent2());
        this.addFunction("cosec", new Cosecant());
        this.addFunction("sec", new Secant());
        this.addFunction("cot", new Cotangent());
        this.addFunction("sinh", new SineH());
        this.addFunction("cosh", new CosineH());
        this.addFunction("tanh", new TanH());
        this.addFunction("asinh", new ArcSineH());
        this.addFunction("acosh", new ArcCosineH(true));
        this.addFunction("atanh", new ArcTanH(true));
        this.addFunction("log", new Logarithm(true));
        this.addFunction("ln", new StrictNaturalLogarithm());
        this.addFunction("lg", new LogBase2(true));
        this.addFunction("exp", new Exp());
        this.addFunction("sqrt", new SquareRoot(true));
        this.addFunction("pow", new Power(true));
        this.addFunction("round", new Round());
        this.addFunction("rint", new RInt());
        this.addFunction("floor", new Floor());
        this.addFunction("ceil", new Ceil());
        this.addFunction("avg", new Average());
        this.addFunction("min", new MinMax(true));
        this.addFunction("max", new MinMax(false));
        this.addFunction("vsum", new VSum());
        this.addFunction("abs", new Abs());
        this.addFunction("mod", new Modulus());
        this.addFunction("sum", new Sum());
        this.addFunction("rand", new Random());
        this.addFunction("if", new If());
        this.addFunction("binom", new Binomial());
        this.addFunction("signum", new Signum());
    }

    @Override
    public FunctionTable shallowCopy() {
        FunctionTable functionTable = super.shallowCopy();
        functionTable.addFunction("rand", new Random());
        return functionTable;
    }
}

