/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.standard;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.NaryBinaryFunction;
import com.singularsys.jep.functions.NaryFunction;
import com.singularsys.jep.functions.NullaryFunction;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Stack;

public class FastEvaluator
implements Evaluator,
ParserVisitor {
    private transient Stack<Object> stack = new Stack();
    protected boolean trapUnsetValues = true;
    protected boolean trapNullValues = true;
    protected boolean trapNaN = false;
    protected boolean trapInfinity = false;
    private static final long serialVersionUID = 300L;

    @Override
    public void init(Jep jep) {
    }

    @Override
    public Object eval(Node node) throws EvaluationException {
        Object object = null;
        object = this.nodeAccept(node);
        return object;
    }

    @Override
    public Object evaluate(Node node) throws EvaluationException {
        this.stack.clear();
        Object object = null;
        object = this.nodeAccept(node);
        if (this.stack.size() != 0) {
            throw new EvaluationException(JepMessages.getString("standard.FastEvaluator.StackCorrupted"));
        }
        return object;
    }

    protected Object nodeAccept(Node node) throws EvaluationException {
        switch (node.getId()) {
            case 2: {
                return this.visitFun(node);
            }
            case 3: {
                return this.visitVar(node);
            }
            case 4: {
                return this.visitFun(node);
            }
            case 5: {
                return this.visitConstant(node);
            }
        }
        try {
            return node.jjtAccept(this, null);
        }
        catch (EvaluationException evaluationException) {
            throw evaluationException;
        }
        catch (JepException jepException) {
            throw new EvaluationException(jepException);
        }
    }

    @Override
    public Object visit(ASTConstant aSTConstant, Object object) throws EvaluationException {
        return this.visitConstant(aSTConstant);
    }

    public Object visitConstant(Node node) throws EvaluationException {
        Object object = node.getValue();
        if (this.trapNullValues && object == null) {
            throw new EvaluationException(JepMessages.getString("standard.FastEvaluator.NullConstantValue"));
        }
        if (this.trapNaN && (object instanceof Double && ((Double)object).isNaN() || object instanceof Float && ((Float)object).isNaN())) {
            throw new EvaluationException(JepMessages.getString("standard.FastEvaluator.NaNConstantValue"));
        }
        if (this.trapInfinity && (object instanceof Double && ((Double)object).isInfinite() || object instanceof Float && ((Float)object).isInfinite())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.InfiniteConstantValue"), object.toString()));
        }
        return object;
    }

    @Override
    public Object visit(ASTVarNode aSTVarNode, Object object) throws EvaluationException {
        return this.visitVar(aSTVarNode);
    }

    public Object visitVar(Node node) throws EvaluationException {
        Variable variable = node.getVar();
        assert (variable != null);
        if (this.trapUnsetValues && !variable.hasValidValue()) {
            String string = MessageFormat.format(JepMessages.getString("standard.FastEvaluator.CouldNotEvaluateVariableNoValueSet"), variable.getName());
            throw new EvaluationException(string);
        }
        Object object = variable.getValue();
        if (this.trapNullValues && object == null) {
            String string = MessageFormat.format(JepMessages.getString("standard.FastEvaluator.CouldNotEvaluateVariableNullValue"), variable.getName());
            throw new EvaluationException(string);
        }
        if (this.trapNaN && (object instanceof Double && ((Double)object).isNaN() || object instanceof Float && ((Float)object).isNaN())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.NaNValueForVariable"), variable.getName()));
        }
        if (this.trapInfinity && (object instanceof Double && ((Double)object).isInfinite() || object instanceof Float && ((Float)object).isInfinite())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.InfiniteValueForVariable"), object.toString(), variable.getName()));
        }
        return object;
    }

    @Override
    public Object visit(ASTFunNode aSTFunNode, Object object) throws EvaluationException {
        return this.visitFun(aSTFunNode);
    }

    @Override
    public Object visit(ASTOpNode aSTOpNode, Object object) throws EvaluationException {
        return this.visitFun(aSTOpNode);
    }

    protected Object visitFun(Node node) throws EvaluationException {
        Object object;
        PostfixMathCommandI postfixMathCommandI = node.getPFMC();
        int n = node.jjtGetNumChildren();
        if (postfixMathCommandI == null) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.NoFunctionClass"), node.getName()));
        }
        if (postfixMathCommandI instanceof CallbackEvaluationI) {
            object = ((CallbackEvaluationI)((Object)postfixMathCommandI)).evaluate(node, this);
        } else if (postfixMathCommandI instanceof UnaryFunction) {
            if (n != 1) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.IncorrectNumberOfArgumentsExpected"), node.getName(), n, 1));
            }
            Object object2 = this.nodeAccept(node.jjtGetChild(0));
            object = ((UnaryFunction)postfixMathCommandI).eval(object2);
        } else if (postfixMathCommandI instanceof BinaryFunction) {
            if (n != 2) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.IncorrectNumberOfArgumentsExpected"), node.getName(), n, 2));
            }
            Object object3 = this.nodeAccept(node.jjtGetChild(0));
            Object object4 = this.nodeAccept(node.jjtGetChild(1));
            object = ((BinaryFunction)postfixMathCommandI).eval(object3, object4);
        } else if (postfixMathCommandI instanceof NaryBinaryFunction) {
            switch (n) {
                case 0: {
                    throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.IncorrectNumberOfArgumentsNonZero"), node.getName(), n));
                }
                case 1: {
                    object = this.nodeAccept(node.jjtGetChild(0));
                    break;
                }
                case 2: {
                    Object object5 = this.nodeAccept(node.jjtGetChild(0));
                    Object object6 = this.nodeAccept(node.jjtGetChild(1));
                    object = ((NaryBinaryFunction)postfixMathCommandI).eval(object5, object6);
                    break;
                }
                default: {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        Node node2 = node.jjtGetChild(i);
                        objectArray[i] = this.nodeAccept(node2);
                    }
                    postfixMathCommandI.setCurNumberOfParameters(n);
                    object = ((NaryBinaryFunction)postfixMathCommandI).eval(objectArray);
                    break;
                }
            }
        } else if (postfixMathCommandI instanceof NaryFunction) {
            if (!postfixMathCommandI.checkNumberOfParameters(n)) {
                String string = postfixMathCommandI.getNumberOfParameters() > -1 ? MessageFormat.format(JepMessages.getString("standard.FastEvaluator.IncorrectNumberOfArgumentsExpected"), node.getName(), n, postfixMathCommandI.getNumberOfParameters()) : MessageFormat.format(JepMessages.getString("standard.FastEvaluator.IncorrectNumberOfArguments"), node.getName(), n);
                throw new EvaluationException(string);
            }
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                Node node3 = node.jjtGetChild(i);
                objectArray[i] = this.nodeAccept(node3);
            }
            postfixMathCommandI.setCurNumberOfParameters(n);
            object = ((NaryFunction)postfixMathCommandI).eval(objectArray);
        } else if (postfixMathCommandI instanceof NullaryFunction) {
            if (n != 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.IncorrectNumberOfArgumentsExpected"), node.getName(), n, 0));
            }
            object = ((NullaryFunction)postfixMathCommandI).eval();
        } else {
            if (!postfixMathCommandI.checkNumberOfParameters(n)) {
                String string = postfixMathCommandI.getNumberOfParameters() > -1 ? MessageFormat.format(JepMessages.getString("standard.FastEvaluator.IncorrectNumberOfArgumentsExpected"), node.getName(), n, postfixMathCommandI.getNumberOfParameters()) : MessageFormat.format(JepMessages.getString("standard.FastEvaluator.IncorrectNumberOfArguments"), node.getName(), n);
                throw new EvaluationException(string);
            }
            Object object7 = null;
            for (int i = 0; i < n; ++i) {
                Node node4 = node.jjtGetChild(i);
                object7 = this.nodeAccept(node4);
                this.stack.push(object7);
            }
            postfixMathCommandI.setCurNumberOfParameters(n);
            postfixMathCommandI.run(this.stack);
            object = this.stack.pop();
        }
        if (this.trapNullValues && object == null) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.NullValueForFunction"), node.getName()));
        }
        if (this.trapNaN && (object instanceof Double && ((Double)object).isNaN() || object instanceof Float && ((Float)object).isNaN())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.NaNValueForFunction"), node.getName()));
        }
        if (this.trapInfinity && (object instanceof Double && ((Double)object).isInfinite() || object instanceof Float && ((Float)object).isInfinite())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.FastEvaluator.InfiniteValueForFunction"), node.getName(), object.toString()));
        }
        return object;
    }

    public boolean isTrapUnsetValues() {
        return this.trapUnsetValues;
    }

    public void setTrapUnsetValues(boolean bl) {
        this.trapUnsetValues = bl;
    }

    public boolean isTrapNullValues() {
        return this.trapNullValues;
    }

    public void setTrapNullValues(boolean bl) {
        this.trapNullValues = bl;
    }

    public boolean isTrapNaN() {
        return this.trapNaN;
    }

    public void setTrapNaN(boolean bl) {
        this.trapNaN = bl;
    }

    public boolean isTrapInfinity() {
        return this.trapInfinity;
    }

    public void setTrapInfinity(boolean bl) {
        this.trapInfinity = bl;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        FastEvaluator fastEvaluator = new FastEvaluator();
        fastEvaluator.trapNullValues = this.trapNullValues;
        fastEvaluator.trapNaN = this.trapNaN;
        fastEvaluator.trapInfinity = this.trapInfinity;
        return fastEvaluator;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stack = new Stack();
    }
}

