/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.walkers;

import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;

public class DoNothingVisitor
implements ParserVisitor,
JepComponent {
    private static final long serialVersionUID = 340L;
    protected Jep jep;
    protected NodeFactory nf;
    protected VariableTable vt;
    protected FunctionTable ft;
    protected OperatorTableI ot;

    public DoNothingVisitor() {
    }

    public DoNothingVisitor(Jep jep) {
        this.myInit(jep);
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return this;
    }

    @Override
    public void init(Jep jep) {
        this.myInit(jep);
    }

    private void myInit(Jep jep) {
        this.jep = jep;
        this.ft = jep.getFunctionTable();
        this.nf = jep.getNodeFactory();
        this.ot = jep.getOperatorTable();
        this.vt = jep.getVariableTable();
    }

    public Node visit(Node node) throws JepException {
        return this.visitNode(node, null);
    }

    public Node visitNode(Node node, Object object) throws JepException {
        if (node instanceof ASTConstant) {
            return (Node)this.visit((ASTConstant)node, object);
        }
        if (node instanceof ASTVarNode) {
            return (Node)this.visit((ASTVarNode)node, object);
        }
        if (node instanceof ASTOpNode) {
            return (Node)this.visit((ASTOpNode)node, object);
        }
        if (node instanceof ASTFunNode) {
            return (Node)this.visit((ASTFunNode)node, object);
        }
        throw new JepException(MessageFormat.format(JepMessages.getString("IllegalNodeTypeEncountered"), node.getClass().getSimpleName()));
    }

    protected Node[] visitChildren(Node node, Object object) throws JepException {
        int n = node.jjtGetNumChildren();
        Node[] nodeArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = this.visitNode(node.jjtGetChild(i), object);
        }
        return nodeArray;
    }

    @Override
    public Object visit(ASTConstant aSTConstant, Object object) throws JepException {
        return aSTConstant;
    }

    @Override
    public Object visit(ASTVarNode aSTVarNode, Object object) throws JepException {
        return aSTVarNode;
    }

    @Override
    public Object visit(ASTFunNode aSTFunNode, Object object) throws JepException {
        Node[] nodeArray = this.visitChildren(aSTFunNode, object);
        return this.copyChildrenIfNeeded(aSTFunNode, nodeArray);
    }

    @Override
    public Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        Node[] nodeArray = this.visitChildren(aSTOpNode, object);
        return this.copyChildrenIfNeeded(aSTOpNode, nodeArray);
    }

    protected Node copyChildrenIfNeeded(Node node, Node[] nodeArray) throws JepException {
        boolean bl = this.childrenHaveChanged(node, nodeArray);
        if (!bl) {
            return node;
        }
        if (node instanceof ASTOpNode) {
            return this.nf.buildOperatorNode(((ASTOpNode)node).getOperator(), nodeArray);
        }
        return this.nf.buildFunctionNode((ASTFunNode)node, nodeArray);
    }

    protected boolean childrenHaveChanged(Node node, Node[] nodeArray) {
        boolean bl = false;
        int n = node.jjtGetNumChildren();
        if (n != nodeArray.length) {
            bl = true;
        } else {
            for (int i = 0; i < n; ++i) {
                if (node.jjtGetChild(i) == nodeArray[i]) continue;
                bl = true;
            }
        }
        return bl;
    }

    public NodeFactory getNodeFactory() {
        return this.nf;
    }

    public OperatorTableI getOperatorTable() {
        return this.ot;
    }

    public VariableTable getVariableTable() {
        return this.vt;
    }

    public FunctionTable getFunctionTable() {
        return this.ft;
    }
}

