/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.walkers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import com.singularsys.jep.walkers.PostfixTreeWalker;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class SerializableExpression
extends PostfixTreeWalker
implements Externalizable {
    private static final long serialVersionUID = 300L;
    private final List<Element> list = new ArrayList<Element>();
    private static final byte END = -1;
    private static final byte VAR = 1;
    private static final byte FUN = 2;
    private static final byte OP = 3;
    private static final byte BOOLEAN = 4;
    private static final byte BYTE = 5;
    private static final byte CHAR = 6;
    private static final byte SHORT = 7;
    private static final byte INT = 8;
    private static final byte LONG = 9;
    private static final byte FLOAT = 10;
    private static final byte DOUBLE = 11;
    private static final byte STRING = 12;
    private static final byte COMPLEX = 13;
    private static final byte OBJECT = 14;

    public SerializableExpression(Node node) throws JepException {
        this.walk(node);
    }

    public SerializableExpression() {
    }

    public final Node toNode(Jep jep) throws JepException {
        Stack<Node> stack = new Stack<Node>();
        for (Element element : this.list) {
            element.extract(stack, jep);
        }
        if (stack.size() != 1) {
            throw new JepException(MessageFormat.format(JepMessages.getString("walkers.SerializableExpression.StackCorruptedSizeN"), stack.size()));
        }
        Node node = (Node)stack.pop();
        return node;
    }

    @Override
    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        for (Element element : this.list) {
            element.write(objectOutput);
        }
        objectOutput.writeByte(-1);
    }

    @Override
    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by;
        while ((by = objectInput.readByte()) != -1) {
            switch (by) {
                case 1: {
                    String string = objectInput.readUTF();
                    this.list.add(new Variable(string));
                    break;
                }
                case 2: {
                    String string = objectInput.readUTF();
                    int n = objectInput.readInt();
                    this.list.add(new Function(string, n));
                    break;
                }
                case 3: {
                    String string = objectInput.readUTF();
                    int n = objectInput.readInt();
                    this.list.add(new Operator(string, n));
                    break;
                }
                case 4: {
                    Boolean bl = objectInput.readBoolean();
                    this.list.add(new Constant(bl));
                    break;
                }
                case 5: {
                    Byte by2 = objectInput.readByte();
                    this.list.add(new Constant(by2));
                    break;
                }
                case 6: {
                    Character c = Character.valueOf(objectInput.readChar());
                    this.list.add(new Constant(c));
                    break;
                }
                case 7: {
                    Short s = objectInput.readShort();
                    this.list.add(new Constant(s));
                    break;
                }
                case 8: {
                    Integer n = objectInput.readInt();
                    this.list.add(new Constant(n));
                    break;
                }
                case 9: {
                    Long l = objectInput.readLong();
                    this.list.add(new Constant(l));
                    break;
                }
                case 10: {
                    Float f = Float.valueOf(objectInput.readFloat());
                    this.list.add(new Constant(f));
                    break;
                }
                case 11: {
                    Double d = objectInput.readDouble();
                    this.list.add(new Constant(d));
                    break;
                }
                case 12: {
                    String string = objectInput.readUTF();
                    this.list.add(new Constant(string));
                    break;
                }
                case 13: {
                    double d = objectInput.readDouble();
                    double d2 = objectInput.readDouble();
                    this.list.add(new Constant(new Complex(d, d2)));
                    break;
                }
                case 14: {
                    Object object = objectInput.readObject();
                    this.list.add(new Constant(object));
                }
            }
        }
    }

    @Override
    protected void visit(ASTFunNode aSTFunNode, int n, int n2) throws JepException {
        this.list.add(new Function(aSTFunNode.getName(), n));
    }

    @Override
    protected void visit(ASTOpNode aSTOpNode, int n, int n2) throws JepException {
        this.list.add(new Operator(aSTOpNode.getName(), n));
    }

    @Override
    protected void visit(ASTVarNode aSTVarNode, int n, int n2) throws JepException {
        this.list.add(new Variable(aSTVarNode.getName()));
    }

    @Override
    protected void visit(ASTConstant aSTConstant, int n, int n2) throws JepException {
        this.list.add(new Constant(aSTConstant.getValue()));
    }

    public Iterator<Element> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    public String toString() {
        return this.list.toString();
    }

    public static class Operator
    implements Element {
        String name;
        int nargs;

        Operator(String string, int n) {
            this.name = string;
            this.nargs = n;
        }

        @Override
        public void extract(Stack<Node> stack, Jep jep) throws ParseException {
            Node[] nodeArray = new Node[this.nargs];
            for (int i = this.nargs - 1; i >= 0; --i) {
                nodeArray[i] = stack.pop();
            }
            ASTOpNode aSTOpNode = jep.getNodeFactory().buildOperatorNode(jep.getOperatorTable().getOperatorsByName(this.name), nodeArray);
            stack.push(aSTOpNode);
        }

        @Override
        public void write(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(3);
            objectOutput.writeUTF(this.name);
            objectOutput.writeInt(this.nargs);
        }

        public String getName() {
            return this.name;
        }

        public int getNargs() {
            return this.nargs;
        }

        public String toString() {
            return MessageFormat.format(JepMessages.getString("walkers.SerializableExpression.Operator"), this.name, this.nargs);
        }
    }

    public static class Function
    implements Element {
        String name;
        int nargs;

        Function(String string, int n) {
            this.name = string;
            this.nargs = n;
        }

        @Override
        public void extract(Stack<Node> stack, Jep jep) throws ParseException {
            Node[] nodeArray = new Node[this.nargs];
            for (int i = this.nargs - 1; i >= 0; --i) {
                nodeArray[i] = stack.pop();
            }
            ASTFunNode aSTFunNode = jep.getNodeFactory().buildFunctionNode(this.name, jep.getFunctionTable().getFunction(this.name), nodeArray);
            stack.push(aSTFunNode);
        }

        @Override
        public void write(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(2);
            objectOutput.writeUTF(this.name);
            objectOutput.writeInt(this.nargs);
        }

        public String getName() {
            return this.name;
        }

        public int getNargs() {
            return this.nargs;
        }

        public String toString() {
            return MessageFormat.format(JepMessages.getString("walkers.SerializableExpression.Function"), this.name, this.nargs);
        }
    }

    public static class Variable
    implements Element {
        String name;

        Variable(String string) {
            this.name = string;
        }

        @Override
        public void extract(Stack<Node> stack, Jep jep) throws ParseException {
            ASTVarNode aSTVarNode = jep.getNodeFactory().buildVariableNodeCheckUndeclared(this.name);
            stack.push(aSTVarNode);
        }

        @Override
        public void write(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(1);
            objectOutput.writeUTF(this.name);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return MessageFormat.format(JepMessages.getString("walkers.SerializableExpression.Variable"), this.name);
        }
    }

    public static class Constant
    implements Element {
        Object value;

        Constant(Object object) {
            this.value = object;
        }

        @Override
        public void extract(Stack<Node> stack, Jep jep) throws ParseException {
            ASTConstant aSTConstant = jep.getNodeFactory().buildConstantNode(this.value);
            stack.push(aSTConstant);
        }

        @Override
        public void write(ObjectOutput objectOutput) throws IOException {
            if (this.value instanceof Double) {
                objectOutput.writeByte(11);
                objectOutput.writeDouble((Double)this.value);
            } else if (this.value instanceof Boolean) {
                objectOutput.writeByte(4);
                objectOutput.writeBoolean((Boolean)this.value);
            } else if (this.value instanceof Byte) {
                objectOutput.writeByte(5);
                objectOutput.writeByte(((Byte)this.value).byteValue());
            } else if (this.value instanceof Character) {
                objectOutput.writeByte(6);
                objectOutput.writeChar(((Character)this.value).charValue());
            } else if (this.value instanceof Short) {
                objectOutput.writeByte(7);
                objectOutput.writeShort(((Short)this.value).shortValue());
            } else if (this.value instanceof Integer) {
                objectOutput.writeByte(8);
                objectOutput.writeInt((Integer)this.value);
            } else if (this.value instanceof Long) {
                objectOutput.writeByte(9);
                objectOutput.writeLong((Long)this.value);
            } else if (this.value instanceof Float) {
                objectOutput.writeByte(10);
                objectOutput.writeFloat(((Float)this.value).floatValue());
            } else if (this.value instanceof Complex) {
                objectOutput.writeByte(13);
                Complex complex = (Complex)this.value;
                objectOutput.writeDouble(complex.re());
                objectOutput.writeDouble(complex.im());
            } else if (this.value instanceof String) {
                objectOutput.writeByte(12);
                objectOutput.writeUTF((String)this.value);
            } else {
                objectOutput.writeByte(14);
                objectOutput.writeObject(this.value);
            }
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return MessageFormat.format(JepMessages.getString("walkers.SerializableExpression.Constant"), this.value);
        }
    }

    public static interface Element {
        public void extract(Stack<Node> var1, Jep var2) throws ParseException;

        public void write(ObjectOutput var1) throws IOException;
    }
}

