/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.walkers;

import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Operator;
import com.singularsys.jep.Variable;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.PostfixTreeWalker;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TreeAnalyzer
extends PostfixTreeWalker {
    Map<Variable, Integer> variables = new TreeMap<Variable, Integer>(new VariableComparitor());
    Map<String, Integer> functions = new TreeMap<String, Integer>();
    Map<Operator, Integer> operators = new HashMap<Operator, Integer>();
    Map<Object, Integer> constants = new HashMap<Object, Integer>();
    int maxDepth = 0;
    int numNodes = 0;
    int numFuns = 0;
    int numOps = 0;
    int numVars = 0;
    int numConst = 0;

    public TreeAnalyzer(Node node) throws JepException {
        this.walk(node);
    }

    public TreeAnalyzer() {
    }

    public void analyze(Node node) throws JepException {
        this.walk(node);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.NodesDepth"), this.numNodes, this.maxDepth));
        stringBuilder.append(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.Variables"), this.numVars));
        int n = 0;
        for (Map.Entry<Variable, Integer> entry : this.variables.entrySet()) {
            if (n++ > 0) {
                stringBuilder.append(JepMessages.getString("walkers.TreeAnalyzer.Comma"));
            }
            stringBuilder.append(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.NameNumber"), entry.getKey().getName(), entry.getValue()));
        }
        stringBuilder.append(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.Functions"), this.numFuns));
        n = 0;
        for (Map.Entry<Object, Integer> entry : this.functions.entrySet()) {
            if (n++ > 0) {
                stringBuilder.append(JepMessages.getString("walkers.TreeAnalyzer.Comma"));
            }
            stringBuilder.append(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.NameNumber"), entry.getKey(), entry.getValue()));
        }
        n = 0;
        stringBuilder.append(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.Operators"), this.numOps));
        for (Map.Entry<Object, Integer> entry : this.operators.entrySet()) {
            if (n++ > 0) {
                stringBuilder.append(JepMessages.getString("walkers.TreeAnalyzer.Comma"));
            }
            stringBuilder.append(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.NameNumber"), ((Operator)entry.getKey()).getName(), entry.getValue()));
        }
        stringBuilder.append(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.Constants"), this.numConst));
        n = 0;
        for (Map.Entry<Object, Integer> entry : this.constants.entrySet()) {
            if (n++ > 0) {
                stringBuilder.append(JepMessages.getString("walkers.TreeAnalyzer.Comma"));
            }
            stringBuilder.append(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.NameNumber"), entry.getKey(), entry.getValue()));
        }
        return stringBuilder.toString();
    }

    public String summary() {
        StringBuilder stringBuilder = new StringBuilder(MessageFormat.format(JepMessages.getString("walkers.TreeAnalyzer.SummaryString"), this.numNodes, this.maxDepth, this.variables.size(), this.numVars, this.functions.size(), this.numFuns, this.operators.size(), this.numOps, this.constants.size(), this.numConst));
        return stringBuilder.toString();
    }

    @Override
    protected void visit(ASTFunNode aSTFunNode, int n, int n2) {
        ++this.numNodes;
        ++this.numFuns;
        this.maxDepth = n2 > this.maxDepth ? n2 : this.maxDepth;
        Integer n3 = this.functions.get(aSTFunNode.getName());
        n3 = n3 == null ? 1 : n3 + 1;
        this.functions.put(aSTFunNode.getName(), n3);
    }

    @Override
    protected void visit(ASTOpNode aSTOpNode, int n, int n2) {
        ++this.numNodes;
        ++this.numOps;
        this.maxDepth = n2 > this.maxDepth ? n2 : this.maxDepth;
        Integer n3 = this.operators.get(aSTOpNode.getOperator());
        n3 = n3 == null ? 1 : n3 + 1;
        this.operators.put(aSTOpNode.getOperator(), n3);
    }

    @Override
    protected void visit(ASTVarNode aSTVarNode, int n, int n2) {
        ++this.numNodes;
        ++this.numVars;
        this.maxDepth = n2 > this.maxDepth ? n2 : this.maxDepth;
        Integer n3 = this.variables.get(aSTVarNode.getVar());
        n3 = n3 == null ? 1 : n3 + 1;
        this.variables.put(aSTVarNode.getVar(), n3);
    }

    @Override
    protected void visit(ASTConstant aSTConstant, int n, int n2) {
        ++this.numNodes;
        ++this.numConst;
        this.maxDepth = n2 > this.maxDepth ? n2 : this.maxDepth;
        Integer n3 = this.constants.get(aSTConstant.getValue());
        n3 = n3 == null ? 1 : n3 + 1;
        this.constants.put(aSTConstant.getValue(), n3);
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getNumConst() {
        return this.numConst;
    }

    public int getNumFunctions() {
        return this.numFuns;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumOperators() {
        return this.numOps;
    }

    public int getNumVariables() {
        return this.numVars;
    }

    public int getNumUniqueVariables() {
        return this.variables.size();
    }

    public Map<Operator, Integer> getOperators() {
        return this.operators;
    }

    public Map<Variable, Integer> getVariables() {
        return this.variables;
    }

    public String[] getVariableNames() {
        Object[] objectArray = new String[this.variables.size()];
        int n = 0;
        for (Variable variable : this.variables.keySet()) {
            objectArray[n++] = variable.getName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public Map<String, Integer> getFunctions() {
        return this.functions;
    }

    public Map<Object, Integer> getConstants() {
        return this.constants;
    }

    public void merge(TreeAnalyzer treeAnalyzer) {
        Integer n;
        for (Map.Entry<Variable, Integer> entry : treeAnalyzer.variables.entrySet()) {
            n = this.variables.get(entry.getKey());
            n = (n == null ? 0 : n) + entry.getValue();
            this.variables.put(entry.getKey(), n);
        }
        for (Map.Entry<Object, Integer> entry : treeAnalyzer.functions.entrySet()) {
            n = this.functions.get(entry.getKey());
            n = (n == null ? 0 : n) + entry.getValue();
            this.functions.put((String)entry.getKey(), n);
        }
        for (Map.Entry<Object, Integer> entry : treeAnalyzer.operators.entrySet()) {
            n = this.operators.get(entry.getKey());
            n = (n == null ? 0 : n) + entry.getValue();
            this.operators.put((Operator)entry.getKey(), n);
        }
        for (Map.Entry<Object, Integer> entry : treeAnalyzer.constants.entrySet()) {
            n = this.constants.get(entry.getKey());
            n = (n == null ? 0 : n) + entry.getValue();
            this.constants.put(entry.getKey(), n);
        }
        this.maxDepth = treeAnalyzer.maxDepth > this.maxDepth ? treeAnalyzer.maxDepth : this.maxDepth;
        this.numConst += treeAnalyzer.numConst;
        this.numFuns += treeAnalyzer.numFuns;
        this.numNodes += treeAnalyzer.numNodes;
        this.numOps += treeAnalyzer.numOps;
        this.numVars += treeAnalyzer.numVars;
    }

    static class VariableComparitor
    implements Comparator<Variable>,
    Serializable {
        private static final long serialVersionUID = 330L;

        VariableComparitor() {
        }

        @Override
        public int compare(Variable variable, Variable variable2) {
            return variable.getName().compareTo(variable2.getName());
        }
    }
}

