/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import de.didappslib.base.Document;
import de.didappslib.base.Statics;
import de.didappslib.base.Tabelle;
import de.didappslib.guitools.AutoDialog;
import de.didappslib.guitools.TableImportDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class VergleichsTabelle
extends Tabelle
implements MouseListener,
ListSelectionListener,
ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/Tabelle", Statics.locale);
    private final VergleichsTabelle me = this;
    private final JPopupMenu popup = new JPopupMenu();
    private JPopupMenu headerPopup;
    private final JMenu nachkStellenMenu = new JMenu(this.rbundle.getString("Nachkommastellen"));
    private boolean isEditible = true;
    private int aktiveSpalte;
    private String[] spaltenNamen = new String[]{" "};
    private Double[][] tabData;
    private final int rowAnz_std = 50;

    public VergleichsTabelle(Document prj, int t) {
        this.document = prj;
        this.type = t;
        ActionListener al = e -> this.handlePopupMenu(e.getActionCommand());
        JMenuItem mit = new JMenuItem(this.rbundle.getString("Ausschneiden"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JMenuItem(this.rbundle.getString("Kopieren"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JMenuItem(this.rbundle.getString("Einfuegen"));
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.add(new JSeparator());
        mit = new JMenuItem(this.rbundle.getString("Alles_Auswaehlen"));
        mit.addActionListener(al);
        this.popup.add(mit);
        mit = new JMenuItem(this.rbundle.getString("Auswahl_aufheben"));
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.add(new JSeparator());
        mit = new JMenuItem(this.rbundle.getString("Wissenschaftliche_Notation"));
        mit.addActionListener(al);
        this.popup.add(mit);
        this.popup.add(this.nachkStellenMenu);
        for (int i = 0; i < 10; ++i) {
            mit = new JCheckBoxMenuItem("" + i);
            mit.addActionListener(al);
            this.nachkStellenMenu.add(mit);
        }
        this.tabData = new Double[50][1];
        this.tab = new JTable(new myTableModel(this.spaltenNamen, this.tabData));
        this.tab.setBackground(new Color(238, 255, 234));
        this.tab.setSelectionBackground(new Color(218, 235, 214));
        this.tab.setDefaultRenderer(Double.class, new MyCellRenderer());
        this.tab.setDefaultEditor(Double.class, new MyCellEditor());
        this.tab.setGridColor(Color.LIGHT_GRAY);
        this.tab.addMouseListener(this.me);
        this.tab.getTableHeader().setDefaultRenderer(new Tabelle.MyHeaderCellRenderer(this));
        this.tab.getSelectionModel().addListSelectionListener(this.me);
        this.tab.getTableHeader().setReorderingAllowed(false);
        this.tab.getTableHeader().setResizingAllowed(false);
        this.tab.getTableHeader().addMouseListener(this.me);
        this.tab.addKeyListener(new MyKeyListener());
        for (int j = 0; j < this.tab.getColumnCount(); ++j) {
            this.tab.getColumnModel().getColumn(j).setMinWidth(40);
        }
        this.setMinimumSize(new Dimension(240, 30));
        this.setViewportView(this.tab);
        this.updateTab();
    }

    @Override
    public void updateTab() {
        if (this.document.getModel() == null) {
            return;
        }
        int jj = this.document.getModel().WERTENVAR;
        if (jj > this.spaltenNamen.length) {
            this.spaltenNamen = this.document.getModel().getSpaltenNamen();
            this.createNewTabData(this.getRowCount(), this.spaltenNamen.length);
        }
        this.tab.setModel(new myTableModel(this.spaltenNamen, this.tabData));
    }

    public final void update(Double[][] data, String[] snamen) {
        if (this.document.getModel() == null) {
            return;
        }
        this.tabData = data;
        this.spaltenNamen = snamen;
        this.tab.setModel(new myTableModel(this.spaltenNamen, this.tabData));
    }

    @Override
    void handlePopupMenu(String cmd) {
        if (cmd.equals(this.rbundle.getString("Ausschneiden"))) {
            this.cutCells();
            return;
        }
        if (cmd.equals(this.rbundle.getString("Kopieren"))) {
            this.toClipboard(false);
            return;
        }
        if (cmd.equals(this.rbundle.getString("Einfuegen"))) {
            this.fromClipboard();
            return;
        }
        if (cmd.equals(this.rbundle.getString("Alles_Auswaehlen"))) {
            this.tab.selectAll();
            this.repaint();
            return;
        }
        if (cmd.equals(this.rbundle.getString("Auswahl_aufheben"))) {
            this.tab.removeRowSelectionInterval(0, this.tab.getRowCount() - 1);
            this.repaint();
            return;
        }
        if (cmd.equals(this.rbundle.getString("Wissenschaftliche_Notation"))) {
            this.toScientificNotation();
            this.document.getViewer().showHideTable(1.0);
            return;
        }
        if (cmd.equals(this.rbundle.getString("Dezimale_Notation"))) {
            this.toDecimalNotation();
            this.document.getViewer().showHideTable(1.0);
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (!cmd.equals("" + i)) continue;
            this.setzeStellenAnz(i);
            this.document.getViewer().showHideTable(1.0);
            return;
        }
        this.spaltenNamen[this.aktiveSpalte] = cmd;
        this.updateTab();
        this.document.getDiagramm().updateDiagramPlus();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.aktiveSpalte = this.tab.columnAtPoint(e.getPoint());
        if (e.isPopupTrigger()) {
            if (e.getComponent() instanceof JTableHeader) {
                JMenuItem mit;
                ActionListener al = ae -> this.handleHeaderPopupSubMenu(ae.getActionCommand());
                this.headerPopup = new JPopupMenu();
                String[] vList = this.document.getModel().getVariableArray();
                if (vList == null) {
                    return;
                }
                UIManager.put("MenuItem.font", Statics.mathFont);
                for (String s : vList) {
                    if (s.equals("SEPARATOR")) continue;
                    mit = new JMenuItem(s);
                    mit.addActionListener(al);
                }
                if (this.aktiveSpalte >= 0) {
                    al = ae -> this.handlePopupMenu(ae.getActionCommand());
                    for (String s : vList) {
                        if (s.equals("SEPARATOR")) {
                            this.headerPopup.add(new JSeparator());
                            continue;
                        }
                        mit = new JMenuItem(s);
                        mit.addActionListener(al);
                        this.headerPopup.add(mit);
                    }
                    if (this.headerPopup.getComponent(0) instanceof JSeparator) {
                        this.headerPopup.remove(0);
                    }
                    UIManager.put("MenuItem.font", null);
                }
                UIManager.put("MenuItem.font", null);
                this.headerPopup.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            this.popup.getComponent(0).setEnabled(false);
            this.popup.getComponent(1).setEnabled(false);
            this.popup.getComponent(2).setEnabled(false);
            this.popup.getComponent(4).setEnabled(true);
            this.popup.getComponent(5).setEnabled(false);
            this.popup.getComponent(6).setEnabled(false);
            if (this.tab.getSelectedRowCount() > 0) {
                this.popup.getComponent(0).setEnabled(true);
                this.popup.getComponent(1).setEnabled(true);
                this.popup.getComponent(2).setEnabled(true);
                this.popup.getComponent(5).setEnabled(true);
                this.popup.getComponent(6).setEnabled(true);
            }
            if (Tabelle.scientificNotation) {
                ((JMenuItem)this.popup.getComponent(this.popup.getComponentIndex(this.nachkStellenMenu) - 1)).setText(this.rbundle.getString("Dezimale_Notation"));
            } else {
                ((JMenuItem)this.popup.getComponent(this.popup.getComponentIndex(this.nachkStellenMenu) - 1)).setText(this.rbundle.getString("Wissenschaftliche_Notation"));
            }
            JMenu umenu = (JMenu)this.popup.getComponent(this.popup.getComponentIndex(this.nachkStellenMenu));
            for (Component item : umenu.getMenuComponents()) {
                ((JMenuItem)item).setSelected(false);
            }
            ((JMenuItem)umenu.getMenuComponent(Tabelle.nachkStellen)).setSelected(true);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseClicked(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseClicked(e);
        this.tab.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.tab.repaint();
        this.document.getDiagramm().updateWertePlots();
    }

    @Override
    public boolean isInArray(int val, int[] arr) {
        for (int j = 0; j < arr.length; ++j) {
            if (val != arr[j]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    @Override
    public void toClipboard(boolean alles) {
        String text = "";
        if (alles) {
            Clipboard clip = this.getToolkit().getSystemClipboard();
            StringSelection cont = new StringSelection(this.tabelleToText());
            clip.setContents(cont, this);
        } else {
            int[] rows = this.tab.getSelectedRows();
            for (int ji = 0; ji < this.tab.getRowCount(); ++ji) {
                if (!this.isInArray(ji, rows)) continue;
                String zeile = "";
                for (int j = 0; j < this.tab.getColumnCount(); ++j) {
                    zeile = this.tab.getValueAt(ji, j) != null ? zeile.concat(Tabelle.df.format(this.tab.getValueAt(ji, j))).concat("\t") : zeile.concat("\t");
                }
                text = text.concat(zeile).concat("\n");
            }
            if (text.length() == 0) {
                return;
            }
            Clipboard clip = this.getToolkit().getSystemClipboard();
            StringSelection cont = new StringSelection(text);
            clip.setContents(cont, this);
        }
    }

    public void fromClipboard() {
        Clipboard clip = this.getToolkit().getSystemClipboard();
        String s = "";
        try {
            DataFlavor dflav = new DataFlavor(String.class, null);
            Transferable transf = clip.getContents(null);
            s = (String)transf.getTransferData(dflav);
        }
        catch (UnsupportedFlavorException | IOException e) {
            this.document.errorMsg("Clipboard Error!", e.getLocalizedMessage(), null, true);
        }
        s = s.replace('\r', '\n');
        String[] lines = s.split("\n");
        int selRow = this.tab.getSelectedRow();
        int selCol = this.tab.getSelectedColumn();
        if (selRow + lines.length > this.tab.getRowCount()) {
            Double[][] neuedaten = new Double[this.tab.getSelectedRow() + lines.length][this.tab.getModel().getColumnCount()];
            for (int i = 0; i < this.tab.getRowCount(); ++i) {
                for (int j = 0; j < this.tab.getColumnCount(); ++j) {
                    neuedaten[i][j] = (Double)this.tab.getValueAt(i, j);
                }
            }
            this.tabData = neuedaten;
            this.updateTab();
        }
        int ii = selRow;
        for (String line : lines) {
            String[] felder = line.split("[\t; ]");
            boolean ausnahme = true;
            for (int j = 0; j < felder.length; ++j) {
                try {
                    this.tabData[ii][j + selCol] = Double.parseDouble(felder[j].replace(',', '.'));
                    ausnahme = false;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ausnahme) continue;
            ++ii;
        }
        this.updateTab();
        this.tab.repaint();
        this.document.getDiagramm().updateDiagramPlus();
        this.document.setChanged(true);
    }

    public void cutCells() {
        this.toClipboard(false);
        int[] rows = this.tab.getSelectedRows();
        int cols = this.tab.getColumnCount();
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.tabData[rows[i]][j] = null;
            }
        }
        this.updateTab();
        this.document.setChanged(true);
    }

    public int getColumnCount() {
        return this.tab.getColumnCount();
    }

    public int getRowCount() {
        return this.tab.getRowCount();
    }

    public String[] getSpaltenNamen() {
        return this.spaltenNamen;
    }

    @Override
    public void requestFocus() {
        this.tab.requestFocus();
    }

    public void createNewTabData(int rows, int cols) {
        Double[][] neuedaten = new Double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                try {
                    neuedaten[i][j] = (Double)this.tab.getValueAt(i, j);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.tabData = neuedaten;
    }

    public void importTable() {
        RandomAccessFile file;
        String fname;
        Object dir;
        if (!new AutoDialog(this.document.getViewer().getWindow()).display(this.rbundle.getString("Sie_m\u00f6chten_die_Tabelle_der_Vergleichswerte_neu_laden."), this.rbundle.getString("Die_Werte_sind_unwiederbringlich_verloren!"), Statics.rBundle.getString("Fortfahren"), Statics.rBundle.getString("Abbrechen"))) {
            return;
        }
        Object text = this.rbundle.getString("Text-Datei_mit_Datentabelle_aussuchen");
        if (!Statics.os.contains("Mac")) {
            FileDialog fileOpenDialog = new FileDialog((Frame)new JFrame(), (String)text, 0);
            fileOpenDialog.setVisible(true);
            if (fileOpenDialog.getFile() == null) {
                return;
            }
            dir = fileOpenDialog.getDirectory();
            fname = fileOpenDialog.getFile();
        } else {
            JFileChooser fileDialog = new JFileChooser("");
            fileDialog.setDialogTitle((String)text);
            if (fileDialog.showOpenDialog(this) == 1) {
                return;
            }
            dir = fileDialog.getCurrentDirectory().getPath() + "/";
            fname = fileDialog.getSelectedFile().getName();
        }
        if (fname.endsWith(".cmbl") || fname.endsWith(".gambl")) {
            try {
                int r;
                String zeile;
                file = new RandomAccessFile((String)dir + fname, "r");
                int cols = 0;
                int rows = 0;
                while ((zeile = file.readLine()) != null) {
                    if (zeile.contains("<DataColumn>")) {
                        ++cols;
                    }
                    if (!zeile.contains("<ColumnCells>")) continue;
                    r = 0;
                    do {
                        zeile = file.readLine();
                        ++r;
                    } while (!zeile.contains("</ColumnCells>"));
                    if (--r <= rows) continue;
                    rows = r;
                }
                file.seek(0L);
                Double[][] neueDaten = new Double[rows][cols];
                String[] spalten = new String[cols];
                int col = -1;
                while ((zeile = file.readLine()) != null) {
                    if (zeile.contains("<DataColumn>")) {
                        ++col;
                    }
                    if (zeile.contains("<DataObjectName>")) {
                        spalten[col] = zeile.substring(zeile.indexOf("<DataObjectName>") + 16, zeile.indexOf("</DataObjectName>"));
                    }
                    if (!zeile.contains("<ColumnCells>")) continue;
                    r = 0;
                    do {
                        if ((zeile = file.readLine()).contains("</ColumnCells>")) continue;
                        neueDaten[r][col] = Double.valueOf(zeile.trim());
                        ++r;
                    } while (!zeile.contains("</ColumnCells>"));
                }
                file.close();
                this.update(neueDaten, spalten);
            }
            catch (Exception e) {
                new AutoDialog(this.document.getViewer().getWindow()).display(this.rbundle.getString("Fehler_beim_Laden_der_Tabellendatei!"), e.toString(), Statics.rBundle.getString("OK"));
                e.printStackTrace();
                return;
            }
        }
        if (fname.endsWith(".mmd")) {
            try {
                int col;
                file = new RandomAccessFile((String)dir + fname, "r");
                String inputString = file.readLine().replace('[', '\u00a7').replace(']', '#');
                String[] parts = inputString.split("#,\u00a7");
                String s = parts[0].substring(parts[0].indexOf("\u00a7\u00a7") + 2);
                String[] ss = s.split(",");
                Double[][] neueDaten = new Double[parts.length][ss.length];
                for (col = 0; col < ss.length; ++col) {
                    neueDaten[0][col] = Double.parseDouble(ss[col]);
                }
                for (int row = 1; row < parts.length - 1; ++row) {
                    ss = parts[row].split(",");
                    for (int col2 = 0; col2 < ss.length; ++col2) {
                        neueDaten[row][col2] = Double.parseDouble(ss[col2]);
                    }
                }
                s = parts[parts.length - 1];
                ss = s.substring(0, s.indexOf("##")).split(",");
                for (col = 0; col < ss.length; ++col) {
                    neueDaten[parts.length - 1][col] = Double.parseDouble(ss[col]);
                    ss[col] = "#" + col;
                }
                file.close();
                this.update(neueDaten, ss);
            }
            catch (Exception e) {
                new AutoDialog(this.document.getViewer().getWindow()).display(this.rbundle.getString("Fehler_beim_Laden_der_Tabellendatei!"), e.toString(), Statics.rBundle.getString("OK"));
                return;
            }
        }
        if (fname.endsWith(".labx") || fname.endsWith(".labm")) {
            try {
                int i_temp;
                String s;
                String zeile;
                file = new RandomAccessFile((String)dir + fname, "r");
                text = "";
                do {
                    if ((zeile = file.readLine()) == null) continue;
                    text = (String)text + zeile;
                } while (zeile != null);
                file.close();
                int rows = 0;
                int cols = 0;
                int pos = 0;
                while ((pos = ((String)text).indexOf("<symbol>", pos)) >= 0) {
                    s = ((String)text).substring(pos = ((String)text).indexOf("<values count=", pos) + 15, ((String)text).indexOf("\"", pos));
                    i_temp = Integer.valueOf(s);
                    if (i_temp > 0) {
                        ++cols;
                    }
                    if (i_temp <= rows) continue;
                    rows = i_temp;
                }
                Double[][] neueDaten = new Double[rows][cols];
                String[] spalten = new String[cols];
                int col = 0;
                pos = 0;
                while ((pos = ((String)text).indexOf("<symbol>", pos)) >= 0) {
                    spalten[col] = ((String)text).substring(pos + 8, ((String)text).indexOf("</symbol>", pos + 8));
                    s = ((String)text).substring(pos = ((String)text).indexOf("<values count=", pos) + 15, ((String)text).indexOf("\"", pos));
                    i_temp = Integer.valueOf(s);
                    if (i_temp > 0) {
                        for (int row = 0; row < rows; ++row) {
                            pos = ((String)text).indexOf("<value>", pos) + 7;
                            s = ((String)text).substring(pos, ((String)text).indexOf("</value>", pos));
                            neueDaten[row][col] = Double.valueOf(s);
                        }
                        ++col;
                    }
                    if (col < cols) continue;
                }
                this.update(neueDaten, spalten);
            }
            catch (Exception e) {
                new AutoDialog(this.document.getViewer().getWindow()).display(this.rbundle.getString("Fehler_beim_Laden_der_Tabellendatei!"), e.toString(), Statics.rBundle.getString("OK"));
                return;
            }
        }
        try {
            String s;
            file = new RandomAccessFile((String)dir + fname, "r");
            ArrayList<String> zeilen = new ArrayList<String>();
            while ((s = file.readLine()) != null) {
                s = s.replaceAll("(?<=[0-9]),(?=[0-9])", ".");
                zeilen.add(s);
            }
            TableImportDialog tableImportDialog = new TableImportDialog((Frame)this.document.getViewer().getWindow(), true, this.document);
            if (tableImportDialog.showDialog(zeilen)) {
                this.update(tableImportDialog.neueDaten, tableImportDialog.spaltenTitel);
            }
        }
        catch (Exception e) {
            new AutoDialog(this.document.getViewer().getWindow()).display(this.rbundle.getString("Fehler_beim_Laden_der_Tabellendatei!"), e.toString(), Statics.rBundle.getString("OK"));
            e.printStackTrace();
            return;
        }
        this.document.getDiagramm().updateDiagramPlus();
        this.document.setChanged(true);
    }

    public void setData(Double[][] data) {
        this.tabData = data;
    }

    @Override
    public void toScientificNotation() {
        scientificNotation = true;
        Tabelle.df.applyPattern("#.#E0");
        Tabelle.df.setMinimumFractionDigits(Tabelle.nachkStellen);
    }

    @Override
    public void toDecimalNotation() {
        scientificNotation = false;
        Tabelle.df.applyPattern("#.##");
        Tabelle.df.setMinimumFractionDigits(Tabelle.nachkStellen);
    }

    @Override
    public void setzeStellenAnz(int anz) {
        JCheckBoxMenuItem item;
        for (int i = 0; i < this.nachkStellenMenu.getItemCount(); ++i) {
            item = (JCheckBoxMenuItem)this.nachkStellenMenu.getItem(i);
            item.setSelected(false);
        }
        item = (JCheckBoxMenuItem)this.nachkStellenMenu.getItem(anz);
        item.setSelected(true);
        Tabelle.nachkStellen = anz;
        Tabelle.df.setMinimumFractionDigits(Tabelle.nachkStellen);
        Tabelle.df.setMaximumFractionDigits(Tabelle.nachkStellen);
    }

    public void clearAll() {
        if (!new AutoDialog(this.document.getViewer().getWindow()).display(this.rbundle.getString("Sie_m\u00f6chten_die_Tabelle_der_Vergleichswerte_l\u00f6schen."), this.rbundle.getString("Die_Werte_sind_unwiederbringlich_verloren!"), Statics.rBundle.getString("Fortfahren"), Statics.rBundle.getString("Abbrechen"))) {
            return;
        }
        for (int i = 0; i < this.tab.getRowCount(); ++i) {
            for (int j = 0; j < this.tab.getColumnCount(); ++j) {
                this.tabData[i][j] = null;
            }
        }
        this.spaltenNamen = this.document.getModel().getSpaltenNamen();
        this.createNewTabData(50, this.spaltenNamen.length);
        this.tab.setModel(new myTableModel(this.spaltenNamen, this.tabData));
        this.document.getDiagramm().updateDiagramPlus();
        this.document.setChanged(true);
    }

    public void setEditible(boolean tf) {
        this.isEditible = tf;
    }

    private String tabelleToText() {
        Object zeile = "";
        for (int j = 0; j < this.tab.getColumnCount(); ++j) {
            zeile = (String)zeile + this.tab.getColumnName(j) + "\t";
        }
        String text = (String)zeile + "\n";
        for (int i = 0; i < this.tab.getRowCount(); ++i) {
            zeile = "";
            for (int j = 0; j < this.tab.getColumnCount(); ++j) {
                zeile = this.tab.getValueAt(i, j) != null ? (String)zeile + this.tab.getValueAt(i, j) + "\t" : (String)zeile + "\t";
            }
            text = text + (String)zeile + "\n";
        }
        return text;
    }

    public void writeTextData(RandomAccessFile f) throws Exception {
        f.writeBytes(this.tabelleToText());
    }

    class MyKeyListener
    extends KeyAdapter {
        MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            int maske = 256;
            if (!Statics.os.contains("Mac")) {
                maske = 128;
            }
            if ((code & 0x56) == 86 && (e.getModifiersEx() & maske) == maske) {
                VergleichsTabelle.this.fromClipboard();
                try {
                    VergleichsTabelle.this.tab.getCellEditor().cancelCellEditing();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                e.consume();
            }
            if ((code & 0x58) == 88 && (e.getModifiersEx() & maske) == maske) {
                try {
                    VergleichsTabelle.this.cutCells();
                    VergleichsTabelle.this.tab.getCellEditor().cancelCellEditing();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                e.consume();
            }
        }
    }

    class MyCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        Class[] argTypes;
        Constructor constructor;
        Object value;

        public MyCellEditor() {
            super(new JTextField());
            this.argTypes = new Class[]{String.class};
            this.getComponent().addKeyListener(new MyKeyListener());
            this.getComponent().setName("Table.editor");
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            if ("".equals(s.trim())) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = s;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(s.replace(',', '.'));
                if (VergleichsTabelle.this.tab.getEditingRow() == VergleichsTabelle.this.tab.getRowCount() - 1) {
                    Double[][] neuedaten = new Double[VergleichsTabelle.this.tab.getRowCount() + 1][VergleichsTabelle.this.tab.getModel().getColumnCount()];
                    for (int i = 0; i < VergleichsTabelle.this.tab.getRowCount(); ++i) {
                        for (int j = 0; j < VergleichsTabelle.this.tab.getColumnCount(); ++j) {
                            neuedaten[i][j] = (Double)VergleichsTabelle.this.tab.getValueAt(i, j);
                        }
                    }
                    neuedaten[VergleichsTabelle.this.tab.getSelectedRow()][VergleichsTabelle.this.tab.getSelectedColumn()] = (Double)this.value;
                    VergleichsTabelle.this.tabData = neuedaten;
                    VergleichsTabelle.this.updateTab();
                }
            }
            catch (Exception e) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> type = table.getColumnClass(column);
                if (type == Object.class) {
                    type = String.class;
                }
                this.constructor = type.getConstructor(this.argTypes);
            }
            catch (Exception e) {
                return null;
            }
            if (value != null) {
                return super.getTableCellEditorComponent(table, Tabelle.df.format((Double)value), isSelected, row, column);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    class MyCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        MyCellRenderer() {
        }

        @Override
        public void setValue(Object value) {
            this.setHorizontalAlignment(4);
            if (!VergleichsTabelle.this.isEditible) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(Color.BLACK);
            }
            if (value != null) {
                super.setValue(Tabelle.df.format((Double)value));
            } else {
                super.setValue(null);
            }
        }
    }

    class myTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames;
        private final Object[][] data;

        public myTableModel(String[] colNam, Object[][] dat) {
            this.columnNames = colNam;
            this.data = dat;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            return Double.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return VergleichsTabelle.this.isEditible;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            try {
                this.data[row][col] = value;
            }
            catch (Exception e) {
                return;
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

