/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import com.singularsys.jep.parser.Node;
import de.didappslib.base.Model;
import de.didappslib.base.Statics;
import de.didappslib.base.ZusatzDef;
import de.didappslib.guitools.GreekLetterConstPanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class ZusatzDefsAnzeige
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/base/resources/ZusatzDefs", Statics.locale);
    private Model model;
    public List<ZusatzDef> defListe = new ArrayList<ZusatzDef>();
    public ZusatzDef aktDef;
    private JButton addDefButton;
    private JLabel bedLabel1;
    private JLabel bedLabel2;
    private JPanel bedPanel;
    private JTextArea bedingungField;
    private JScrollPane bedingungScrollPane;
    private JLabel contentHeaderLabel;
    private JPanel contentPanel;
    private JScrollPane defsScrollPane;
    private JTable defsTable;
    private JTextArea fktField;
    private JLabel fktLabel;
    private JPanel fktPanel;
    private JPanel fktPreviewPanel;
    private JScrollPane fktScrollPane;
    private JButton insertVarButt;
    private JComboBox<String> interpolCBox;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator2;
    private JTextArea konstField;
    private JLabel konstLabel;
    private JPanel konstPanel;
    private JScrollPane konstScrollPane;
    private JTextArea negativField;
    private JScrollPane negativScrollPane;
    private JTextArea positivField;
    private JScrollPane positivScrollPane;
    private JScrollPane previewScrollPane;
    private JScrollPane previewScrollPane1;
    private JButton subDefButton;
    private JPanel tabFktPanel;
    private JPanel tabFktPreviewPanel;
    private JLabel tabLabel;
    private JPanel tabPanel;
    private JTable tabTable;
    private JScrollPane tableScrollPane;
    private JTextField xmaxField;
    private JTextField xminField;
    private JTextField ymaxField;
    private JTextField yminField;

    public ZusatzDefsAnzeige(Model mod) {
        this.model = mod;
        this.initComponents();
        this.addDefButton.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/plus", 1.0f));
        this.subDefButton.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/minus", 1.0f));
        this.insertVarButt.setText(rbundle.getString("insertVarButt_TIP").replace("#", "\u01b6"));
        this.fktField.setToolTipText(rbundle.getString("Funktionsterm").replace("#", "\u01b6"));
        this.fktPreviewPanel.add(new MiniKS());
        this.tabFktPreviewPanel.add(new MiniKS());
        VarNameCellEditor cellEditor = new VarNameCellEditor();
        cellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                int welche = ZusatzDefsAnzeige.this.defsTable.getSelectedRow();
                ZusatzDef zd = ZusatzDefsAnzeige.this.defListe.get(welche);
                zd.name = (String)ZusatzDefsAnzeige.this.defsTable.getValueAt(welche, 0);
                ZusatzDefsAnzeige.this.updateView();
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                int welche = ZusatzDefsAnzeige.this.defsTable.getSelectedRow();
                ZusatzDef zd = ZusatzDefsAnzeige.this.defListe.get(welche);
                zd.name = (String)ZusatzDefsAnzeige.this.defsTable.getValueAt(welche, 0);
                ZusatzDefsAnzeige.this.updateView();
            }
        });
        this.defsTable.setDefaultEditor(String.class, cellEditor);
        this.defsTable.getSelectionModel().addListSelectionListener(e -> {
            int welche = this.defsTable.getSelectedRow();
            if (welche < 0) {
                return;
            }
            this.aktDef = this.defListe.get(welche);
            this.updateView();
        });
        this.setListView();
        this.tabTable.setDefaultEditor(Double.class, new DoubleCellEditor());
    }

    public void zeige() {
        if (this.aktDef == null && this.defListe.size() > 0) {
            this.aktDef = this.defListe.get(0);
        }
        this.setListView();
        this.updateView();
        if (this.model.getProjekt().getViewer().getWindow() != null) {
            this.setLocation(this.model.getProjekt().getViewer().getWindow().getX() + this.model.getProjekt().getViewer().anzeigePane.getWidth() / 2 - this.getWidth() / 2, this.model.getProjekt().getViewer().getWindow().getY() + (int)((double)this.model.getProjekt().getViewer().getWindow().getHeight() * 0.3) - this.getHeight() / 2);
        }
        this.addDefButton.setEnabled(this.model.editierbar);
        this.subDefButton.setEnabled(this.model.editierbar);
        this.setVisible(true);
    }

    public void loeschen() {
        this.defListe.clear();
        this.aktDef = null;
        this.setListView();
    }

    public void writeDefListe(ObjectOutputStream objstr) throws Exception {
        objstr.writeInt(this.defListe.size());
        Iterator<ZusatzDef> iterator = this.defListe.iterator();
        while (iterator.hasNext()) {
            ZusatzDef defListe1;
            ZusatzDef def = defListe1 = iterator.next();
            def.writeDef(objstr);
        }
    }

    public void readDefListe(ObjectInputStream objstr) throws Exception {
        this.defListe.clear();
        int size = objstr.readInt();
        for (int i = 0; i < size; ++i) {
            ZusatzDef def = ZusatzDef.readDef(objstr);
            this.defListe.add(def);
        }
        this.aktDef = null;
        this.setListView();
    }

    private void initComponents() {
        this.fktPanel = new JPanel();
        this.fktScrollPane = new JScrollPane();
        this.fktField = new JTextArea();
        this.jLabel6 = new JLabel();
        this.insertVarButt = new JButton();
        this.fktLabel = new JLabel();
        this.jLabel8 = new JLabel();
        this.xminField = new JTextField();
        this.jLabel9 = new JLabel();
        this.xmaxField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel14 = new JLabel();
        this.yminField = new JTextField();
        this.ymaxField = new JTextField();
        this.previewScrollPane1 = new JScrollPane();
        this.fktPreviewPanel = new JPanel();
        this.tabFktPanel = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.tabTable = new JTable();
        this.jLabel4 = new JLabel();
        this.previewScrollPane = new JScrollPane();
        this.tabFktPreviewPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.interpolCBox = new JComboBox();
        this.bedPanel = new JPanel();
        this.bedLabel1 = new JLabel();
        this.bedingungScrollPane = new JScrollPane();
        this.bedingungField = new JTextArea();
        this.positivScrollPane = new JScrollPane();
        this.positivField = new JTextArea();
        this.negativScrollPane = new JScrollPane();
        this.negativField = new JTextArea();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.bedLabel2 = new JLabel();
        this.tabLabel = new JLabel();
        this.tabPanel = new JPanel();
        this.defsScrollPane = new JScrollPane();
        this.defsTable = new JTable();
        this.addDefButton = new JButton();
        this.subDefButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.contentHeaderLabel = new JLabel();
        this.contentPanel = new JPanel();
        this.konstPanel = new JPanel();
        this.konstLabel = new JLabel();
        this.konstScrollPane = new JScrollPane();
        this.konstField = new JTextArea();
        this.fktPanel.setLayout(new GridBagLayout());
        this.fktScrollPane.setHorizontalScrollBarPolicy(31);
        this.fktScrollPane.setMinimumSize(new Dimension(200, 104));
        this.fktScrollPane.setPreferredSize(new Dimension(200, 104));
        this.fktField.setColumns(11);
        this.fktField.setFont(new Font("Serif", 2, 16));
        this.fktField.setRows(5);
        this.fktField.setText("\u1e6f^2+\u1e6f+3");
        this.fktField.setToolTipText(rbundle.getString("Funktionsterm"));
        this.fktField.setComponentPopupMenu(GreekLetterConstPanel.greekLettersPM);
        this.fktField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ZusatzDefsAnzeige.this.fktFieldKeyEvt(evt);
            }
        });
        this.fktScrollPane.setViewportView(this.fktField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.fktPanel.add((Component)this.fktScrollPane, gridBagConstraints);
        this.jLabel6.setText(rbundle.getString("Vorschau"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.fktPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.insertVarButt.setText("\u01b6");
        ResourceBundle bundle = ResourceBundle.getBundle("de/didappslib/base/resources/ZusatzDefs");
        this.insertVarButt.setToolTipText(bundle.getString("InsertVariable_TIP"));
        this.insertVarButt.setContentAreaFilled(false);
        this.insertVarButt.setPreferredSize(new Dimension(19, 19));
        this.insertVarButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZusatzDefsAnzeige.this.insertVarButtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.fktPanel.add((Component)this.insertVarButt, gridBagConstraints);
        this.fktLabel.setFont(new Font("Serif", 2, 15));
        this.fktLabel.setText("demo(\u1e6f) =");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.fktPanel.add((Component)this.fktLabel, gridBagConstraints);
        this.jLabel8.setText("var min:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        this.fktPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.xminField.setMinimumSize(new Dimension(45, 22));
        this.xminField.setOpaque(true);
        this.xminField.setPreferredSize(new Dimension(90, 22));
        this.xminField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ZusatzDefsAnzeige.this.xFieldKeyEvt(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                ZusatzDefsAnzeige.this.xFieldKeyEvt(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                ZusatzDefsAnzeige.this.xFieldKeyEvt(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 2, 0, 0);
        this.fktPanel.add((Component)this.xminField, gridBagConstraints);
        this.jLabel9.setText("var max:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.fktPanel.add((Component)this.jLabel9, gridBagConstraints);
        this.xmaxField.setMinimumSize(new Dimension(45, 22));
        this.xmaxField.setOpaque(true);
        this.xmaxField.setPreferredSize(new Dimension(90, 22));
        this.xmaxField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ZusatzDefsAnzeige.this.xFieldKeyEvt(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                ZusatzDefsAnzeige.this.xFieldKeyEvt(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                ZusatzDefsAnzeige.this.xFieldKeyEvt(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 2, 0, 0);
        this.fktPanel.add((Component)this.xmaxField, gridBagConstraints);
        this.jLabel3.setText(rbundle.getString("Darstellungsbereich"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 2, 0, 0);
        this.fktPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel10.setText("y max:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 2, 6, 0);
        this.fktPanel.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel14.setText("y min:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 2, 0, 0);
        this.fktPanel.add((Component)this.jLabel14, gridBagConstraints);
        this.yminField.setEditable(false);
        this.yminField.setBackground(new Color(224, 224, 224));
        this.yminField.setForeground(new Color(102, 102, 102));
        this.yminField.setText("asdad");
        this.yminField.setToolTipText("");
        this.yminField.setBorder(null);
        this.yminField.setMinimumSize(new Dimension(45, 22));
        this.yminField.setOpaque(true);
        this.yminField.setPreferredSize(new Dimension(90, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 2, 0, 0);
        this.fktPanel.add((Component)this.yminField, gridBagConstraints);
        this.ymaxField.setEditable(false);
        this.ymaxField.setBackground(new Color(224, 224, 224));
        this.ymaxField.setForeground(new Color(102, 102, 102));
        this.ymaxField.setText("asdad");
        this.ymaxField.setToolTipText("");
        this.ymaxField.setBorder(null);
        this.ymaxField.setMinimumSize(new Dimension(45, 22));
        this.ymaxField.setOpaque(true);
        this.ymaxField.setPreferredSize(new Dimension(90, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 2, 6, 0);
        this.fktPanel.add((Component)this.ymaxField, gridBagConstraints);
        this.previewScrollPane1.setHorizontalScrollBarPolicy(31);
        this.previewScrollPane1.setVerticalScrollBarPolicy(21);
        this.fktPreviewPanel.setBackground(new Color(255, 255, 255));
        this.fktPreviewPanel.setLayout(new BorderLayout());
        this.previewScrollPane1.setViewportView(this.fktPreviewPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 7, 5, 0);
        this.fktPanel.add((Component)this.previewScrollPane1, gridBagConstraints);
        this.tabFktPanel.setMinimumSize(new Dimension(415, 310));
        this.tabFktPanel.setPreferredSize(new Dimension(415, 310));
        this.tabFktPanel.setLayout(new GridBagLayout());
        this.tableScrollPane.setAutoscrolls(true);
        this.tableScrollPane.setMinimumSize(new Dimension(150, 200));
        this.tableScrollPane.setPreferredSize(new Dimension(150, 200));
        this.tabTable.setToolTipText(rbundle.getString("Wertetabelle_fuer_die_zu_definierende_Tabellenfunktion"));
        this.tabTable.setGridColor(new Color(204, 204, 204));
        this.tableScrollPane.setViewportView(this.tabTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.tabFktPanel.add((Component)this.tableScrollPane, gridBagConstraints);
        this.jLabel4.setText(rbundle.getString("Vorschau"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.tabFktPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.previewScrollPane.setHorizontalScrollBarPolicy(31);
        this.previewScrollPane.setVerticalScrollBarPolicy(21);
        this.tabFktPreviewPanel.setBackground(new Color(255, 255, 255));
        this.tabFktPreviewPanel.setLayout(new BorderLayout());
        this.previewScrollPane.setViewportView(this.tabFktPreviewPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 7, 0, 0);
        this.tabFktPanel.add((Component)this.previewScrollPane, gridBagConstraints);
        this.jLabel1.setText(rbundle.getString("Interpolation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 9, 0, 0);
        this.tabFktPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.interpolCBox.setModel(new DefaultComboBoxModel<String>(new String[]{rbundle.getString("linear"), rbundle.getString("Polynom"), rbundle.getString("kubische_Splines")}));
        this.interpolCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZusatzDefsAnzeige.this.interpolCBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 3, 0, 0);
        this.tabFktPanel.add(this.interpolCBox, gridBagConstraints);
        this.bedPanel.setLayout(new GridBagLayout());
        this.bedLabel1.setText("demo =");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 191;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(21, 3, 0, 0);
        this.bedPanel.add((Component)this.bedLabel1, gridBagConstraints);
        this.bedingungScrollPane.setPreferredSize(new Dimension(244, 36));
        this.bedingungField.setBackground(new Color(255, 255, 230));
        this.bedingungField.setColumns(20);
        this.bedingungField.setRows(2);
        this.bedingungField.setToolTipText(rbundle.getString("Eingabe_der_Bedingung_(z.B._t>10)."));
        this.bedingungField.setComponentPopupMenu(GreekLetterConstPanel.greekLettersPM);
        this.bedingungField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ZusatzDefsAnzeige.this.bedFieldKeyEvt(evt);
            }
        });
        this.bedingungScrollPane.setViewportView(this.bedingungField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 0, 0);
        this.bedPanel.add((Component)this.bedingungScrollPane, gridBagConstraints);
        this.positivField.setBackground(new Color(236, 255, 236));
        this.positivField.setColumns(20);
        this.positivField.setRows(2);
        this.positivField.setToolTipText(rbundle.getString("Bedingung_erfuellt"));
        this.positivField.setComponentPopupMenu(GreekLetterConstPanel.greekLettersPM);
        this.positivField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ZusatzDefsAnzeige.this.bedFieldKeyEvt(evt);
            }
        });
        this.positivScrollPane.setViewportView(this.positivField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.bedPanel.add((Component)this.positivScrollPane, gridBagConstraints);
        this.negativField.setBackground(new Color(255, 230, 230));
        this.negativField.setColumns(20);
        this.negativField.setRows(2);
        this.negativField.setToolTipText(rbundle.getString("Bedingung_nicht_erfuellt"));
        this.negativField.setComponentPopupMenu(GreekLetterConstPanel.greekLettersPM);
        this.negativField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ZusatzDefsAnzeige.this.bedFieldKeyEvt(evt);
            }
        });
        this.negativScrollPane.setViewportView(this.negativField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.bedPanel.add((Component)this.negativScrollPane, gridBagConstraints);
        this.jLabel11.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel11.setText(rbundle.getString("sonst"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 3, 0, 0);
        this.bedPanel.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel12.setText(rbundle.getString("wenn"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.bedPanel.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel13.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel13.setText(rbundle.getString("dann"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.bedPanel.add((Component)this.jLabel13, gridBagConstraints);
        this.bedLabel2.setText("demo =");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 191;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(22, 3, 0, 0);
        this.bedPanel.add((Component)this.bedLabel2, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.setTitle(rbundle.getString("Zusatzdefinitionen_festlegen"));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(550, 400));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ZusatzDefsAnzeige.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.tabLabel.setText(rbundle.getString("Definitionsliste"));
        this.tabLabel.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.getContentPane().add((Component)this.tabLabel, gridBagConstraints);
        this.tabPanel.setMinimumSize(new Dimension(200, 100));
        this.tabPanel.setPreferredSize(new Dimension(200, 100));
        this.tabPanel.setLayout(new GridBagLayout());
        this.defsScrollPane.setToolTipText(rbundle.getString("Name_und_Art_der_Zusatzdefinitionen."));
        this.defsScrollPane.setAutoscrolls(true);
        this.defsScrollPane.setMinimumSize(new Dimension(200, 200));
        this.defsScrollPane.setPreferredSize(new Dimension(200, 300));
        this.defsTable.setModel(new DefaultTableModel(new Object[][]{{"demo", "TF"}}, new String[]{"Name", "Art"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.defsTable.setGridColor(new Color(204, 204, 204));
        this.defsTable.setIntercellSpacing(new Dimension(3, 1));
        this.defsScrollPane.setViewportView(this.defsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        this.tabPanel.add((Component)this.defsScrollPane, gridBagConstraints);
        this.addDefButton.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/plus.png")));
        this.addDefButton.setToolTipText(rbundle.getString("Neue_Definition_hinzu"));
        this.addDefButton.setBorderPainted(false);
        this.addDefButton.setContentAreaFilled(false);
        this.addDefButton.setMargin(new Insets(0, 0, 0, 0));
        this.addDefButton.setPreferredSize(new Dimension(16, 16));
        this.addDefButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZusatzDefsAnzeige.this.addDefButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.tabPanel.add((Component)this.addDefButton, gridBagConstraints);
        this.subDefButton.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/minus.png")));
        this.subDefButton.setToolTipText(rbundle.getString("Definition_loeschen"));
        this.subDefButton.setBorderPainted(false);
        this.subDefButton.setContentAreaFilled(false);
        this.subDefButton.setMargin(new Insets(0, 0, 0, 0));
        this.subDefButton.setPreferredSize(new Dimension(16, 16));
        this.subDefButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZusatzDefsAnzeige.this.subDefButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.tabPanel.add((Component)this.subDefButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 5, 0);
        this.getContentPane().add((Component)this.tabPanel, gridBagConstraints);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMinimumSize(new Dimension(12, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 3, 10, 0);
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.contentHeaderLabel.setText("demo ist festgelegt durch:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 3, 0, 0);
        this.getContentPane().add((Component)this.contentHeaderLabel, gridBagConstraints);
        this.contentPanel.setMinimumSize(new Dimension(100, 100));
        this.contentPanel.setLayout(new BorderLayout());
        this.konstPanel.setLayout(new GridBagLayout());
        this.konstLabel.setText("demo =");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.konstPanel.add((Component)this.konstLabel, gridBagConstraints);
        this.konstScrollPane.setMinimumSize(new Dimension(200, 80));
        this.konstScrollPane.setPreferredSize(new Dimension(284, 90));
        this.konstField.setColumns(20);
        this.konstField.setRows(5);
        this.konstField.setToolTipText(rbundle.getString("Konstantenterm"));
        this.konstField.setComponentPopupMenu(GreekLetterConstPanel.greekLettersPM);
        this.konstField.setMinimumSize(new Dimension(80, 80));
        this.konstField.setPreferredSize(new Dimension(80, 80));
        this.konstField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ZusatzDefsAnzeige.this.konstFieldKeyEvt(evt);
            }
        });
        this.konstScrollPane.setViewportView(this.konstField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.konstPanel.add((Component)this.konstScrollPane, gridBagConstraints);
        this.contentPanel.add((Component)this.konstPanel, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.getContentPane().add((Component)this.contentPanel, gridBagConstraints);
        this.pack();
    }

    private void interpolCBoxActionPerformed(ActionEvent evt) {
        if (this.aktDef != null) {
            this.aktDef.interpolation = this.interpolCBox.getSelectedIndex();
            this.updateView();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.model.werteAuslesen(false);
        this.model.getProjekt().getDiagramm().repaint();
    }

    private void bedFieldKeyEvt(KeyEvent evt) {
        JTextComponent tf = (JTextComponent)evt.getSource();
        GreekLetterConstPanel.tfInputHook(tf);
        this.aktDef.bedingung = this.bedingungField.getText();
        this.aktDef.positiv = this.positivField.getText();
        this.aktDef.negativ = this.negativField.getText();
        this.model.werteAuslesen(false);
    }

    private void xFieldKeyEvt(KeyEvent evt) {
        try {
            this.aktDef.xmin = Statics.textFieldToDouble(this.xminField, false);
            this.aktDef.xmax = Statics.textFieldToDouble(this.xmaxField, false);
            if (this.aktDef.xmax == this.aktDef.xmin) {
                this.aktDef.xmax = this.aktDef.xmin * 1.1;
            }
            this.fktPreviewPanel.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fktFieldKeyEvt(KeyEvent evt) {
        JTextComponent tf = (JTextComponent)evt.getSource();
        GreekLetterConstPanel.tfInputHook(tf);
        this.aktDef.definition = tf.getText();
        this.model.werteAuslesen(false);
        this.fktPreviewPanel.repaint();
    }

    private void konstFieldKeyEvt(KeyEvent evt) {
        JTextComponent tf = (JTextComponent)evt.getSource();
        GreekLetterConstPanel.tfInputHook(tf);
        this.aktDef.definition = this.konstField.getText();
        this.model.werteAuslesen(false);
    }

    private void subDefButtonActionPerformed(ActionEvent evt) {
        this.entferneZusatzDef();
    }

    private void addDefButtonActionPerformed(ActionEvent evt) {
        this.neueZusatzDef();
    }

    private void insertVarButtActionPerformed(ActionEvent evt) {
        int pos = this.fktField.getCaretPosition();
        this.fktField.insert("\u01b6", pos);
        this.fktField.setCaretPosition(pos + 1);
        this.aktDef.definition = this.fktField.getText();
        this.model.werteAuslesen(false);
        this.fktPreviewPanel.repaint();
        this.fktField.requestFocus();
    }

    private void setListView() {
        int size = this.defListe.size();
        int merke = -1;
        Object[][] eintraege = new Object[size][2];
        for (int i = 0; i < size; ++i) {
            eintraege[i][0] = this.defListe.get((int)i).name;
            eintraege[i][1] = this.defListe.get((int)i).art;
            if (this.aktDef != this.defListe.get(i)) continue;
            merke = i;
        }
        this.defsTable.setModel(new DefaultTableModel(eintraege, new String[]{rbundle.getString("Name"), rbundle.getString("Art")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }
        });
        JComboBox<String> cbox = new JComboBox<String>();
        cbox.addItem(rbundle.getString("Konstante"));
        cbox.setEnabled(this.model.editierbar);
        cbox.addItem(rbundle.getString("Variable"));
        cbox.addItem(rbundle.getString("Funktion"));
        cbox.addItem(rbundle.getString("Tabellenfkt"));
        cbox.addItem(rbundle.getString("Bedingte_Var"));
        MenuCellEditor celled = new MenuCellEditor(cbox);
        celled.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                int welche = ZusatzDefsAnzeige.this.defsTable.getSelectedRow();
                ZusatzDefsAnzeige.this.aktDef = ZusatzDefsAnzeige.this.defListe.get(welche);
                ZusatzDefsAnzeige.this.aktDef.art = (String)ZusatzDefsAnzeige.this.defsTable.getValueAt(welche, 1);
                ZusatzDefsAnzeige.this.updateView();
            }
        });
        this.defsTable.getColumnModel().getColumn(1).setCellEditor(celled);
        if (merke != -1) {
            this.defsTable.getSelectionModel().setSelectionInterval(merke, merke);
        }
    }

    private void neueZusatzDef() {
        ZusatzDef zd = new ZusatzDef();
        this.defListe.add(zd);
        this.setListView();
        this.aktDef = zd;
        int i = this.defListe.indexOf(zd);
        this.defsTable.getSelectionModel().setSelectionInterval(i, i);
        this.defsTable.scrollRectToVisible(new Rectangle(10, (i + 1) * this.defsTable.getRowHeight(), 1, 1));
        this.model.setZusatzDefsButton();
    }

    public void neueVariable(String name, String term) {
        ZusatzDef zd = new ZusatzDef();
        zd.name = name;
        zd.definition = term;
        this.defListe.add(zd);
    }

    private void entferneZusatzDef() {
        int welche = this.defsTable.getSelectedRow();
        if (welche < 0) {
            return;
        }
        this.defListe.remove(welche);
        this.aktDef = null;
        this.setListView();
        this.model.setZusatzDefsButton();
    }

    private void updateView() {
        String s = " " + rbundle.getString("ist_festgelegt_durch");
        this.addDefButton.setEnabled(this.model.editierbar);
        this.subDefButton.setEnabled(this.defListe.size() > 0 & this.model.editierbar);
        this.contentPanel.remove(this.konstPanel);
        this.contentPanel.remove(this.fktPanel);
        this.contentPanel.remove(this.tabFktPanel);
        this.contentPanel.remove(this.bedPanel);
        if (this.aktDef == null) {
            this.contentHeaderLabel.setText("");
            this.repaint();
            this.setVisible(true);
            return;
        }
        if (this.aktDef.art.equals(rbundle.getString("Konstante")) || this.aktDef.art.equals(rbundle.getString("Variable"))) {
            this.contentPanel.add((Component)this.konstPanel, "North");
            this.setSize(550, this.getHeight());
            this.contentHeaderLabel.setText(this.aktDef.name + s);
            this.konstLabel.setText(this.aktDef.name + " =");
            this.konstField.setText(this.aktDef.definition);
            this.repaint();
            this.setVisible(true);
        }
        if (this.aktDef.art.equals(rbundle.getString("Funktion"))) {
            this.contentHeaderLabel.setText(this.aktDef.name + s);
            this.fktLabel.setText(this.aktDef.name + "(\u01b6) =");
            if (this.aktDef.definition.length() == 0) {
                this.aktDef.definition = "\u01b6+1";
            }
            this.fktField.setText(this.aktDef.definition);
            this.xminField.setText("-10");
            this.xmaxField.setText("10");
            this.contentPanel.add(this.fktPanel);
            this.setSize(700, this.getHeight());
            this.repaint();
            this.model.werteAuslesen(false);
            this.fktPreviewPanel.repaint();
            this.setVisible(true);
        }
        if (this.aktDef.art.equals(rbundle.getString("Tabellenfkt"))) {
            this.contentHeaderLabel.setText(this.aktDef.name + s);
            this.contentPanel.add(this.tabFktPanel);
            this.setSize(700, this.getHeight());
            this.setTabTable();
            this.interpolCBox.setSelectedIndex(this.aktDef.interpolation);
            this.repaint();
            try {
                this.aktDef.xmin = this.aktDef.xDat.get(0);
                this.aktDef.xmax = this.aktDef.xDat.get(this.aktDef.xDat.size() - 1);
                this.tabFktPreviewPanel.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(true);
        }
        if (this.aktDef.art.equals(rbundle.getString("Bedingte_Var"))) {
            this.contentHeaderLabel.setText(this.aktDef.name + s);
            this.bedLabel1.setText(this.aktDef.name + " =");
            this.bedLabel2.setText(this.aktDef.name + " =");
            this.bedingungField.setText(this.aktDef.bedingung);
            this.positivField.setText(this.aktDef.positiv);
            this.negativField.setText(this.aktDef.negativ);
            this.contentPanel.add(this.bedPanel);
            this.setSize(550, this.getHeight());
            this.repaint();
            this.setVisible(true);
        }
        this.model.werteAuslesen(false);
    }

    private void setTabTable() {
        int size = this.aktDef.xDat.size();
        Object[][] eintraege = new Object[size + 1][2];
        for (int i = 0; i < size; ++i) {
            eintraege[i][0] = this.aktDef.xDat.get(i);
            eintraege[i][1] = this.aktDef.yDat.get(i);
        }
        this.tabTable.setModel(new DefaultTableModel(eintraege, new String[]{rbundle.getString("Variable"), rbundle.getString("Wert")}){

            public Class getColumnClass(int columnIndex) {
                return Double.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }
        });
        this.tabTable.getModel().addTableModelListener(e -> {
            int j2;
            Double xxx;
            int i;
            int si = this.tabTable.getSelectedRow();
            Double xx = (Double)this.tabTable.getValueAt(this.tabTable.getSelectedRow(), 0);
            Double yy = (Double)this.tabTable.getValueAt(this.tabTable.getSelectedRow(), 1);
            for (i = 0; i < this.tabTable.getSelectedRow(); ++i) {
                xxx = (Double)this.tabTable.getValueAt(i, 0);
                try {
                    if (!(xx < xxx)) continue;
                    for (j2 = this.tabTable.getSelectedRow(); j2 > i; --j2) {
                        this.tabTable.setValueAt(this.tabTable.getValueAt(j2 - 1, 0), j2, 0);
                        this.tabTable.setValueAt(this.tabTable.getValueAt(j2 - 1, 1), j2, 1);
                    }
                    this.tabTable.setValueAt(xx, i, 0);
                    this.tabTable.setValueAt(yy, i, 1);
                    si = i;
                    break;
                }
                catch (Exception j2) {
                    // empty catch block
                }
            }
            for (i = this.tabTable.getRowCount() - 1; i > this.tabTable.getSelectedRow(); --i) {
                xxx = (Double)this.tabTable.getValueAt(i, 0);
                try {
                    if (!(xx > xxx)) continue;
                    for (j2 = this.tabTable.getSelectedRow(); j2 < i; ++j2) {
                        this.tabTable.setValueAt(this.tabTable.getValueAt(j2 + 1, 0), j2, 0);
                        this.tabTable.setValueAt(this.tabTable.getValueAt(j2 + 1, 1), j2, 1);
                    }
                    this.tabTable.setValueAt(xx, i, 0);
                    this.tabTable.setValueAt(yy, i, 1);
                    si = i;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.aktDef.xDat.clear();
            this.aktDef.yDat.clear();
            for (i = 0; i < this.tabTable.getRowCount(); ++i) {
                if (this.tabTable.getValueAt(i, 0) == null) continue;
                this.aktDef.xDat.add((Double)this.tabTable.getValueAt(i, 0));
                this.aktDef.yDat.add((Double)this.tabTable.getValueAt(i, 1));
            }
            this.setTabTable();
            this.tabTable.getSelectionModel().setSelectionInterval(si, si);
            this.repaint();
            try {
                this.aktDef.xmin = this.aktDef.xDat.get(0);
                this.aktDef.xmax = this.aktDef.xDat.get(this.aktDef.xDat.size() - 1);
                this.tabFktPreviewPanel.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    class MiniKS
    extends JPanel {
        double XFaktor;
        double YFaktor;
        double XVersch;
        double YVersch;
        double XMin;
        double XMax;
        double YMin;
        double YMax;

        MiniKS() {
        }

        protected void calcFakVersch() {
            this.XFaktor = (this.XMax - this.XMin) / (double)(this.getWidth() - 6);
            this.YFaktor = -(this.YMax - this.YMin) / (double)(this.getHeight() - 6);
            this.XVersch = this.XMin;
            this.YVersch = this.YMax;
        }

        protected Point XyToScreen(double x, double y) {
            Point point = new Point();
            point.x = (int)((x - this.XVersch) / this.XFaktor) + 3;
            point.y = (int)((y - this.YVersch) / this.YFaktor) + 3;
            if (x == Double.NaN || y == Double.NaN) {
                point.setLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            return point;
        }

        private double findeYMin(Node n) {
            double min = Double.MAX_VALUE;
            for (double x = this.XMin; x < this.XMax; x += (this.XMax - this.XMin) / (double)this.getWidth()) {
                try {
                    ZusatzDefsAnzeige.this.model.parser.addVariable("x_ZDEFVAR", x);
                    double yvalue = (Double)ZusatzDefsAnzeige.this.model.parser.evaluate(n);
                    if (!(yvalue < min)) continue;
                    min = yvalue;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (min == Double.MAX_VALUE) {
                min = -1.0;
            }
            return min;
        }

        private double findeYMax(Node n) {
            double max = Double.MIN_VALUE;
            for (double x = this.XMin; x < this.XMax; x += (this.XMax - this.XMin) / (double)this.getWidth()) {
                try {
                    ZusatzDefsAnzeige.this.model.parser.addVariable("x_ZDEFVAR", x);
                    double yvalue = (Double)ZusatzDefsAnzeige.this.model.parser.evaluate(n);
                    if (!(yvalue > max)) continue;
                    max = yvalue;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (max == Double.MIN_VALUE) {
                max = 1.0;
            }
            return max;
        }

        @Override
        public void paint(Graphics g) {
            Node node = null;
            ZusatzDefsAnzeige.this.model.werteAuslesen(false);
            try {
                node = ZusatzDefsAnzeige.this.model.parser.parse(GreekLetterConstPanel.refactorStr(ZusatzDefsAnzeige.this.aktDef.name) + "(x_ZDEFVAR)");
                ZusatzDefsAnzeige.this.model.parser.preprocess(node);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.XMin = ZusatzDefsAnzeige.this.aktDef.xmin;
            this.XMax = ZusatzDefsAnzeige.this.aktDef.xmax;
            if (this.XMin == this.XMax) {
                return;
            }
            this.YMin = this.findeYMin(node);
            this.YMax = this.findeYMax(node);
            if (this.YMax - this.YMin == 0.0 && this.YMax > 0.0) {
                this.YMin = 0.0;
                this.YMax *= 1.1;
            }
            if (this.YMax - this.YMin == 0.0 && this.YMax < 0.0) {
                this.YMin *= 1.1;
                this.YMax = 0.0;
            }
            ZusatzDefsAnzeige.this.yminField.setText(Statics.doubleToString(this.YMin));
            ZusatzDefsAnzeige.this.ymaxField.setText(Statics.doubleToString(this.YMax));
            this.calcFakVersch();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setStroke(new BasicStroke(1.5f));
            g.setColor(Color.BLACK);
            Point point1 = this.XyToScreen(this.XMin, 0.0);
            Point point2 = this.XyToScreen(this.XMax, 0.0);
            g.drawLine(point1.x, point1.y, point2.x, point2.y);
            point1 = this.XyToScreen(0.0, this.YMin);
            point2 = this.XyToScreen(0.0, this.YMax);
            g.drawLine(point1.x, point1.y, point2.x, point2.y);
            g.setColor(Color.BLUE);
            try {
                ZusatzDefsAnzeige.this.model.parser.addVariable("x_ZDEFVAR", this.XMin);
                double y = (Double)ZusatzDefsAnzeige.this.model.parser.evaluate(node);
                point1 = this.XyToScreen(this.XMin, y);
                for (double x = this.XMin; x <= this.XMax; x += (this.XMax - this.XMin) / (double)this.getWidth()) {
                    ZusatzDefsAnzeige.this.model.parser.addVariable("x_ZDEFVAR", x);
                    y = (Double)ZusatzDefsAnzeige.this.model.parser.evaluate(node);
                    point2 = this.XyToScreen(x, y);
                    if (!Double.isNaN(y)) {
                        g.drawLine(point1.x, point1.y, point2.x, point2.y);
                    }
                    point1.x = point2.x;
                    point1.y = point2.y;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ZusatzDefsAnzeige.this.aktDef.art.equals(rbundle.getString("Tabellenfkt"))) {
                for (int i = 0; i < ZusatzDefsAnzeige.this.aktDef.xDat.size(); ++i) {
                    try {
                        point1 = this.XyToScreen(ZusatzDefsAnzeige.this.aktDef.xDat.get(i), ZusatzDefsAnzeige.this.aktDef.yDat.get(i));
                        g.fillOval(point1.x - 3, point1.y - 3, 6, 6);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class DoubleCellEditor
    extends DefaultCellEditor {
        Class[] argTypes;
        Constructor constructor;
        Object value;

        public DoubleCellEditor() {
            super(new JTextField());
            this.argTypes = new Class[]{String.class};
            this.getComponent().setName("Table.editor");
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            try {
                if (s.length() == 0) {
                    this.value = null;
                } else {
                    Object[] obj = new Object[]{s.replace(',', '.')};
                    this.value = this.constructor.newInstance(obj);
                    if (ZusatzDefsAnzeige.this.tabTable.getSelectedColumn() == 0) {
                        for (int i = 0; i < ZusatzDefsAnzeige.this.tabTable.getRowCount(); ++i) {
                            if (!((Double)this.value).equals(ZusatzDefsAnzeige.this.tabTable.getValueAt(i, 0))) continue;
                            throw new Exception("gibt's schon");
                        }
                    }
                }
            }
            catch (Exception e) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> type = table.getColumnClass(column);
                if (type == Object.class) {
                    type = String.class;
                }
                this.constructor = type.getConstructor(this.argTypes);
            }
            catch (Exception e) {
                return null;
            }
            if (value != null) {
                return super.getTableCellEditorComponent(table, Statics.doubleToString((Double)value), isSelected, row, column);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    class MenuCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JComboBox comboBox;

        public MenuCellEditor(JComboBox cb) {
            this.comboBox = cb;
            this.comboBox.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return e instanceof MouseEvent && ((MouseEvent)e).getClickCount() > 1;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comboBox.setSelectedItem((String)value);
            return this.comboBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((JComboBox)e.getSource()).isPopupVisible()) {
                this.fireEditingStopped();
            }
        }
    }

    class VarNameCellEditor
    extends DefaultCellEditor {
        Class[] argTypes;
        Constructor constructor;
        Object value;

        public VarNameCellEditor() {
            super(new JTextField());
            this.argTypes = new Class[]{String.class};
            ((JTextField)this.getComponent()).addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent evt) {
                    VarNameCellEditor.this.textFieldKeyTyped(evt);
                }

                @Override
                public void keyReleased(KeyEvent evt) {
                    VarNameCellEditor.this.textFieldKeyTyped(evt);
                }
            });
            ((JTextField)this.getComponent()).setComponentPopupMenu(GreekLetterConstPanel.greekLettersPM);
        }

        @Override
        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            try {
                if (s.length() == 0) {
                    this.value = null;
                } else {
                    Object[] obj = new Object[]{s.replace(',', '.')};
                    this.value = this.constructor.newInstance(obj);
                    if (ZusatzDefsAnzeige.this.tabTable.getSelectedColumn() == 0) {
                        for (int i = 0; i < ZusatzDefsAnzeige.this.tabTable.getRowCount(); ++i) {
                            if (!((Double)this.value).equals(ZusatzDefsAnzeige.this.tabTable.getValueAt(i, 0))) continue;
                            throw new Exception("gibt's schon");
                        }
                    }
                }
            }
            catch (Exception e) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> type = table.getColumnClass(column);
                if (type == Object.class) {
                    type = String.class;
                }
                this.constructor = type.getConstructor(this.argTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (SecurityException e) {
                return null;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        private void textFieldKeyTyped(KeyEvent evt) {
            JTextComponent tf = (JTextComponent)evt.getSource();
            GreekLetterConstPanel.tfInputHook(tf);
            ZusatzDefsAnzeige.this.aktDef.name = tf.getText();
            ZusatzDefsAnzeige.this.updateView();
        }
    }
}

