/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.calculation;

public class Interpolation {
    private final int MAX = 100;
    private final double DMIN = 1.0E-7;
    private double[] a = new double[101];
    private double[] b = new double[101];
    private double[] c = new double[101];
    private double[] d = new double[101];
    private double[] xn = new double[101];
    private int n;

    public void calcLinearCoefficients(double[] x, double[] y, int n) {
        if (n < 1) {
            return;
        }
        if (n > 100) {
            n = 100;
        }
        this.n = n;
        for (int i = 0; i < n; ++i) {
            this.xn[i] = x[i];
            this.a[i] = y[i];
            this.b[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
        }
        this.xn[n] = x[n];
        this.a[n] = y[n];
    }

    public double interpolateLinear(double x) {
        if (this.n < 1) {
            return Double.NaN;
        }
        for (int i = 0; i < this.n; ++i) {
            if (!(x < this.xn[i + 1])) continue;
            double dx = x - this.xn[i];
            return this.b[i] * (x - this.xn[i]) + this.a[i];
        }
        return this.b[this.n] * (x - this.xn[this.n]) + this.a[this.n];
    }

    public void calcPolynomCoefficients(double[] x, double[] y, int n) {
        int i;
        double d1 = 0.0;
        if (n < 1) {
            return;
        }
        if (n > 100) {
            n = 100;
        }
        this.n = n;
        this.a[0] = y[0];
        this.xn[0] = x[0];
        for (i = 1; i <= n; ++i) {
            this.a[i] = (y[i] - y[i - 1]) / (x[i] - x[i - 1]);
            this.xn[i] = x[i];
        }
        for (i = 2; i <= n; ++i) {
            d1 = this.a[i - 1];
            for (int k = i; k <= n; ++k) {
                double d2 = (this.a[k] - this.a[k - 1]) / (x[k] - x[k - i]);
                this.a[k - 1] = d1;
                d1 = d2;
            }
            this.a[n] = d1;
        }
    }

    public double interpolatePolynom(double x) {
        double y = 0.0;
        if (this.n < 1) {
            return Double.NaN;
        }
        for (int i = this.n - 1; i >= 0; --i) {
            y = (y + this.a[i + 1]) * (x - this.xn[i]);
        }
        return y + this.a[0];
    }

    public boolean calcSplinesCoefficients(double[] x, double[] y, int n) {
        int i;
        if (n > 100) {
            n = 100;
        }
        this.n = n;
        double h = x[1] - x[0];
        if (Math.abs(h) < 1.0E-7) {
            return false;
        }
        this.a[0] = 1.0 / h;
        this.xn[0] = x[0];
        this.xn[n] = x[n];
        this.b[n] = 0.0;
        this.b[0] = 0.0;
        this.b[0] = (y[1] - y[0]) / (x[1] - x[0]);
        this.b[n] = (y[n] - y[n - 1]) / (x[n] - x[n - 1]);
        for (i = 1; i < n; ++i) {
            this.xn[i] = x[i];
            h = x[i + 1] - x[i];
            if (Math.abs(h) < 1.0E-7) {
                return false;
            }
            this.a[i] = 1.0 / h;
            this.d[i] = 2.0 * (this.a[i - 1] + this.a[i]);
            this.b[i] = 3.0 * ((y[i + 1] - y[i]) * this.a[i] * this.a[i] + (y[i] - y[i - 1]) * this.a[i - 1] * this.a[i - 1]);
        }
        for (i = 2; i < n; ++i) {
            h = this.a[i - 1] / this.d[i - 1];
            int n2 = i;
            this.d[n2] = this.d[n2] - this.a[i - 1] * h;
            int n3 = i;
            this.b[n3] = this.b[n3] - this.b[i - 1] * h;
        }
        int n4 = n - 1;
        this.b[n4] = this.b[n4] / this.d[n - 1];
        for (i = n - 2; i > 0; --i) {
            this.b[i] = (this.b[i] - this.a[i] * this.b[i + 1]) / this.d[i];
        }
        for (i = 0; i < n; ++i) {
            this.a[i] = y[i];
            h = x[i + 1] - x[i];
            this.c[i] = (3.0 * (y[i + 1] - y[i]) / h - 2.0 * this.b[i] - this.b[i + 1]) / h;
            this.d[i] = (this.b[i] + this.b[i + 1] - 2.0 * (y[i + 1] - y[i]) / h) / h / h;
        }
        return true;
    }

    public double interpolateSplines(double x) {
        double y = 0.0;
        for (int i = 0; i < this.n; ++i) {
            if (!(x < this.xn[i + 1])) continue;
            double dx = x - this.xn[i];
            return this.a[i] + dx * (this.b[i] + dx * (this.c[i] + dx * this.d[i]));
        }
        double dx = x - this.xn[this.n - 1];
        return this.a[this.n - 1] + dx * (this.b[this.n - 1] + dx * (this.c[this.n - 1] + dx * this.d[this.n - 1]));
    }
}

