/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Statics;
import de.didappslib.guitools.AutoDialog;
import de.didappslib.guitools.UpdateDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StyleContext;

public class AboutBox
extends JDialog {
    ResourceBundle prgBundle = Statics.prg_Bundle;
    AboutBox me = this;
    private JButton closeUpdateInfoDialogButt;
    private JLabel copyrightLabel;
    private JLabel iconLabel;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JButton openDownloadURL;
    private JLabel prgNameLabel;
    private JLabel rightsLabel;
    private JButton showHistory;
    private JTextPane textPane;
    private JDialog updateInfoDialog;
    private JLabel versionLabel;

    public AboutBox() {
        this.initComponents();
        this.iconLabel.setIcon(Statics.splashScreen.getMultiResIcon(Statics.prg_Bundle.getString("INFOIMAGE"), 1.0f));
        this.prgNameLabel.setText(this.prgBundle.getString("Version") + " " + Statics.prgVersion);
        this.versionLabel.setText("(" + Statics.buildDate + ")");
        this.copyrightLabel.setText(this.prgBundle.getString("COPYRIGHT"));
        this.rightsLabel.setText(this.prgBundle.getString("RIGHTS"));
        this.pack();
        KeyAdapter myKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && e.getKeyChar() == 'w') {
                    AboutBox.this.me.setVisible(false);
                    return;
                }
                if (e.getKeyCode() == 27) {
                    AboutBox.this.me.setVisible(false);
                    return;
                }
            }
        };
        this.addKeyListener(myKeyListener);
        this.closeUpdateInfoDialogButt.getRootPane().setDefaultButton(this.closeUpdateInfoDialogButt);
    }

    private void initComponents() {
        this.openDownloadURL = new JButton();
        this.updateInfoDialog = new JDialog();
        this.jScrollPane2 = new JScrollPane();
        this.textPane = new JTextPane();
        this.closeUpdateInfoDialogButt = new JButton();
        this.iconLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.prgNameLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.copyrightLabel = new JLabel();
        this.rightsLabel = new JLabel();
        this.showHistory = new JButton();
        this.openDownloadURL.setText(Statics.rBundle.getString("Go_to_download_page"));
        this.openDownloadURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutBox.this.openDownloadURLActionPerformed(evt);
            }
        });
        this.updateInfoDialog.setTitle(Statics.rBundle.getString("Version_history"));
        this.updateInfoDialog.setMinimumSize(new Dimension(800, 600));
        this.updateInfoDialog.setModal(true);
        this.updateInfoDialog.getContentPane().setLayout(new GridBagLayout());
        this.textPane.setEditable(false);
        this.textPane.setContentType("text/rtf");
        this.jScrollPane2.setViewportView(this.textPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.updateInfoDialog.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.closeUpdateInfoDialogButt.setText(Statics.rBundle.getString("Close_window"));
        this.closeUpdateInfoDialogButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutBox.this.closeUpdateInfoDialogButtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 10);
        this.updateInfoDialog.getContentPane().add((Component)this.closeUpdateInfoDialogButt, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 340));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                AboutBox.this.formWindowActivated(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.iconLabel.setBackground(new Color(255, 255, 255));
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setOpaque(true);
        this.iconLabel.setPreferredSize(new Dimension(280, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.iconLabel, gridBagConstraints);
        this.jSeparator1.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jSeparator1.setPreferredSize(new Dimension(0, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.prgNameLabel.setFont(new Font("Lucida Grande", 1, 15));
        this.prgNameLabel.setHorizontalAlignment(0);
        this.prgNameLabel.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.getContentPane().add((Component)this.prgNameLabel, gridBagConstraints);
        this.versionLabel.setFont(new Font("Lucida Grande", 0, 12));
        this.versionLabel.setHorizontalAlignment(0);
        this.versionLabel.setText("1.1.1 (26.12.2012)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.versionLabel, gridBagConstraints);
        this.copyrightLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.copyrightLabel.setHorizontalAlignment(0);
        this.copyrightLabel.setText("<html><center>Copyright \u00a9 2010-2011 <br>Stephan L\u00fcck");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.getContentPane().add((Component)this.copyrightLabel, gridBagConstraints);
        this.rightsLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.rightsLabel.setHorizontalAlignment(0);
        this.rightsLabel.setText("Alle Rechte vorbehalten.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 20, 0);
        this.getContentPane().add((Component)this.rightsLabel, gridBagConstraints);
        this.showHistory.setText(Statics.rBundle.getString("Show_version_history..."));
        this.showHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutBox.this.showHistoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.getContentPane().add((Component)this.showHistory, gridBagConstraints);
        this.pack();
    }

    private void openDownloadURLActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI(this.prgBundle.getString("Download_link")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void formWindowActivated(WindowEvent evt) {
        Dimension sdim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(sdim.width / 2 - this.getWidth() / 2, (int)((double)sdim.height * 0.18));
        this.toFront();
    }

    private void showHistoryActionPerformed(ActionEvent evt) {
        this.showHistory();
    }

    private void closeUpdateInfoDialogButtActionPerformed(ActionEvent evt) {
        this.updateInfoDialog.setVisible(false);
    }

    public void showHistory() {
        DefaultStyledDocument styledDocument = new DefaultStyledDocument(new StyleContext());
        this.updateInfoDialog.setTitle(Statics.rBundle.getString("Version_history").replace("#", Statics.prgVersion));
        try {
            URL myurl = this.getClass().getResource(this.prgBundle.getString("Version_history_file"));
            InputStream in = myurl.openStream();
            UpdateDialog.RTF_KIT.read(in, (Document)styledDocument, 0);
            this.textPane.setDocument(styledDocument);
        }
        catch (Exception ex) {
            new AutoDialog((JFrame)null).display(this.prgBundle.getString("Could_not_load_version_history"), ex.getMessage());
            return;
        }
        Dimension sdim = Toolkit.getDefaultToolkit().getScreenSize();
        this.updateInfoDialog.setLocation(sdim.width / 2 - this.updateInfoDialog.getWidth() / 2, (int)((double)sdim.height * 0.15));
        this.updateInfoDialog.setVisible(true);
        this.closeUpdateInfoDialogButt.requestFocus();
    }
}

