/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;

public final class GUIDevice {
    private static final JavaVersion JAVA_VERSION = GUIDevice.getJavaVersion();

    private static JavaVersion getJavaVersion() {
        String versionString = System.getProperty("java.version");
        if (versionString.startsWith("1.8")) {
            return JavaVersion.V8;
        }
        if (versionString.startsWith("9.")) {
            return JavaVersion.V9;
        }
        if (versionString.startsWith("10.")) {
            return JavaVersion.V10;
        }
        if (versionString.startsWith("11.")) {
            return JavaVersion.V11;
        }
        if (versionString.startsWith("12.")) {
            return JavaVersion.V12;
        }
        if (versionString.startsWith("13.")) {
            return JavaVersion.V13;
        }
        if (versionString.startsWith("14.")) {
            return JavaVersion.V14;
        }
        throw new RuntimeException("Unsupported Java version");
    }

    public static GraphicsConfiguration getCurrentConfiguration(Component component) {
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return graphicsConfiguration;
    }

    public static GraphicsDevice getCurrentDevice(Component component) {
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
        return graphicsConfiguration.getDevice();
    }

    public static boolean isOnRetinaDisplay(Component component) {
        switch (JAVA_VERSION) {
            case V8: {
                return GUIDevice.isOnRetinaDisplayJava8(component);
            }
            case V9: 
            case V10: 
            case V11: 
            case V12: 
            case V13: 
            case V14: {
                return GUIDevice.isOnRetinaDisplayJava9(component);
            }
        }
        throw new AssertionError((Object)"Unreachable");
    }

    public static double getDisplayScalingFactor(Component component) {
        switch (JAVA_VERSION) {
            case V8: {
                return GUIDevice.getDisplayScalingFactorJava8(component);
            }
            case V9: 
            case V10: 
            case V11: 
            case V12: 
            case V13: 
            case V14: {
                return GUIDevice.getDisplayScalingFactorJava9(component);
            }
        }
        throw new AssertionError((Object)"Unreachable");
    }

    private static boolean isOnRetinaDisplayJava8(Component component) {
        GraphicsDevice device = GUIDevice.getCurrentDevice(component);
        try {
            Method getScaleFactorMethod = device.getClass().getMethod("getScaleFactor", new Class[0]);
            Object scale = getScaleFactorMethod.invoke((Object)device, new Object[0]);
            return scale instanceof Integer && (Integer)scale == 2;
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
    }

    private static boolean isOnRetinaDisplayJava9(Component component) {
        return !GUIDevice.getCurrentConfiguration(component).getDefaultTransform().isIdentity();
    }

    private static double getDisplayScalingFactorJava8(Component component) {
        return GUIDevice.isOnRetinaDisplayJava8(component) ? 2.0 : 1.0;
    }

    private static double getDisplayScalingFactorJava9(Component component) {
        return GUIDevice.getCurrentConfiguration(component).getDefaultTransform().getScaleX();
    }

    private static enum JavaVersion {
        V8,
        V9,
        V10,
        V11,
        V12,
        V13,
        V14;

    }
}

