/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Statics;
import de.didappslib.guitools.SmartInput;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public class GreekLetterConstPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Border border = BorderFactory.createLineBorder(new Color(0, 0, 0));
    private static final Border emptyborder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final String[] greekLetters = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "jota", "kappa", "lambda", "mu", "nu", "xi", "omikron", "pi", "rho", "sigma", "tau", "ypsilon", "phi", "chi", "psi", "omega", "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Jota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omikron", "Pi", "Rho", "Sigma", "Tau", "Ypsilon", "Phi", "Chi", "Psi", "Omega"};
    public static final String[] greekSymbols = new String[]{"\u03b1", "\u03b2", "\u03b3", "\u03b4", "\u03b5", "\u03b6", "\u03b7", "\u03d1", "\u03b9", "\u03ba", "\u03bb", "\u03bc", "\u03bd", "\u03be", "\u03bf", "\u03c0", "\u03c1", "\u03c3", "\u03c4", "\u03c5", "\u03c6", "\u03c7", "\u03c8", "\u03c9", "\u0391", "\u0392", "\u0393", "\u0394", "\u0395", "\u0396", "\u0397", "\u0398", "\u0399", "\u039a", "\u039b", "\u039c", "\u039d", "\u039e", "\u039f", "\u03a0", "\u03a1", "\u03a3", "\u03a4", "\u03a5", "\u03a6", "\u03a7", "\u03a8", "\u03a9"};
    public static final String[] indexpo = new String[]{"_0", "_1", "_2", "_3", "_4", "_5", "_6", "_7", "_8", "_9", "^2", "^3"};
    public static final String[] indexpoSymbols = new String[]{"\u2080", "\u2081", "\u2082", "\u2083", "\u2084", "\u2085", "\u2086", "\u2087", "\u2088", "\u2089", "\u00b2", "\u00b3"};
    public static final String[] constants = new String[]{"light", "gravit", "Gravit", "mag", "mbohr", "diel", "qel", "mel", "mprot", "mneut", "malpha", "mmuon", "atommass", "planck", "hbar", "kboltz", "avog", "euler"};
    public static final String[] constantsSymbols = new String[]{"\u0109", "\u011d", "\u011c", "\u03bc\u2080", "\u03bc\u0299", "\u03b5\u2080", "qe", "me", "mp", "mn", "m\u03b1", "m\u03bc", "\u00fb", "\u0125", "\u0127", "k\u0299", "\u00d1", "\u0207"};
    public static final String asterix = "*";
    public static final String multiplicationSymbol = System.getProperty("os.name").contains("Mac") ? "\u2219" : "\u22c5";
    public static final String dotProduct = "dotp";
    public static final String dotProductSymbol = "\u2299";
    public static final String vecProduct = "vecp";
    public static final String vecProductSymbol = "\u2297";
    public static final String coDivider = "codiv";
    public static final String coDividerSymbol = "|";
    private static SmartInput smartInput;
    public static String oldStr;
    public static String newStr;
    public static JPopupMenu greekLettersPM;

    public GreekLetterConstPanel(SmartInput sminput) {
        smartInput = sminput;
        ResourceBundle prop = ResourceBundle.getBundle("de/didappslib/guitools/resources/GreekLetterPanel", Statics.locale);
        if (Statics.os.contains("Mac")) {
            GreekLetterConstPanel.greekSymbols[20] = "\u03d5";
        }
        this.initComponents();
        greekLettersPM.setBackground(Statics.sidebarBackColor);
        this.setBackground(Statics.sidebarBackColor);
        JLabel label = new JLabel("");
        Font font = new Font("Serif", 2, 15);
        GridBagConstraints constraints = new GridBagConstraints();
        for (int i = 0; i < greekLetters.length + indexpo.length + constants.length + 4; ++i) {
            int j;
            if (i < greekLetters.length) {
                label = new JLabel(greekSymbols[i]);
                if (i != 15) {
                    label.setToolTipText(greekLetters[i]);
                } else {
                    label.setToolTipText(prop.getString("pi_TIP"));
                }
            } else if (i < greekLetters.length + indexpo.length) {
                j = i - greekLetters.length;
                label = new JLabel(indexpoSymbols[j]);
                label.setToolTipText("Numerischer Index (" + indexpo[i - greekLetters.length] + ")");
                if (j > 9) {
                    label.setToolTipText(prop.getString(indexpo[j].substring(0, indexpo[j].length()) + "_TIP").replace("#", " (" + indexpo[j] + ")"));
                }
            } else if (i < greekLetters.length + indexpo.length + constants.length) {
                j = i - indexpo.length - greekLetters.length;
                label = new JLabel(constantsSymbols[j]);
                label.setToolTipText(GreekLetterConstPanel.repairCDot(prop.getString(constants[j].substring(0, constants[j].length()) + "_TIP")).replace("#", " (" + constants[j] + ")"));
            } else if (i == greekLetters.length + indexpo.length + constants.length) {
                label = new JLabel(multiplicationSymbol);
                label.setToolTipText(prop.getString("multiplication_TIP"));
            } else if (Statics.prgName.contains("Fluxion") && i == greekLetters.length + indexpo.length + constants.length + 1) {
                label = new JLabel(dotProductSymbol);
                label.setToolTipText(prop.getString("dotProduct_TIP"));
            } else if (Statics.prgName.contains("Fluxion") && i == greekLetters.length + indexpo.length + constants.length + 2) {
                label = new JLabel(vecProductSymbol);
                label.setToolTipText(prop.getString("vecProductTIP"));
            } else if (Statics.prgName.contains("Fluxion") && i == greekLetters.length + indexpo.length + constants.length + 3) {
                label = new JLabel(coDividerSymbol);
                label.setToolTipText(prop.getString("coDividerTIP"));
            }
            label.setFont(font);
            label.setHorizontalAlignment(0);
            label.setBorder(emptyborder);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    GreekLetterConstPanel.this.labelMouseClicked(evt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    GreekLetterConstPanel.this.labelMouseExited(evt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    GreekLetterConstPanel.this.labelMouseEntered(evt);
                }
            });
            constraints.gridx = i % 12;
            constraints.gridy = i / 12;
            constraints.fill = 2;
            label.setPreferredSize(new Dimension(26, label.getMinimumSize().height));
            constraints.ipady = 2;
            this.add((Component)label, constraints);
        }
        greekLettersPM.insert(this, 0);
    }

    private void labelMouseExited(MouseEvent evt) {
        if (evt.getComponent() instanceof JLabel) {
            ((JLabel)evt.getComponent()).setBorder(emptyborder);
        }
    }

    private void labelMouseEntered(MouseEvent evt) {
        if (evt.getComponent() instanceof JLabel) {
            ((JLabel)evt.getComponent()).setBorder(border);
        }
    }

    private void labelMouseClicked(MouseEvent evt) {
        JTextComponent tc = (JTextComponent)greekLettersPM.getInvoker();
        greekLettersPM.setVisible(false);
        if (tc == null) {
            return;
        }
        int cpos = tc.getSelectionStart();
        int l = ((JLabel)evt.getComponent()).getText().length();
        tc.replaceSelection(((JLabel)evt.getComponent()).getText());
        tc.setCaretPosition(cpos + l);
        tc.moveCaretPosition(cpos + l);
        tc.firePropertyChange("GreekInserted", true, false);
    }

    private void initComponents() {
        greekLettersPM = new JPopupMenu();
        greekLettersPM.setInheritsPopupMenu(true);
        greekLettersPM.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                GreekLetterConstPanel.this.greekLettersPMPopupMenuWillBecomeVisible(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GreekLetterConstPanel.this.formMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GreekLetterConstPanel.this.formMouseExited(evt);
            }
        });
        this.setLayout(new GridBagLayout());
    }

    private void formMouseExited(MouseEvent evt) {
        if (evt.getComponent() instanceof JLabel) {
            ((JLabel)evt.getComponent()).setBorder(emptyborder);
        }
    }

    private void formMouseEntered(MouseEvent evt) {
        if (evt.getComponent() instanceof JLabel) {
            ((JLabel)evt.getComponent()).setBorder(border);
        }
    }

    private void greekLettersPMPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((JLabel)this.getComponent(i)).setBorder(emptyborder);
        }
    }

    public static void tfInputHook(JTextComponent tf) {
        int i;
        if (!smartInput.isOn()) {
            return;
        }
        int caretpos = tf.getCaretPosition();
        String s = tf.getText();
        int slength = s.length();
        if (smartInput.numIndOn()) {
            for (i = 0; i < indexpo.length; ++i) {
                if (!s.contains(indexpo[i])) continue;
                tf.setText(s.replace(indexpo[i], indexpoSymbols[i]));
                tf.setCaretPosition(caretpos - (slength - tf.getText().length()));
                return;
            }
        }
        if (smartInput.multOn() && s.contains(asterix)) {
            tf.setText(s.replace(asterix, multiplicationSymbol));
            tf.setCaretPosition(caretpos);
            return;
        }
        for (i = 0; i < greekLetters.length; ++i) {
            while (s.contains("\\" + greekLetters[i])) {
                tf.setText(s.replace("\\" + greekLetters[i], greekSymbols[i]));
                s = tf.getText();
                try {
                    tf.setCaretPosition(caretpos - greekLetters[i].length());
                }
                catch (Exception e) {
                    tf.setCaretPosition(s.length());
                }
            }
        }
        for (i = 0; i < constants.length; ++i) {
            while (s.contains("\\" + constants[i])) {
                tf.setText(s.replace("\\" + constants[i], constantsSymbols[i]));
                s = tf.getText();
                try {
                    tf.setCaretPosition(caretpos - constants[i].length() + constantsSymbols[i].length() - 1);
                }
                catch (Exception e) {
                    tf.setCaretPosition(s.length());
                }
            }
        }
        if (Statics.prgName.contains("Fluxion")) {
            while (s.contains("\\dotp")) {
                tf.setText(s.replace("\\dotp", dotProductSymbol));
                s = tf.getText();
                try {
                    tf.setCaretPosition(caretpos - dotProduct.length());
                }
                catch (Exception e) {
                    tf.setCaretPosition(s.length());
                }
            }
            while (s.contains("\\vecp")) {
                tf.setText(s.replace("\\vecp", vecProductSymbol));
                s = tf.getText();
                try {
                    tf.setCaretPosition(caretpos - vecProduct.length());
                }
                catch (Exception e) {
                    tf.setCaretPosition(s.length());
                }
            }
            while (s.contains("\\codiv")) {
                tf.setText(s.replace("\\codiv", coDividerSymbol));
                s = tf.getText();
                try {
                    tf.setCaretPosition(caretpos - coDivider.length());
                }
                catch (Exception e) {
                    tf.setCaretPosition(s.length());
                }
            }
        }
        if (smartInput.backslashNeeded()) {
            return;
        }
        Boolean doReplace = false;
        int pos = 0;
        int pos_end = 0;
        block18: for (int i2 = 0; i2 < greekLetters.length; ++i2) {
            while (s.indexOf(greekLetters[i2], pos) != -1) {
                pos = s.indexOf(greekLetters[i2], pos);
                pos_end = pos + greekLetters[i2].length();
                if (pos != -1) {
                    doReplace = true;
                    if (greekLetters[i2].equals("eta") & s.contains("beta")) {
                        doReplace = false;
                    }
                    if (greekLetters[i2].equals("eta") & s.contains("Beta")) {
                        doReplace = false;
                    }
                    if (greekLetters[i2].equals("eta") & s.contains("zeta")) {
                        doReplace = false;
                    }
                    if (greekLetters[i2].equals("eta") & s.contains("Zeta")) {
                        doReplace = false;
                    }
                    if (greekLetters[i2].equals("psi") & s.contains("epsi")) {
                        doReplace = false;
                    }
                    if (greekLetters[i2].equals("psi") & s.contains("Epsi")) {
                        doReplace = false;
                    }
                    if (pos != 0 && s.substring(pos - 1, pos).matches("[a-zA-Z]")) {
                        doReplace = false;
                    }
                    if (pos_end < s.length()) {
                        if (s.substring(pos_end, pos_end + 1).matches("[a-zA-Z]")) {
                            doReplace = false;
                        }
                    } else {
                        doReplace = false;
                    }
                }
                if (doReplace.booleanValue()) {
                    tf.setText(s.substring(0, pos) + greekSymbols[i2] + s.substring(pos_end, slength));
                    tf.setCaretPosition(caretpos - greekLetters[i2].length() + 1);
                    continue block18;
                }
                pos = pos_end;
            }
        }
        int len = tf.getText().length();
        s = tf.getText();
        for (int i3 = 0; i3 < constants.length; ++i3) {
            if (s.contains(constants[i3]) && s.indexOf(constants[i3]) + constants[i3].length() != s.length()) {
                tf.setText(s.replaceFirst("(?<![a-zA-Z])" + constants[i3] + "(?![a-zA-Z])", constantsSymbols[i3]));
            }
            if (tf.getText().length() == len) continue;
            tf.setCaretPosition(caretpos - constants[i3].length() + constantsSymbols[i3].length());
            return;
        }
        if (!Statics.prgName.contains("Fluxion")) {
            return;
        }
        if (s.contains(dotProduct) && s.indexOf(dotProduct) + dotProduct.length() != s.length()) {
            tf.setText(s.replaceFirst("(?<![a-zA-Z])dotp(?![a-zA-Z])", dotProductSymbol));
        }
        if (tf.getText().length() != len) {
            tf.setCaretPosition(caretpos - dotProduct.length() + 1);
            return;
        }
        if (s.contains(vecProduct) && s.indexOf(vecProduct) + vecProduct.length() != s.length()) {
            tf.setText(s.replaceFirst("(?<![a-zA-Z])vecp(?![a-zA-Z])", vecProductSymbol));
        }
        if (tf.getText().length() != len) {
            tf.setCaretPosition(caretpos - vecProduct.length() + 1);
            return;
        }
        if (s.contains(coDivider) && s.indexOf(coDivider) + coDivider.length() != s.length()) {
            tf.setText(s.replaceFirst("(?<![a-zA-Z])codiv(?![a-zA-Z])", coDividerSymbol));
        }
        if (tf.getText().length() != len) {
            tf.setCaretPosition(caretpos - coDivider.length() + 1);
            return;
        }
    }

    private static int tryToReplaceInTF(String s, String symbolText, int pos) {
        pos = s.indexOf(symbolText, pos);
        int pos_end = pos + symbolText.length();
        System.out.println(pos_end);
        if (pos != -1) {
            if (pos > 0 && pos_end < s.length() && (s.substring(pos - 1, pos).matches("[a-zA-Z]") || s.substring(pos_end, pos_end + 1).matches("[a-zA-Z]"))) {
                pos_end = -1;
            }
            if (pos_end == s.length()) {
                pos_end = -1;
            }
        }
        System.out.println(pos_end);
        return pos_end;
    }

    public static String refactorStr(String s) {
        s = s.replace("\t", " ");
        while ((s = s.replaceAll("; ", ";")).contains("; ")) {
        }
        while ((s = s.replaceAll(";;", ";")).contains(";;")) {
        }
        s = s.replaceAll("(?<=[0-9]),(?=[0-9])", ".");
        s = s.replace("'", "_deriv").replace("\u22c5", asterix).replace("\u2219", asterix).replace("\u221a", "sqrt").replace("\u00b2", "^2").replace("\u00b3", "^3").replace("\u2080", "_0").replace("\u2081", "_1").replace("\u2082", "_2").replace("\u2083", "_3").replace("\u2084", "_4").replace("\u2085", "_5").replace("\u2086", "_6").replace("\u2087", "_7").replace("\u2088", "_8").replace("\u2089", "_9").replaceAll("(?<!\\|)\\|(?!\\|)", ",").replace(dotProductSymbol, " . ").replace(vecProductSymbol, "^^");
        return s;
    }

    public static String refactorASCIIStr(String s) {
        s = s.replace("\u22c5", asterix).replace("\u2219", asterix).replace("\u03d5", "\u03c6");
        return s;
    }

    public static String factorASCIIStr(String s) {
        int i;
        if (s == null) {
            return s;
        }
        for (i = 0; i < indexpo.length; ++i) {
            s = s.replace(indexpo[i], indexpoSymbols[i]);
        }
        s = s.replace(asterix, multiplicationSymbol);
        for (i = 0; i < greekLetters.length; ++i) {
            s = s.replace("\\" + greekLetters[i], greekSymbols[i]);
        }
        for (i = 0; i < constants.length; ++i) {
            s = s.replace("\\" + constants[i], constantsSymbols[i]);
        }
        return s;
    }

    public static String refactorTF(JTextComponent tf) {
        return GreekLetterConstPanel.refactorStr(tf.getText());
    }

    public static String repairCDot(String s) {
        if (System.getProperty("os.name").contains("Mac")) {
            return s.replace("\u22c5", "\u2219");
        }
        return s.replace("\u2219", "\u22c5");
    }

    public static String applySmartInputOnLoad(String s_in) {
        String s_out = s_in;
        s_out = Statics.os.contains("Mac") ? s_out.replace("\u03c6", "\u03d5") : s_out.replace("\u03d5", "\u03c6");
        s_out = GreekLetterConstPanel.repairCDot(s_out);
        s_out = GreekLetterConstPanel.factorASCIIStr(s_out);
        return s_out;
    }
}

