/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.DocumentPanel;
import de.didappslib.base.Statics;
import de.didappslib.guitools.GreekLetterConstPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;

public class SuperSlider
extends JPanel {
    private final ResourceBundle rBundle = ResourceBundle.getBundle("de/didappslib/guitools/resources/SuperSlider", Statics.locale);
    private double min;
    private double max;
    private double merkefuerundo;
    private double aktSliderValue;
    private double savedSliderValue;
    DocumentPanel viewer;
    private boolean update = true;
    private JPanel buttonPanel;
    private JLabel eqLabel;
    private JTextField maxField;
    private JTextField minField;
    private JTextField nameField;
    private JButton removeButton;
    private JPanel sliderPanel;
    private JSlider theSlider;
    private JTextField valueField;

    public SuperSlider(String name, double val, double mi, double ma, DocumentPanel anz) {
        this.viewer = anz;
        this.initComponents();
        this.removeButton.setIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/minus", 1.0f));
        this.removeButton.setRolloverIcon(Statics.splashScreen.getMultiResIcon("/de/didappslib/images/minus_dk", 1.0f));
        this.setPreferredSize(null);
        this.setName(name);
        this.setValue(val);
        this.setMinMax(mi, ma);
        this.merkefuerundo = val;
        this.setSavedSliderValueToAktSliderValue();
    }

    private void initComponents() {
        this.nameField = new JTextField();
        this.eqLabel = new JLabel();
        this.valueField = new JTextField();
        this.sliderPanel = new JPanel();
        this.theSlider = new JSlider();
        this.minField = new JTextField();
        this.maxField = new JTextField();
        this.buttonPanel = new JPanel();
        this.removeButton = new JButton();
        this.setBackground(Statics.sidebarBackColor);
        this.setMinimumSize(new Dimension(200, 45));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(300, 45));
        this.setLayout(new GridBagLayout());
        this.nameField.setBackground(Statics.sidebarBackColor);
        this.nameField.setColumns(3);
        this.nameField.setFont(new Font("Serif", 2, 16));
        this.nameField.setHorizontalAlignment(11);
        this.nameField.setText("m");
        this.nameField.setToolTipText(this.rBundle.getString("NameField_TIP"));
        this.nameField.setAutoscrolls(false);
        this.nameField.setBorder(null);
        this.nameField.setComponentPopupMenu(GreekLetterConstPanel.greekLettersPM);
        this.nameField.setDragEnabled(false);
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuperSlider.this.nameFieldAction(evt);
            }
        });
        this.nameField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SuperSlider.this.nameFieldPropertyChange(evt);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SuperSlider.this.nameFieldKeyEvent(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.nameField, gridBagConstraints);
        this.eqLabel.setFont(new Font("Dialog", 0, 11));
        this.eqLabel.setHorizontalAlignment(0);
        this.eqLabel.setText("=");
        this.eqLabel.setToolTipText("");
        this.eqLabel.setName("m");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.eqLabel, gridBagConstraints);
        this.valueField.setColumns(5);
        this.valueField.setFont(new Font("Serif", 2, 15));
        this.valueField.setToolTipText(this.rBundle.getString("valueField_TIP"));
        this.valueField.setMinimumSize(new Dimension(65, 26));
        this.valueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SuperSlider.this.valueFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SuperSlider.this.valueFieldFocusLost(evt);
            }
        });
        this.valueField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuperSlider.this.valueFieldAction(evt);
            }
        });
        this.valueField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SuperSlider.this.valueFieldKeyEvent(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.valueField, gridBagConstraints);
        this.sliderPanel.setOpaque(false);
        this.sliderPanel.setLayout(new GridBagLayout());
        this.theSlider.setBackground(Statics.sidebarBackColor);
        this.theSlider.setMajorTickSpacing(20);
        this.theSlider.setMinorTickSpacing(5);
        this.theSlider.setPaintTicks(true);
        this.theSlider.setToolTipText(this.rBundle.getString("Slider_TIP"));
        this.theSlider.setValue(0);
        this.theSlider.setMaximumSize(new Dimension(250, 38));
        this.theSlider.setPreferredSize(new Dimension(150, 38));
        this.theSlider.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                SuperSlider.this.theSliderMouseDragged(evt);
            }
        });
        this.theSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SuperSlider.this.theSliderMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SuperSlider.this.theSliderMouseReleased(evt);
            }
        });
        this.theSlider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SuperSlider.this.theSliderKeyTyped(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                SuperSlider.this.theSliderKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(-7, 0, 0, 0);
        this.sliderPanel.add((Component)this.theSlider, gridBagConstraints);
        this.minField.setBackground(Statics.sidebarBackColor);
        this.minField.setFont(new Font("Dialog", 0, 11));
        this.minField.setHorizontalAlignment(2);
        this.minField.setText("-10");
        this.minField.setToolTipText(this.rBundle.getString("minField_TIP"));
        this.minField.setBorder(null);
        this.minField.setMinimumSize(new Dimension(18, 13));
        this.minField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuperSlider.this.minFieldAction(evt);
            }
        });
        this.minField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SuperSlider.this.minFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = -2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.sliderPanel.add((Component)this.minField, gridBagConstraints);
        this.maxField.setBackground(Statics.sidebarBackColor);
        this.maxField.setFont(new Font("Dialog", 0, 11));
        this.maxField.setHorizontalAlignment(4);
        this.maxField.setText("10");
        this.maxField.setToolTipText(this.rBundle.getString("maxField_TIP"));
        this.maxField.setBorder(null);
        this.maxField.setMinimumSize(new Dimension(12, 13));
        this.maxField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SuperSlider.this.maxFieldFocusLost(evt);
            }
        });
        this.maxField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuperSlider.this.maxFieldAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = -2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.sliderPanel.add((Component)this.maxField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        this.add((Component)this.sliderPanel, gridBagConstraints);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setPreferredSize(new Dimension(32, 15));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.removeButton.setBackground(new Color(222, 222, 222));
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/de/didappslib/images/minus.png")));
        this.removeButton.setToolTipText(this.rBundle.getString("removeButton_TIP"));
        this.removeButton.setBorderPainted(false);
        this.removeButton.setContentAreaFilled(false);
        this.removeButton.setPreferredSize(new Dimension(12, 12));
        this.removeButton.setRolloverEnabled(true);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuperSlider.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(-14, 0, 0, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void valueFieldFocusLost(FocusEvent evt) {
    }

    private void valueFieldFocusGained(FocusEvent evt) {
    }

    private void maxFieldFocusLost(FocusEvent evt) {
        double d = Double.NaN;
        try {
            d = Double.parseDouble(this.maxField.getText().replace(',', '.'));
            this.maxField.setBackground(Statics.sidebarBackColor);
            Statics.aktProjekt.clrError();
        }
        catch (Exception e) {
            Statics.aktProjekt.errorMsg(Statics.rBundle.getString("Fehler_im_Eingabefeld!"), Statics.rBundle.getString("Das_Eingabefeld_beschreibt_keine_Dezimalzahl."), this.maxField, false);
        }
        if (!("" + d).equals("NaN")) {
            this.max = d;
            this.setMinMax(this.min, this.max);
        }
    }

    private void minFieldFocusLost(FocusEvent evt) {
        double d = Double.NaN;
        try {
            d = Double.parseDouble(this.minField.getText().replace(',', '.'));
            Statics.aktProjekt.clrError();
            this.minField.setBackground(Statics.sidebarBackColor);
        }
        catch (Exception e) {
            Statics.aktProjekt.errorMsg(Statics.rBundle.getString("Fehler_im_Eingabefeld!"), Statics.rBundle.getString("Das_Eingabefeld_beschreibt_keine_Dezimalzahl."), this.minField, false);
        }
        if (!("" + d).equals("NaN")) {
            this.min = d;
            this.setMinMax(this.min, this.max);
        }
    }

    private void nameFieldKeyEvent(KeyEvent evt) {
        JTextComponent tf = (JTextComponent)evt.getSource();
        GreekLetterConstPanel.tfInputHook(tf);
        this.action("NameChanged");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.action("Deleted");
    }

    private void valueFieldKeyEvent(KeyEvent evt) {
        double d = Statics.textFieldToDouble(this.valueField, false);
        if (!("" + d).equals("NaN")) {
            this.update = false;
            this.setValue(d);
            this.update = true;
        }
        if (evt.getKeyCode() == 10 && (evt.getModifiersEx() & 0x40) != 0) {
            this.action("SuperSliderValueChanged");
        }
    }

    private void theSliderMouseReleased(MouseEvent evt) {
        if (!this.theSlider.isEnabled()) {
            return;
        }
        this.setValue((double)this.theSlider.getValue() * (this.max - this.min) / 100.0 + this.min);
        if (this.checkSlider()) {
            this.action("SuperSliderValueChanged");
        }
    }

    private void theSliderMousePressed(MouseEvent evt) {
        if (!this.theSlider.isEnabled()) {
            return;
        }
        this.setValue((double)this.theSlider.getValue() * (this.max - this.min) / 100.0 + this.min);
        if (this.checkSlider()) {
            this.action("SuperSliderValueChanged");
        }
    }

    private void theSliderMouseDragged(MouseEvent evt) {
        if (!this.theSlider.isEnabled()) {
            return;
        }
        this.setValue((double)this.theSlider.getValue() * (this.max - this.min) / 100.0 + this.min);
        if (this.checkSlider()) {
            this.action("SuperSliderValueChanged");
        }
    }

    private void maxFieldAction(ActionEvent evt) {
        this.requestFocus();
    }

    private void minFieldAction(ActionEvent evt) {
        this.requestFocus();
    }

    private void nameFieldAction(ActionEvent evt) {
        this.action("ActionEvent");
    }

    private void valueFieldAction(ActionEvent evt) {
        this.action("ActionEvent");
    }

    private void nameFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("GreekInserted")) {
            this.action("NameChanged");
        }
    }

    private void theSliderKeyTyped(KeyEvent evt) {
        if (!this.theSlider.isEnabled()) {
            return;
        }
        this.setValue((double)this.theSlider.getValue() * (this.max - this.min) / 100.0 + this.min);
        if (this.checkSlider()) {
            this.action("SuperSliderValueChanged");
        }
    }

    @Override
    public String getName() {
        return GreekLetterConstPanel.refactorTF(this.nameField);
    }

    public double getMin() {
        return Statics.stringToDouble(this.minField.getText());
    }

    public double getMax() {
        return Statics.stringToDouble(this.maxField.getText());
    }

    public double getValue() {
        return this.aktSliderValue;
    }

    public JTextField getValueField() {
        return this.valueField;
    }

    public boolean checkSlider() {
        return this.aktSliderValue != this.savedSliderValue;
    }

    public void setEditable(boolean b) {
        this.nameField.setEditable(b);
        this.removeButton.setEnabled(b);
    }

    public void resize(float scale) {
        float newSmallLabFontSize = 11.0f * scale * (scale == 1.0f ? 1.0f : 0.98f);
        float newLabFontSize = (float)Statics.labelFontSize * scale * (scale == 1.0f ? 1.0f : 0.98f);
        float newMathLabFontSize = (float)Statics.mathFontSize * scale;
        float newFieldFontSize = (float)Statics.mathFontSize * scale * (scale == 1.0f ? 1.0f : 1.05f);
        this.nameField.setFont(this.nameField.getFont().deriveFont(newMathLabFontSize));
        this.eqLabel.setFont(this.eqLabel.getFont().deriveFont(newMathLabFontSize));
        this.eqLabel.setPreferredSize(new Dimension((int)(13.0f * scale), (int)(22.0f * scale)));
        this.valueField.setFont(this.valueField.getFont().deriveFont(newFieldFontSize));
        this.minField.setFont(this.minField.getFont().deriveFont(newSmallLabFontSize));
        this.maxField.setFont(this.maxField.getFont().deriveFont(newSmallLabFontSize));
    }

    public void adjustAddKonstButton(JButton button) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.buttonPanel.add((Component)button, gridBagConstraints);
    }

    @Override
    public void setEnabled(boolean tf) {
        this.nameField.setEnabled(tf);
        this.valueField.setEnabled(tf);
        this.minField.setEnabled(tf);
        this.maxField.setEnabled(tf);
        this.theSlider.setEnabled(tf);
        this.removeButton.setEnabled(tf);
    }

    @Override
    public void setName(String n) {
        this.nameField.setText(n);
    }

    public void setMinMax(double mi, double ma) {
        this.min = mi;
        this.max = ma;
        this.minField.setText(Statics.doubleToString(mi));
        this.maxField.setText(Statics.doubleToString(ma));
        this.setValue(this.getValue());
    }

    public void setValue(double v) {
        if (this.update) {
            this.valueField.setText(Statics.doubleToString(v));
        }
        this.theSlider.setValue((int)((v - this.min) * 100.0 / (this.max - this.min)));
        this.aktSliderValue = v;
    }

    public void setSavedSliderValueToAktSliderValue() {
        this.savedSliderValue = this.aktSliderValue;
    }

    private void action(String what) {
        JPanel jp = (JPanel)this.getParent();
        if (jp != null) {
            jp.firePropertyChange(what + " " + this.getName(), true, false);
        }
    }

    public class UndoableSliderChange
    extends AbstractUndoableEdit {
        double oldVal;
        double newVal;
        SuperSlider comp;

        public UndoableSliderChange(SuperSlider c, double oldval, double newval) {
            this.comp = c;
            this.oldVal = oldval;
            this.newVal = newval;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public void redo() {
            SuperSlider.this.merkefuerundo = this.newVal;
            this.comp.setValue(this.newVal);
        }

        @Override
        public void undo() {
            SuperSlider.this.merkefuerundo = this.oldVal;
            this.comp.setValue(this.oldVal);
        }
    }
}

