/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Document;
import de.didappslib.base.Statics;
import de.didappslib.guitools.AutoDialog;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyleContext;
import javax.swing.text.rtf.RTFEditorKit;

public class UpdateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/guitools/resources/UpdateDialog", Statics.locale);
    public static final RTFEditorKit RTF_KIT = new RTFEditorKit();
    public static final int CLOSE = 1;
    public static final int GO = 2;
    Document projekt;
    int state = 1;
    private JCheckBox askCB;
    private JButton closeButton;
    private JLabel explanationLabel;
    private JButton goButton;
    private JLabel headerLabel;
    private JScrollPane infoSP;
    private JLabel jLabel1;
    private JLabel notesLab;
    private JTextPane textPane;

    public UpdateDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        this.getRootPane().getActionMap().put("CANCEL", this.closeButton.getAction());
        this.goButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.goButton);
        this.goButton.requestFocus();
    }

    private void initComponents() {
        JLabel imageLabel = new JLabel();
        this.headerLabel = new JLabel();
        this.explanationLabel = new JLabel();
        this.notesLab = new JLabel();
        this.infoSP = new JScrollPane();
        this.textPane = new JTextPane();
        this.jLabel1 = new JLabel();
        this.closeButton = new JButton();
        this.goButton = new JButton();
        this.askCB = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.rbundle.getString("Title"));
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        imageLabel.setHorizontalAlignment(0);
        imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/ProgramIcon_100.png")));
        imageLabel.setMaximumSize(new Dimension(160, 160));
        imageLabel.setPreferredSize(new Dimension(120, 115));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)imageLabel, gridBagConstraints);
        this.headerLabel.setFont(new Font("Dialog", 1, 14));
        this.headerLabel.setText(this.rbundle.getString("MainText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 2, 0);
        this.getContentPane().add((Component)this.headerLabel, gridBagConstraints);
        this.explanationLabel.setFont(new Font("Dialog", 0, 12));
        this.explanationLabel.setText(this.rbundle.getString("SubText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 1, 0, 15);
        this.getContentPane().add((Component)this.explanationLabel, gridBagConstraints);
        this.notesLab.setFont(new Font("Lucida Grande", 1, 13));
        this.notesLab.setText(this.rbundle.getString("Release_notes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.getContentPane().add((Component)this.notesLab, gridBagConstraints);
        this.textPane.setEditable(false);
        this.textPane.setContentType("text/rtf");
        this.infoSP.setViewportView(this.textPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 250;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.getContentPane().add((Component)this.infoSP, gridBagConstraints);
        this.jLabel1.setText(this.rbundle.getString("Load_and_install_new_version"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.closeButton.setText(this.rbundle.getString("Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateDialog.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.getContentPane().add((Component)this.closeButton, gridBagConstraints);
        this.goButton.setText(this.rbundle.getString("Website_and_quit"));
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateDialog.this.goButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 10, 12, 15);
        this.getContentPane().add((Component)this.goButton, gridBagConstraints);
        this.askCB.setText(this.rbundle.getString("askAutoCheck"));
        this.askCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateDialog.this.askCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 12, 0);
        this.getContentPane().add((Component)this.askCB, gridBagConstraints);
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        this.state = 2;
        this.setVisible(false);
    }

    private void askCBActionPerformed(ActionEvent evt) {
        Statics.prefsDialog.checkUpdate = this.askCB.isSelected();
    }

    public void checkUpdate(Boolean verbose) {
        DefaultStyledDocument styledDocument = new DefaultStyledDocument(new StyleContext());
        try {
            String text = Statics.prgVersion.replace('b', '\u00df');
            String subsubnumber_str = "0";
            if (text.lastIndexOf(".") != text.indexOf(".")) {
                subsubnumber_str = text.substring(text.lastIndexOf(".") + 1, text.length());
                text = text.substring(0, text.lastIndexOf("."));
            }
            if (text.contains("\u00df")) {
                text = text.substring(0, text.indexOf(223));
            }
            double thisMainNumber = Double.parseDouble(text);
            if (subsubnumber_str.contains("\u00df")) {
                subsubnumber_str = subsubnumber_str.substring(0, subsubnumber_str.indexOf(223));
            }
            int thisSubSubNumber = Integer.parseInt(subsubnumber_str);
            URL url = new URL(Statics.prg_Bundle.getString("Version_history_link"));
            InputStream in = url.openStream();
            RTF_KIT.read(in, (javax.swing.text.Document)styledDocument, 0);
            text = styledDocument.getText(0, styledDocument.getLength());
            int index = text.indexOf("Version ") + 8;
            String readVersion = text.substring(index, text.indexOf(" vom", index)).trim();
            subsubnumber_str = "0";
            if (readVersion.lastIndexOf(".") != readVersion.indexOf(".")) {
                subsubnumber_str = readVersion.substring(readVersion.lastIndexOf(".") + 1, readVersion.length());
            }
            double readMainNumber = Double.parseDouble(readVersion.substring(0, readVersion.lastIndexOf(".")));
            int readSubSubNumber = Integer.parseInt(subsubnumber_str);
            Boolean newerVersionAvailable = false;
            if (thisMainNumber < readMainNumber) {
                newerVersionAvailable = true;
            }
            if (thisMainNumber == readMainNumber && thisSubSubNumber < readSubSubNumber) {
                newerVersionAvailable = true;
            }
            if (newerVersionAvailable.booleanValue()) {
                this.headerLabel.setText(this.headerLabel.getText().replace("{1}", Statics.prgName));
                this.explanationLabel.setText(this.explanationLabel.getText().replace("{1}", Statics.prgName));
                this.explanationLabel.setText(this.explanationLabel.getText().replace("{2}", readVersion));
                this.explanationLabel.setText(this.explanationLabel.getText().replace("{3}", Statics.prgVersion));
                styledDocument.replace(0, text.indexOf("Version "), "", null);
                text = styledDocument.getText(0, styledDocument.getLength());
                index = text.indexOf("Version " + Statics.prgVersion);
                if (index >= 0) {
                    styledDocument.replace(index - 1, styledDocument.getLength() - index + 1, "", null);
                }
                this.textPane.setDocument(styledDocument);
                this.askCB.setSelected(Statics.prefsDialog.checkUpdate);
                Dimension sdim = Toolkit.getDefaultToolkit().getScreenSize();
                Point p = new Point(sdim.width / 2 - this.getWidth() / 2, (int)((double)sdim.height * 0.2));
                this.setLocation(p);
                this.setVisible(true);
                if (this.state == 2) {
                    Desktop.getDesktop().browse(new URI(Statics.prg_Bundle.getString("Download_link")));
                    Statics.quit();
                }
            } else if (verbose.booleanValue()) {
                new AutoDialog((JFrame)null).display(this.rbundle.getString("You_are_up_to_date").replace("#", Statics.prgName), this.rbundle.getString("no_newer_version_available").replace("#", Statics.prgVersion));
            }
        }
        catch (Exception ex) {
            if (verbose.booleanValue()) {
                new AutoDialog((JFrame)null).display(this.rbundle.getString("Error_while_checking_for_update"), this.rbundle.getString("Please_check_internet_connection"));
            }
            ex.printStackTrace();
        }
    }
}

