/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.Writer;
import org.freehep.util.io.FinishableOutputStream;
import org.freehep.util.io.IndentPrintWriter;

public class JavaArrayWriter
extends IndentPrintWriter
implements FinishableOutputStream {
    private static final int MAX_ENTRIES_PER_LINE = 8;
    private String author;
    private String arrayName;
    private int entries;
    private boolean start;
    private boolean end;

    public JavaArrayWriter(Writer out, String arrayName, String author) {
        super(out);
        this.arrayName = arrayName;
        this.author = author;
        this.entries = 8;
        this.start = true;
        this.end = false;
    }

    @Override
    public void write(int b) {
        this.start();
        String s = Integer.toHexString(b & 0xFF);
        switch (s.length()) {
            case 1: {
                this.writeEntry(("0" + s).substring(0, 2));
                break;
            }
            case 2: {
                this.writeEntry(s);
                break;
            }
            default: {
                System.err.println("ERROR " + this.getClass() + ": byte '" + b + "' was encoded in less than 1 or more than 2 chars");
            }
        }
    }

    private void start() {
        if (this.start) {
            this.start = false;
            super.indent();
            super.println("// START: Generated Code by " + this.author);
            super.println("private final byte[] " + this.arrayName + " = new byte[] {");
            super.indent();
        }
    }

    @Override
    public void finish() {
        if (!this.end) {
            this.end = true;
            super.println();
            super.outdent();
            super.println("}; // " + this.arrayName);
            super.println("// END: Generated Code by " + this.author);
            super.outdent();
            this.flush();
            if (this.out instanceof FinishableOutputStream) {
                try {
                    ((FinishableOutputStream)((Object)this.out)).finish();
                }
                catch (IOException e) {
                    System.err.println("ERROR " + this.getClass() + ": " + e);
                }
            }
        }
    }

    @Override
    public void close() {
        this.finish();
        super.close();
    }

    private void writeEntry(String s) {
        if (this.entries == 0) {
            this.entries = 8;
            super.println();
        }
        --this.entries;
        super.print("(byte)0x");
        super.print(s);
        super.print(", ");
    }
}

