/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ButtonLeiste
extends JPanel {
    double mu = 4.0;
    int maxIterationen = 25;
    int wieZeichnen = 1;
    protected int whatToDo = 1;
    private LogGl Main;
    boolean textFieldInput = false;
    private ButtonGroup buttonGroup1;
    protected JTextField maxItField;
    private JLabel maxItLabel;
    protected JTextField muField;
    private JLabel muLabel;
    protected JSlider muSlider;
    protected JButton neuButton;
    private JRadioButton schnellButton;
    private JRadioButton schrittButton;
    private JLabel sep1;
    private JLabel sep3;
    private JLabel sep4;
    private JLabel aktionenLabel;
    protected JButton parameterButton;
    protected JButton calculateButton;
    protected JRadioButton setMuButton;
    protected JRadioButton zoomInButton;
    protected JRadioButton zoomOutButton;
    protected JRadioButton moveButton;

    public ButtonLeiste(LogGl m) {
        this.Main = m;
        this.buttonGroup1 = new ButtonGroup();
        this.muLabel = new JLabel();
        this.muSlider = new JSlider();
        this.muField = new JTextField();
        this.sep1 = new JLabel();
        this.maxItLabel = new JLabel();
        this.maxItField = new JTextField();
        this.sep3 = new JLabel();
        this.schrittButton = new JRadioButton();
        this.schnellButton = new JRadioButton();
        this.sep4 = new JLabel();
        this.neuButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.muLabel.setText("\u00b5=");
        this.add((Component)this.muLabel, new GridBagConstraints());
        this.muSlider.setMajorTickSpacing(100);
        this.muSlider.setMaximum(400);
        this.muSlider.setMinorTickSpacing(20);
        this.muSlider.setPaintTicks(true);
        this.muSlider.setToolTipText("Einstellen der Werte f\u00fcr \u00b5 im Bereich von 0 bis 4.");
        this.muSlider.setValue(400);
        this.muSlider.setMaximumSize(new Dimension(200, 30));
        this.muSlider.setMinimumSize(new Dimension(80, 30));
        this.muSlider.setPreferredSize(new Dimension(150, 30));
        this.muSlider.setValueIsAdjusting(true);
        this.muSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ButtonLeiste.this.sliderStateChangedHandler(evt);
            }
        });
        this.muField.setText("4");
        this.muField.setToolTipText("Numerische Eingabe des Wertes f\u00fcr \u00b5.");
        this.muField.setMinimumSize(new Dimension(30, 20));
        this.muField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ButtonLeiste.this.muFieldActionPerformed(evt);
            }
        });
        this.muField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ButtonLeiste.this.muFieldFocusLost(evt);
            }
        });
        this.sep1.setMinimumSize(new Dimension(5, 5));
        this.sep1.setPreferredSize(new Dimension(40, 20));
        this.maxItLabel.setText("Iterationen: ");
        this.maxItField.setText("25");
        this.maxItField.setToolTipText("Eingabe der Anzahl der gezeigten Iterationsschritte (\u00dcbernahme durch <ENTER>).");
        this.maxItField.setMinimumSize(new Dimension(25, 20));
        this.maxItField.setPreferredSize(new Dimension(30, 20));
        this.maxItField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ButtonLeiste.this.maxItFieldActionPerformed(evt);
            }
        });
        this.maxItField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ButtonLeiste.this.maxItFieldFocusLost(evt);
            }
        });
        this.sep3.setMinimumSize(new Dimension(10, 5));
        this.sep3.setPreferredSize(new Dimension(40, 5));
        this.schrittButton.setSelected(true);
        this.schrittButton.setText("Einzelschritte");
        this.schrittButton.setToolTipText("Schrittweise Ausf\u00fchrung der Iterationen (Tasten: SPACE-n\u00e4chster Schritt; RETURN-abschlie\u00dfen).");
        this.buttonGroup1.add(this.schrittButton);
        this.schrittButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ButtonLeiste.this.schrittButtonActionPerformed(evt);
            }
        });
        this.schnellButton.setText("Alle Iterationen");
        this.schnellButton.setToolTipText("Unmittelbare Ausf\u00fchrung aller Iterationen.");
        this.buttonGroup1.add(this.schnellButton);
        this.schnellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ButtonLeiste.this.schnellButtonActionPerformed(evt);
            }
        });
        this.sep4.setMinimumSize(new Dimension(10, 5));
        this.sep4.setPreferredSize(new Dimension(40, 49));
        this.neuButton.setText("Startwerte l\u00f6schen");
        this.neuButton.setToolTipText("Erzeugen eines leeren Koordinatensystems.");
        this.neuButton.setPreferredSize(null);
        this.parameterButton = new JButton("Einstellungen");
        this.parameterButton.setToolTipText("Es erscheint ein Dialog zur Eingabe der Bereichswerte und der Iterationstiefe.");
        this.calculateButton = new JButton("neu rechnen");
        this.calculateButton.setToolTipText("Berechnet den Feigenbaum neu (z.B. nach Gr\u00f6\u00dfen\u00e4nderung des Fensters).");
        this.aktionenLabel = new JLabel("Aktionen:  ");
        this.setMuButton = new JRadioButton("\u00b5 setzen", true);
        this.setMuButton.setToolTipText("Es kann durch Klick auf der horizontalen Achse oder verschieben der Parameter \u00b5 f\u00fcr die Iterations- bzw. Zeitseriendarstellung eingestellt werden.");
        this.zoomInButton = new JRadioButton("vergr\u00f6\u00dfern", true);
        this.zoomInButton.setToolTipText("Es kann per Maus ein Ausschnitt ausgew\u00e4hlt werden, der dann vergr\u00f6\u00dfert wird.");
        this.zoomOutButton = new JRadioButton("verkleinern");
        this.zoomOutButton.setToolTipText("Der Anzeigebereich wird verkleinert, so dass der aktuelle Bereich in dem gew\u00e4hlten Ausschnitt dargestellt wird.");
        this.moveButton = new JRadioButton("verschieben");
        this.moveButton.setToolTipText("Ziehen Sie mit der Maus eine Verschiebungslinie f\u00fcr den Bildausschnitt.");
        ButtonGroup actionGroup = new ButtonGroup();
        actionGroup.add(this.setMuButton);
        actionGroup.add(this.zoomInButton);
        actionGroup.add(this.zoomOutButton);
        actionGroup.add(this.moveButton);
        RadioListener radioListener = new RadioListener();
        this.setMuButton.addActionListener(radioListener);
        this.zoomInButton.addActionListener(radioListener);
        this.zoomOutButton.addActionListener(radioListener);
        this.moveButton.addActionListener(radioListener);
        this.muSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ButtonLeiste.this.muSliderStateChangedHandler(evt);
            }
        });
        this.maxItField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ButtonLeiste.this.maxItFieldActionPerformed(evt);
            }
        });
        this.neuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonLeiste.this.neuButton_actionPerformed(e);
            }
        });
        this.parameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonLeiste.this.parameterButton_actionPerformed(e);
            }
        });
        this.calculateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonLeiste.this.calculateButton_actionPerformed(e);
            }
        });
        this.addZsItComponents();
    }

    void addZsItComponents() {
        this.muField.setPreferredSize(new Dimension(50, 20));
        this.removeAll();
        this.add((Component)this.muLabel, new GridBagConstraints());
        this.add((Component)this.muSlider, new GridBagConstraints());
        this.add((Component)this.muField, new GridBagConstraints());
        this.add((Component)this.sep1, new GridBagConstraints());
        this.add((Component)this.maxItLabel, new GridBagConstraints());
        this.add((Component)this.maxItField, new GridBagConstraints());
        this.add((Component)this.sep3, new GridBagConstraints());
        this.add((Component)this.schrittButton, new GridBagConstraints());
        this.add((Component)this.schnellButton, new GridBagConstraints());
        this.add((Component)this.sep4, new GridBagConstraints());
        this.add((Component)this.neuButton, new GridBagConstraints());
    }

    void addFBComponents() {
        this.muField.setPreferredSize(new Dimension(90, 20));
        this.removeAll();
        this.add((Component)this.muLabel, null);
        this.add((Component)this.muField, null);
        this.add((Component)this.sep3, null);
        this.add((Component)this.parameterButton, null);
        this.add((Component)this.calculateButton, null);
        this.add((Component)this.sep4, null);
        this.add((Component)this.aktionenLabel, null);
        this.add((Component)this.setMuButton, null);
        this.add((Component)this.zoomInButton, null);
        this.add((Component)this.zoomOutButton, null);
        this.add((Component)this.moveButton, null);
    }

    private void maxItFieldFocusLost(FocusEvent evt) {
        this.readTextFields();
    }

    private void muFieldFocusLost(FocusEvent evt) {
        this.readTextFields();
        this.textFieldInput = true;
        this.muSlider.setValue((int)(this.mu * 100.0));
    }

    private void muFieldActionPerformed(ActionEvent evt) {
        this.readTextFields();
        this.textFieldInput = true;
        this.muSlider.setValue((int)(this.mu * 100.0));
    }

    private void schrittButtonActionPerformed(ActionEvent evt) {
        this.wieZeichnen = 1;
    }

    private void schnellButtonActionPerformed(ActionEvent evt) {
        this.wieZeichnen = 2;
    }

    private void sliderStateChangedHandler(ChangeEvent evt) {
        this.mu = (double)this.muSlider.getValue() / 100.0;
        if (!this.textFieldInput) {
            this.muField.setText(NumberFormat.getInstance().format(this.mu));
        } else {
            this.textFieldInput = false;
        }
    }

    void readTextFields() {
        AutoDialog dialog = new AutoDialog();
        try {
            double muhelp = NumberFormat.getInstance().parse(this.muField.getText()).doubleValue();
            if (muhelp < 0.0 || muhelp > 4.0) {
                dialog.display("Fehler beim Einlesen von \u00b5.", "\u00b5 muss zwischen 0 und 4 liegen!");
                this.muField.setText(NumberFormat.getInstance().format(this.mu));
            } else {
                this.mu = muhelp;
            }
            int it = NumberFormat.getInstance().parse(this.maxItField.getText()).intValue();
            if (it < 5) {
                dialog.display("Fehler beim Einlesen der Iterationszahl.", "Die Zahl der Iterationen darf nicht kleiner als 5 sein!");
                this.maxItField.setText(NumberFormat.getInstance().format(this.maxIterationen));
            } else {
                this.maxIterationen = it;
            }
        }
        catch (ParseException e) {
            dialog.display("Fehler bein Einlesen der Werte.", "Bitte kontrollieren Sie Ihre Eingaben!");
        }
    }

    private void muSliderStateChangedHandler(ChangeEvent evt) {
        this.Main.mu = (double)this.muSlider.getValue() / 100.0;
        this.Main.grafikPane.repaint();
    }

    private void maxItFieldActionPerformed(ActionEvent evt) {
        this.readTextFields();
        this.Main.maxIterationen = this.maxIterationen;
        this.Main.grafikPane.repaint();
    }

    public void neuButton_actionPerformed(ActionEvent e) {
        this.Main.mu = this.mu;
        this.Main.maxIterationen = this.maxIterationen;
        this.Main.startwerteAnzahl = 0;
        this.Main.schrittZaehler = 0;
        this.Main.grafikPane.repaint();
    }

    public void parameterButton_actionPerformed(ActionEvent e) {
        this.Main.feigenbaum.Eingabe();
        this.Main.feigenbaum.CalcFakVersch();
    }

    public void calculateButton_actionPerformed(ActionEvent e) {
        if (this.Main.whatDisplayed == 4) {
            this.Main.feigenbaum.berechne();
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String buttName = e.getActionCommand();
            if (buttName == "\u00b5 setzen") {
                ButtonLeiste.this.whatToDo = 1;
                ((ButtonLeiste)ButtonLeiste.this).Main.feigenbaum.setCursor(new Cursor(12));
            }
            if (buttName == "vergr\u00f6\u00dfern") {
                ButtonLeiste.this.whatToDo = 2;
                ((ButtonLeiste)ButtonLeiste.this).Main.feigenbaum.setCursor(new Cursor(1));
            }
            if (buttName == "verkleinern") {
                ButtonLeiste.this.whatToDo = 3;
                ((ButtonLeiste)ButtonLeiste.this).Main.feigenbaum.setCursor(new Cursor(1));
            }
            if (buttName == "verschieben") {
                ButtonLeiste.this.whatToDo = 4;
                ((ButtonLeiste)ButtonLeiste.this).Main.feigenbaum.setCursor(new Cursor(1));
            }
        }
    }
}

