/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

class Zeitserie
extends JPanel {
    protected int untereGrenze;
    protected int i;
    protected int it;
    protected double wert;
    protected double XVersch;
    protected double YVersch;
    protected double XFaktor;
    protected double YFaktor;
    protected Point point1;
    protected Point point2;
    protected double[] vect1;
    protected double[] vect2;
    protected String str;
    protected LogGl Main;
    protected int farbIndex;
    protected int maxFarbIndex = 6;
    protected Color[] Farbe = new Color[]{Color.black, Color.red, Color.blue, Color.green, Color.cyan, Color.magenta};

    public Zeitserie(LogGl m) {
        this.Main = m;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Zeitserie.this.mouseClickedHandler(e);
            }
        });
        this.setToolTipText("Zur Eingabe der Startwerte klicken Sie auf die Hochwertachse (Shift-Klick f\u00fcr numerische Eingabe).");
    }

    protected void CalcFakVersch(JPanel gp) {
        this.XFaktor = (double)this.Main.maxIterationen / (double)(gp.getWidth() - 40);
        this.YFaktor = -1.0 / (double)(gp.getHeight() - 30);
        this.XVersch = -(28.0 * this.XFaktor);
        this.YVersch = 1.0 - 10.0 * this.YFaktor;
    }

    protected Point XyToScreen(double x, double y) {
        Point point = new Point();
        point.x = (int)((x - this.XVersch) / this.XFaktor);
        point.y = (int)((y - this.YVersch) / this.YFaktor);
        return point;
    }

    protected double[] ScreenToXy(int xscreen, int yscreen) {
        double[] v = new double[]{(double)xscreen * this.XFaktor + this.XVersch, (double)yscreen * this.YFaktor + this.YVersch};
        return v;
    }

    public double LogGleichung(double xstart, double par, int it) {
        double fn = xstart;
        for (int i = 0; i < it; ++i) {
            fn = par * fn * (1.0 - fn);
        }
        return fn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseClickedHandler(MouseEvent e) {
        if (this.Main.schrittZaehler > 0) {
            return;
        }
        this.point1 = this.XyToScreen(0.0, 0.0);
        if (Math.abs(e.getX() - this.point1.x) > 20) {
            return;
        }
        if (e.isShiftDown()) {
            this.vect1 = this.ScreenToXy(e.getX(), e.getY());
            StartwertEingabe eingabe = new StartwertEingabe((Frame)((JFrame)this.getTopLevelAncestor()), true, this.vect1[1]);
            this.getLocation(this.point1);
            eingabe.setLocation(e.getX() + this.point1.x, e.getY());
            eingabe.showEingabe();
            if (eingabe.canceled) return;
            this.Main.startwerte[this.Main.startwerteAnzahl] = eingabe.wert;
            ++this.Main.startwerteAnzahl;
        } else {
            this.vect1 = this.ScreenToXy(0, e.getY());
            if (this.vect1[1] < 0.0) {
                this.vect1[1] = 0.0;
            }
            if (this.vect1[1] > 1.0) {
                this.vect1[1] = 1.0;
            }
            this.Main.startwerte[this.Main.startwerteAnzahl] = this.vect1[1];
            ++this.Main.startwerteAnzahl;
        }
        switch (this.Main.buttonLeiste.wieZeichnen) {
            case 2: {
                this.repaint();
                this.Main.iteration.repaint();
                return;
            }
            case 1: {
                this.Main.schrittZaehler = 1;
                this.zeichneTrajektorie(this.Main.startwerte[this.Main.startwerteAnzahl - 1], 1);
                try {
                    this.Main.iteration.zeichneTrajektorie(this.Main.startwerte[this.Main.startwerteAnzahl - 1], 1);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        this.CalcFakVersch(this);
        this.untereGrenze = this.getHeight() - 20;
        this.point1 = this.XyToScreen(this.Main.maxIterationen, 0.0);
        this.point2 = this.XyToScreen(0.0, 0.0);
        g.drawLine(this.point1.x + 5, this.untereGrenze, this.point2.x, this.untereGrenze);
        this.point1 = this.XyToScreen(0.0, 1.0);
        g.drawLine(this.point2.x, this.untereGrenze, this.point1.x, this.point1.y - 5);
        this.it = 0;
        while (this.it <= this.Main.maxIterationen) {
            this.str = NumberFormat.getInstance().format(this.it);
            this.point1 = this.XyToScreen(this.it, 0.0);
            this.point1.y = this.untereGrenze;
            g.drawString(this.str, this.point1.x - 9, this.point1.y + 16);
            g.drawLine(this.point1.x, this.point1.y - 3, this.point1.x, this.point1.y + 6);
            this.it = (int)((double)this.it + (double)this.Main.maxIterationen / 5.0);
        }
        this.wert = 0.0;
        while (this.wert <= 1.0) {
            this.str = NumberFormat.getInstance().format(this.wert);
            this.point1 = this.XyToScreen(0.0, this.wert);
            g.drawString(this.str, this.point1.x - 25, this.point1.y + 5);
            g.drawLine(this.point1.x - 3, this.point1.y, this.point1.x + 6, this.point1.y);
            this.wert += 0.2;
        }
        this.farbIndex = 0;
        this.i = 0;
        while (this.i < this.Main.startwerteAnzahl) {
            this.wert = this.Main.startwerte[this.i];
            this.point1 = this.XyToScreen(0.0, this.wert);
            ++this.farbIndex;
            if (this.farbIndex >= this.maxFarbIndex) {
                this.farbIndex = 0;
            }
            g.setColor(this.Farbe[this.farbIndex]);
            g.fillOval(this.point1.x - 4, this.point1.y - 4, 8, 8);
            this.it = 1;
            while (this.it <= this.Main.maxIterationen) {
                if (this.Main.schrittZaehler > 0 && this.i >= this.Main.startwerteAnzahl - 1 && this.it >= this.Main.schrittZaehler) {
                    return;
                }
                this.wert = this.LogGleichung(this.wert, this.Main.mu, 1);
                this.point2 = this.XyToScreen(this.it, this.wert);
                g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
                g.fillOval(this.point2.x - 4, this.point2.y - 4, 8, 8);
                this.point1.x = this.point2.x;
                this.point1.y = this.point2.y;
                ++this.it;
            }
            ++this.i;
        }
    }

    public void zeichneTrajektorie(double wert, int modus) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        this.point1 = this.XyToScreen(0.0, wert);
        if (this.Main.schrittZaehler <= 1) {
            ++this.farbIndex;
        }
        if (this.farbIndex >= this.maxFarbIndex) {
            this.farbIndex = 0;
        }
        g.setColor(this.Farbe[this.farbIndex]);
        g.fillOval(this.point1.x - 4, this.point1.y - 4, 8, 8);
        this.it = 1;
        while (this.it <= this.Main.maxIterationen) {
            if (modus == 1 && this.it >= this.Main.schrittZaehler) {
                return;
            }
            wert = this.LogGleichung(wert, this.Main.mu, 1);
            this.point2 = this.XyToScreen(this.it, wert);
            g.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
            g.fillOval(this.point2.x - 4, this.point2.y - 4, 8, 8);
            this.point1.x = this.point2.x;
            this.point1.y = this.point2.y;
            ++this.it;
        }
    }
}

