/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.NumberFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

class Feigenbaum
extends JPanel {
    protected int Iterationen;
    protected int Transienten;
    protected int x1;
    protected int x2;
    protected int y1;
    protected int y2;
    protected boolean muLineClicked = false;
    protected double MuAnf;
    protected double MuEnd;
    protected double YMinFeig;
    protected double YMaxFeig;
    protected double XVersch;
    protected double YVersch;
    protected double XFaktor;
    protected double YFaktor;
    protected LogGl Main;
    protected CalcFeigenbaum calcFeigenbaum;
    private NumberFormat nf = NumberFormat.getInstance();

    public Feigenbaum(LogGl m) {
        this.Main = m;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Feigenbaum.this.CalcFakVersch();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Feigenbaum.this.mouseDraggedHandler(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Feigenbaum.this.mouseClickedHandler(e);
            }

            public void mousePressed(MouseEvent e) {
                Feigenbaum.this.mousePressedHandler(e);
            }

            public void mouseReleased(MouseEvent e) {
                Feigenbaum.this.mouseReleasedHandler(e);
            }
        });
        this.initialisiere();
    }

    public void initialisiere() {
        this.MuAnf = 2.5;
        this.MuEnd = 4.0;
        this.YMinFeig = 0.0;
        this.YMaxFeig = 1.0;
        this.Iterationen = 200;
        this.Transienten = 50;
        this.nf.setMaximumFractionDigits(8);
        this.setCursor(new Cursor(12));
    }

    public void berechne() {
        this.calcFeigenbaum = new CalcFeigenbaum(this.Main);
        this.calcFeigenbaum.MuAnf = this.MuAnf;
        this.calcFeigenbaum.MuEnd = this.MuEnd;
        this.calcFeigenbaum.YMinFeig = this.YMinFeig;
        this.calcFeigenbaum.YMaxFeig = this.YMaxFeig;
        this.calcFeigenbaum.Iterationen = this.Iterationen;
        this.calcFeigenbaum.Transienten = this.Transienten;
        this.calcFeigenbaum.breite = this.getWidth();
        this.calcFeigenbaum.hoehe = this.getHeight();
        Thread t1 = new Thread(this.calcFeigenbaum);
        t1.start();
    }

    protected void CalcFakVersch() {
        this.XFaktor = (this.MuEnd - this.MuAnf) / (double)(this.getWidth() - 40);
        this.YFaktor = -(this.YMaxFeig - this.YMinFeig) / (double)(this.getHeight() - 30);
        this.XVersch = this.MuAnf - 28.0 * this.XFaktor;
        this.YVersch = this.YMaxFeig - 10.0 * this.YFaktor;
    }

    protected double[] ScreenToXy(int xscreen, int yscreen) {
        double[] v = new double[]{(double)xscreen * this.XFaktor + this.XVersch, (double)yscreen * this.YFaktor + this.YVersch};
        return v;
    }

    protected Point XyToScreen(double x, double y) {
        Point point = new Point();
        point.x = (int)((x - this.XVersch) / this.XFaktor);
        point.y = (int)((y - this.YVersch) / this.YFaktor);
        return point;
    }

    void Eingabe() {
        FBParameterEingabe parameterEingabe = new FBParameterEingabe((Frame)((JFrame)this.getTopLevelAncestor()), true);
        parameterEingabe.MuAnf = this.MuAnf;
        parameterEingabe.MuEnd = this.MuEnd;
        parameterEingabe.YMinFeig = this.YMinFeig;
        parameterEingabe.YMaxFeig = this.YMaxFeig;
        parameterEingabe.Iterationen = this.Iterationen;
        parameterEingabe.Transienten = this.Transienten;
        parameterEingabe.showEingabe();
        if (parameterEingabe.ok) {
            this.MuAnf = parameterEingabe.MuAnf;
            this.MuEnd = parameterEingabe.MuEnd;
            this.YMinFeig = parameterEingabe.YMinFeig;
            this.YMaxFeig = parameterEingabe.YMaxFeig;
            this.Iterationen = parameterEingabe.Iterationen;
            this.Transienten = parameterEingabe.Transienten;
            this.berechne();
        }
    }

    public void mouseDraggedHandler(MouseEvent e) {
        if (this.x1 < 0) {
            return;
        }
        Graphics gra = this.getGraphics();
        gra.setXORMode(Color.white);
        if (e.getX() != this.x2 && e.getY() != this.y2) {
            switch (this.Main.buttonLeiste.whatToDo) {
                case 1: {
                    if (!this.muLineClicked) break;
                    gra.setXORMode(Color.green);
                    gra.drawLine(this.x2, 0, this.x2, this.getHeight());
                    this.x2 = e.getX();
                    this.y2 = e.getY();
                    gra.drawLine(this.x2, 0, this.x2, this.getHeight());
                    double[] vect2 = this.ScreenToXy(this.x2, this.y2);
                    this.Main.buttonLeiste.muField.setText(this.nf.format(vect2[0]));
                    break;
                }
                case 2: 
                case 3: {
                    if (this.x2 >= 0) {
                        gra.drawRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                    }
                    this.x2 = e.getX();
                    this.y2 = e.getY();
                    gra.drawRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                    double[] vect1 = this.ScreenToXy(this.x1, this.y1);
                    double[] vect2 = this.ScreenToXy(this.x2, this.y2);
                    break;
                }
                case 4: {
                    if (this.x2 >= 0) {
                        gra.drawLine(this.x1, this.y1, this.x2, this.y2);
                    }
                    this.x2 = e.getX();
                    this.y2 = e.getY();
                    gra.drawLine(this.x1, this.y1, this.x2, this.y2);
                }
            }
        }
    }

    public void mouseClickedHandler(MouseEvent e) {
        if (this.Main.buttonLeiste.whatToDo == 1) {
            if (e.getY() < this.getHeight() - 50) {
                return;
            }
            double[] vect = this.ScreenToXy(e.getX(), e.getY());
            this.Main.mu = vect[0];
            this.Main.buttonLeiste.muField.setText(this.nf.format(this.Main.mu));
            this.repaint();
        }
    }

    public void mousePressedHandler(MouseEvent e) {
        Graphics gra = this.getGraphics();
        this.x1 = e.getX();
        this.y1 = e.getY();
        this.x2 = -1;
        this.y2 = -1;
        if (this.Main.buttonLeiste.whatToDo == 1) {
            Point point = this.XyToScreen(this.Main.mu, 0.0);
            this.muLineClicked = true;
            gra.setXORMode(Color.green);
            gra.drawLine(this.x1, 0, this.x1, this.getHeight());
            this.x2 = this.x1;
        }
    }

    public void mouseReleasedHandler(MouseEvent e) {
        if (this.x1 < 0) {
            return;
        }
        Graphics gra = this.getGraphics();
        gra.setXORMode(Color.white);
        this.x2 = e.getX();
        this.y2 = e.getY();
        double[] vect1 = this.ScreenToXy(this.x1, this.y1);
        double[] vect2 = this.ScreenToXy(this.x2, this.y2);
        if (Math.abs(this.x1 - this.x2) < 1 && Math.abs(this.y1 - this.y2) < 1) {
            if (this.muLineClicked) {
                this.Main.mu = vect2[0];
                this.Main.buttonLeiste.muField.setText(this.nf.format(this.Main.mu));
                this.repaint();
            }
            return;
        }
        switch (this.Main.buttonLeiste.whatToDo) {
            case 1: {
                if (!this.muLineClicked) break;
                this.Main.mu = vect2[0];
                this.muLineClicked = false;
                this.repaint();
                this.Main.buttonLeiste.muField.setText(this.nf.format(this.Main.mu));
                break;
            }
            case 2: {
                if (vect1[0] < vect2[0]) {
                    this.MuAnf = vect1[0];
                    this.MuEnd = vect2[0];
                } else {
                    this.MuAnf = vect2[0];
                    this.MuEnd = vect1[0];
                }
                if (vect1[1] < vect2[1]) {
                    this.YMinFeig = vect1[1];
                    this.YMaxFeig = vect2[1];
                } else {
                    this.YMinFeig = vect2[1];
                    this.YMaxFeig = vect1[1];
                }
                this.CalcFakVersch();
                this.berechne();
                break;
            }
            case 3: {
                double help;
                if (vect1[0] > vect2[0]) {
                    help = vect1[0];
                    vect1[0] = vect2[0];
                    vect2[0] = help;
                }
                if (vect1[1] > vect2[1]) {
                    help = vect1[1];
                    vect1[1] = vect2[1];
                    vect2[1] = help;
                }
                double fakt = (this.MuEnd - this.MuAnf) / (vect2[0] - vect1[0]);
                help = this.MuEnd - this.MuAnf;
                this.MuAnf -= fakt * (vect1[0] - this.MuAnf);
                this.MuEnd = this.MuAnf + fakt * help;
                fakt = (this.YMaxFeig - this.YMinFeig) / (vect2[1] - vect1[1]);
                help = this.YMaxFeig - this.YMinFeig;
                this.YMinFeig -= fakt * (vect1[1] - this.YMinFeig);
                this.YMaxFeig = this.YMinFeig + fakt * help;
                this.CalcFakVersch();
                this.berechne();
                break;
            }
            case 4: {
                this.MuAnf -= vect2[0] - vect1[0];
                this.MuEnd -= vect2[0] - vect1[0];
                this.YMinFeig -= vect2[1] - vect1[1];
                this.YMaxFeig -= vect2[1] - vect1[1];
                this.CalcFakVersch();
                this.berechne();
            }
        }
    }

    public void paint(Graphics g) {
        if (this.calcFeigenbaum != null && this.calcFeigenbaum.bild != null) {
            g.drawImage(this.calcFeigenbaum.bild, 0, 0, this.getWidth(), this.getHeight(), this);
            Point point = this.XyToScreen(this.Main.mu, 0.0);
            g.setColor(Color.red);
            g.drawLine(point.x, 0, point.x, this.getHeight());
        }
    }
}

