/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StartwertEingabe
extends JDialog {
    protected double wert;
    protected boolean canceled;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JLabel sep;
    private JTextField wertField;
    private JLabel wertLabel;
    private JPanel wertPanel;

    public StartwertEingabe(Frame parent, boolean modal, double w) {
        super(parent, modal);
        this.initComponents();
        this.setSize(250, 115);
        this.setLocation(50, 50);
        this.getRootPane().setDefaultButton(this.okButton);
        this.wert = w;
    }

    private void initComponents() {
        this.wertPanel = new JPanel();
        this.wertLabel = new JLabel();
        this.wertField = new JTextField();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.sep = new JLabel();
        this.okButton = new JButton();
        this.getContentPane().setLayout(new FlowLayout());
        this.setTitle("Numerische Eingabe");
        this.setModal(true);
        this.setName("StartwertEingabeDialog");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StartwertEingabe.this.closeDialog(evt);
            }
        });
        this.wertPanel.setLayout(new GridBagLayout());
        this.wertPanel.setAlignmentX(1.0f);
        this.wertPanel.setPreferredSize(new Dimension(220, 40));
        this.wertLabel.setText("Startwert  =  ");
        this.wertPanel.add((Component)this.wertLabel, new GridBagConstraints());
        this.wertField.setToolTipText("Der Startwert muss zwischen 0 und 1 liegen (z.B. 0,79)");
        this.wertField.setMaximumSize(new Dimension(64, 18));
        this.wertField.setPreferredSize(new Dimension(110, 18));
        this.wertField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartwertEingabe.this.wertFieldActionPerformed(evt);
            }
        });
        this.wertField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                StartwertEingabe.this.wertFieldKeyPressed(evt);
            }
        });
        this.wertPanel.add((Component)this.wertField, new GridBagConstraints());
        this.getContentPane().add(this.wertPanel);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setAlignmentX(1.0f);
        this.buttonPanel.setAlignmentY(0.0f);
        this.buttonPanel.setPreferredSize(new Dimension(200, 30));
        this.cancelButton.setText("Abbrechen");
        this.cancelButton.setAlignmentX(1.0f);
        this.cancelButton.setAlignmentY(0.0f);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartwertEingabe.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints());
        this.sep.setAlignmentY(0.0f);
        this.sep.setMinimumSize(new Dimension(10, 10));
        this.sep.setPreferredSize(new Dimension(25, 30));
        this.buttonPanel.add((Component)this.sep, new GridBagConstraints());
        this.okButton.setText(" OK ");
        this.okButton.setAlignmentX(1.0f);
        this.okButton.setAlignmentY(0.0f);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StartwertEingabe.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.okButton, new GridBagConstraints());
        this.getContentPane().add(this.buttonPanel);
        this.pack();
    }

    private void wertFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
        }
        if (evt.getKeyCode() == 10) {
            try {
                this.wert = NumberFormat.getInstance().parse(this.wertField.getText()).doubleValue();
                if (this.wert < 0.0 || this.wert > 1.0) {
                    new AutoDialog().display("Fehler bein Einlesen des Wertes.", "Der Wert muss zwischen 0 und 1 liegen!");
                    return;
                }
            }
            catch (ParseException e) {
                new AutoDialog().display("Fehler bein Einlesen des Wertes.", "Es sind nicht erlaubte Zeichen vorhanden!");
                return;
            }
            this.canceled = false;
            this.setVisible(false);
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            this.wert = NumberFormat.getInstance().parse(this.wertField.getText()).doubleValue();
        }
        catch (ParseException e) {
            AutoDialog dialog = new AutoDialog();
            dialog.display("Fehler bein Einlesen der Werte.", "Bitte kontrollieren Sie Ihre Eingaben!");
            dialog.dispose();
        }
        this.canceled = false;
        this.setVisible(false);
        this.dispose();
    }

    private void wertFieldActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    void showEingabe() {
        this.wertField.setText(NumberFormat.getInstance().format(this.wert));
        this.canceled = true;
        this.show();
    }
}

