/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class CalcBassins
implements Runnable {
    protected double XMin;
    protected double XMax;
    protected double YMin;
    protected double YMax;
    protected double ReibKoeff;
    protected double GravConst;
    protected double MagAbst;
    protected int MagAnz;
    protected double[] MagX = new double[3];
    protected double[] MagY = new double[3];
    protected double[] MagPar = new double[3];
    protected Color[] MagnetFarben = new Color[4];
    protected double Genauigkeit;
    protected double AnfangsSchrittweite;
    protected double MagEntf;
    public int breite;
    public int hoehe;
    protected BufferedImage bild = null;
    protected JPanel calcPane;
    public boolean stop = false;
    public boolean firsttime = true;
    public boolean stillrunning;
    public boolean saved = false;
    double[] PhaseVector = new double[5];
    double[] PhaseVectorNeu = new double[5];
    protected int xko = 0;
    protected int yko = 0;
    protected int ykoSave;
    protected int yko_start;
    protected int yko_end;
    protected int PixelStaerke;
    protected int PixelStaerkeAnfang = 16;
    protected double XVersch = 0.0;
    protected double YVersch = 0.0;
    protected double XFaktor = 0.0;
    protected double YFaktor = 0.0;
    final int SMAX = 16;
    final int DMAX = 7;
    final int NVARMAX = 4;
    long ngood;
    long nfail;
    int s;
    int ss;
    int q;
    int p;
    int d;
    boolean fsal;
    double[][] a = new double[16][15];
    double[] b = new double[16];
    double[] bdach = new double[16];
    double[] berr = new double[16];
    double[] c = new double[16];
    double[][] beta = new double[8][16];
    double potenz;
    double eps;
    double tend;
    int nvar;
    boolean autonom;
    boolean neu;
    double[][] k = new double[16][4];
    double h0;
    double tt;
    double[] ybeg = new double[4];
    double Schrittweite;
    double tlast = 1.0E13;
    double[] yneu = new double[5];
    double[] ytemp = new double[4];
    double[] ys = new double[4];
    double magpowx;
    double magpowy;
    double nenner;

    public CalcBassins(JPanel panel, int start, int end) {
        this.calcPane = panel;
        this.breite = this.calcPane.getWidth();
        this.hoehe = this.calcPane.getHeight();
        this.bild = new BufferedImage(this.breite, end - start + 1, 1);
        this.ykoSave = this.yko_start = start;
        this.yko_end = end;
        this.rkcoeff();
    }

    public void setValues(double xMin, double xMax, double yMin, double yMax, double reibKoeff, double gravConst, double magAbst, int magAnz, double[] magX, double[] magY, double[] magPar, Color[] magnetFarben, double genauigkeit, double anfangsSchrittweite, double magEntf) {
        int i;
        this.XMin = xMin;
        this.XMax = xMax;
        this.YMin = yMin;
        this.YMax = yMax;
        this.ReibKoeff = reibKoeff;
        this.GravConst = gravConst;
        this.MagAbst = magAbst;
        this.MagAnz = magAnz;
        for (i = 0; i < this.MagAnz; ++i) {
            this.MagX[i] = magX[i];
        }
        for (i = 0; i < this.MagAnz; ++i) {
            this.MagY[i] = magY[i];
        }
        for (i = 0; i < this.MagAnz; ++i) {
            this.MagPar[i] = magPar[i];
        }
        for (i = 0; i < this.MagAnz + 1; ++i) {
            this.MagnetFarben[i] = magnetFarben[i];
        }
        this.Genauigkeit = genauigkeit;
        this.AnfangsSchrittweite = anfangsSchrittweite;
        this.MagEntf = magEntf;
    }

    protected void CalcFakVersch() {
        this.XFaktor = (this.XMax - this.XMin) / (double)this.breite;
        this.YFaktor = -(this.YMax - this.YMin) / (double)this.hoehe;
        this.XVersch = this.XMin;
        this.YVersch = this.YMax;
    }

    protected Point XyToScreen(double x, double y) {
        Point point = new Point();
        point.x = (int)((x - this.XVersch) / this.XFaktor);
        point.y = (int)((y - this.YVersch) / this.YFaktor);
        return point;
    }

    int postest(double[] tsvec) {
        int j = 0;
        for (j = 0; j < this.MagAnz; ++j) {
            if (this.MagPar[j] == 0.0 || !(Math.abs(tsvec[0] - this.MagX[j]) < this.MagEntf) || !(Math.abs(tsvec[2] - this.MagY[j]) < this.MagEntf)) continue;
            return j + 1;
        }
        return 0;
    }

    int WhichMagnet(double xstart, double ystart) {
        int magnetNr;
        double t = 0.0;
        this.rkinit(true, 4, this.Genauigkeit, 200.0, this.AnfangsSchrittweite);
        this.PhaseVector[0] = xstart;
        this.PhaseVector[1] = 0.0;
        this.PhaseVector[2] = ystart;
        this.PhaseVector[3] = 0.0;
        double SattelWert = this.Potential(-0.5, 0.0);
        do {
            double DeltaE;
            double vquad;
            this.rkstep(t, this.PhaseVector);
            t = this.yneu[4];
            for (int i = 0; i < 4; ++i) {
                this.PhaseVector[i] = this.yneu[i];
            }
            magnetNr = this.postest(this.PhaseVector);
            if (magnetNr == 0 || !((vquad = this.PhaseVector[1] * this.PhaseVector[1] + this.PhaseVector[3] * this.PhaseVector[3]) < (DeltaE = 2.0 * Math.abs(this.Potential(this.PhaseVector[0], this.PhaseVector[2]) - SattelWert)))) continue;
            t = 200.0;
        } while (t < 200.0);
        return magnetNr;
    }

    @Override
    public void run() {
        double y;
        double x;
        this.CalcFakVersch();
        this.stillrunning = true;
        this.saved = false;
        this.stop = false;
        Graphics g = this.bild.getGraphics();
        if (this.firsttime) {
            this.XFaktor = (this.XMax - this.XMin) / (double)this.breite;
            this.YFaktor = -(this.YMax - this.YMin) / (double)this.hoehe;
            this.XVersch = this.XMin;
            this.YVersch = this.YMax;
            this.PixelStaerke = this.PixelStaerkeAnfang * 2;
            this.yko = this.yko_start;
            while (this.yko < this.yko_end) {
                this.xko = 0;
                while (this.xko < this.breite) {
                    x = (double)this.xko * this.XFaktor + this.XVersch;
                    y = (double)this.yko * this.YFaktor + this.YVersch;
                    g.setColor(this.MagnetFarben[this.WhichMagnet(x, y)]);
                    g.fillRect(this.xko, this.yko - this.yko_start, this.PixelStaerke, this.PixelStaerke);
                    this.xko += this.PixelStaerke;
                }
                this.yko += this.PixelStaerke;
            }
            this.firsttime = false;
            this.calcPane.repaint(0, this.yko_start - 1, this.calcPane.getWidth(), this.calcPane.getHeight());
        }
        this.PixelStaerke = this.PixelStaerkeAnfang;
        while (this.PixelStaerke >= 1 && !this.stop) {
            this.yko = this.ykoSave;
            this.ykoSave = this.yko_start;
            while (this.yko < this.yko_end && !this.stop) {
                this.xko = this.PixelStaerke;
                while (this.xko <= this.breite) {
                    x = (double)this.xko * this.XFaktor + this.XVersch;
                    y = (double)this.yko * this.YFaktor + this.YVersch;
                    g.setColor(this.MagnetFarben[this.WhichMagnet(x, y)]);
                    g.fillRect(this.xko, this.yko - this.yko_start, this.PixelStaerke, this.PixelStaerke);
                    this.xko += 2 * this.PixelStaerke;
                }
                this.yko += this.PixelStaerke;
                this.xko = 0;
                while (this.xko <= this.breite) {
                    x = (double)this.xko * this.XFaktor + this.XVersch;
                    y = (double)this.yko * this.YFaktor + this.YVersch;
                    g.setColor(this.MagnetFarben[this.WhichMagnet(x, y)]);
                    g.fillRect(this.xko, this.yko - this.yko_start, this.PixelStaerke, this.PixelStaerke);
                    this.xko += this.PixelStaerke;
                }
                this.calcPane.repaint(0, this.yko - this.PixelStaerke - 1, this.calcPane.getWidth(), 2 * this.PixelStaerke + 2);
                this.yko += this.PixelStaerke;
            }
            this.PixelStaerke /= 2;
        }
        this.stop = true;
        if (this.PixelStaerke >= 1) {
            this.PixelStaerkeAnfang = this.PixelStaerke * 2;
            this.ykoSave = this.yko;
        } else {
            this.PixelStaerkeAnfang = 0;
        }
        this.stillrunning = false;
        this.calcPane.repaint();
    }

    void error(String s) {
        System.out.println("ERROR : " + s);
    }

    double max(double x1, double x2) {
        return x1 > x2 ? x1 : x2;
    }

    void rkcoeff() {
        int j;
        int i;
        for (i = 0; i < 16; ++i) {
            this.b[i] = 0.0;
            this.bdach[i] = 0.0;
            this.berr[i] = 0.0;
            this.c[i] = 0.0;
            for (j = 0; j < 15; ++j) {
                this.a[i][j] = 0.0;
            }
            for (j = 0; j < 8; ++j) {
                this.beta[j][i] = 0.0;
            }
        }
        this.q = 5;
        this.p = 4;
        this.s = 7;
        this.ss = 7;
        this.d = 5;
        this.fsal = true;
        this.a[1][0] = 0.2;
        this.a[2][0] = 0.075;
        this.a[2][1] = 0.225;
        this.a[3][0] = 0.9777777777777777;
        this.a[3][1] = -3.7333333333333334;
        this.a[3][2] = 3.5555555555555554;
        this.a[4][0] = 2.9525986892242035;
        this.a[4][1] = -11.595793324188385;
        this.a[4][2] = 9.822892851699436;
        this.a[4][3] = -0.2908093278463649;
        this.a[5][0] = 2.8462752525252526;
        this.a[5][1] = -10.757575757575758;
        this.a[5][2] = 8.906422717743473;
        this.a[5][3] = 0.2784090909090909;
        this.a[5][4] = -0.2735313036020583;
        this.a[6][0] = 0.09114583333333333;
        this.a[6][2] = 0.44923629829290207;
        this.a[6][3] = 0.6510416666666666;
        this.a[6][4] = -0.322376179245283;
        this.a[6][5] = 0.13095238095238096;
        this.b[0] = 0.09114583333333333;
        this.b[2] = 0.44923629829290207;
        this.b[3] = 0.6510416666666666;
        this.b[4] = -0.322376179245283;
        this.b[5] = 0.13095238095238096;
        this.bdach[0] = 0.08991319444444444;
        this.bdach[2] = 0.4534890685834082;
        this.bdach[3] = 0.6140625;
        this.bdach[4] = -0.2715123820754717;
        this.bdach[5] = 0.08904761904761904;
        this.bdach[6] = 0.025;
        this.beta[0][0] = 1.0;
        this.beta[1][0] = -2.8605386690370884;
        this.beta[2][0] = 3.099577878709121;
        this.beta[3][0] = -1.1618105836403092;
        this.beta[4][0] = 0.013917207301610328;
        this.beta[1][2] = 4.047141499642786;
        this.beta[2][2] = -6.345354046938926;
        this.beta[3][2] = 2.795465086414005;
        this.beta[4][2] = -0.04801624082496286;
        this.beta[1][3] = -3.941160071112659;
        this.beta[2][3] = 10.904003027940295;
        this.beta[3][3] = -6.729317509209278;
        this.beta[4][3] = 0.4175162190483098;
        this.beta[1][4] = 2.8419447015870345;
        this.beta[2][4] = -7.547675862959386;
        this.beta[3][4] = 4.957636724931253;
        this.beta[4][4] = -0.5742817428041846;
        this.beta[1][5] = -1.6109886359167997;
        this.beta[2][5] = 4.218915839039518;
        this.beta[3][5] = -2.950103865566732;
        this.beta[4][5] = 0.47312904339639456;
        this.beta[1][6] = 1.523601174836727;
        this.beta[2][6] = -4.329466835790622;
        this.beta[3][6] = 3.0881301470710616;
        this.beta[4][6] = -0.2822644861171672;
        for (i = 0; i < this.ss; ++i) {
            for (j = 0; j < i; ++j) {
                int n = i;
                this.c[n] = this.c[n] + this.a[i][j];
            }
        }
        for (i = 0; i < this.s; ++i) {
            this.berr[i] = this.bdach[i] - this.b[i];
        }
        this.potenz = 1.0 / ((double)this.p + 1.0);
    }

    void rkinit(boolean autonom_p, int nvar_p, double eps_p, double tend_p, double h_p) {
        this.eps = eps_p;
        this.nvar = nvar_p;
        this.tend = tend_p;
        this.autonom = autonom_p;
        if (Math.abs(h_p) >= 9.9E-324) {
            this.Schrittweite = h_p;
        }
    }

    void rkstep(double t, double[] y) {
        boolean fail;
        int i;
        double ttemp = 0.0;
        int ifail = 0;
        this.tt = t;
        if (!this.fsal || Math.abs(t - this.tlast) > 9.9E-324) {
            this.dgl(t, y);
            for (i = 0; i < this.nvar; ++i) {
                this.k[0][i] = this.ys[i];
            }
        } else {
            for (i = 0; i < this.nvar; ++i) {
                this.k[0][i] = this.k[this.s - 1][i];
            }
        }
        do {
            double hfakt;
            int l;
            if (t + this.Schrittweite > this.tend) {
                this.Schrittweite = this.tend - t;
            }
            for (i = 1; i < this.s; ++i) {
                for (l = 0; l < this.nvar; ++l) {
                    this.ytemp[l] = 0.0;
                    for (int j = 0; j < i; ++j) {
                        int n = l;
                        this.ytemp[n] = this.ytemp[n] + this.a[i][j] * this.k[j][l];
                    }
                    this.ytemp[l] = y[l] + this.Schrittweite * this.ytemp[l];
                }
                if (!this.autonom) {
                    ttemp = t + this.c[i] * this.Schrittweite;
                }
                this.dgl(ttemp, this.ytemp);
                for (int ii = 0; ii < this.nvar; ++ii) {
                    this.k[i][ii] = this.ys[ii];
                }
            }
            double err = 0.0;
            for (l = 0; l < this.nvar; ++l) {
                double ydiff = 0.0;
                this.yneu[l] = 0.0;
                for (i = 0; i < this.s; ++i) {
                    int n = l;
                    this.yneu[n] = this.yneu[n] + this.b[i] * this.k[i][l];
                    ydiff += this.berr[i] * this.k[i][l];
                }
                ydiff = Math.abs(this.Schrittweite * ydiff);
                err = this.max(err, ydiff);
                this.yneu[l] = y[l] + this.Schrittweite * this.yneu[l];
            }
            fail = err > this.eps;
            if (fail) {
                ++ifail;
            }
            if (ifail > 5) {
                this.error("Schrittweite 5 mal erfolglos verkleinert");
            }
            if ((hfakt = 0.9 * Math.pow(this.eps / err, this.potenz)) < 0.1) {
                hfakt = 0.1;
            }
            if (hfakt > 5.0) {
                hfakt = 5.0;
            }
            this.h0 = this.Schrittweite;
            if (ifail != 0 && !(hfakt < 1.0)) continue;
            this.Schrittweite *= hfakt;
        } while (fail);
        this.nfail += (long)ifail;
        ++this.ngood;
        for (i = 0; i < this.nvar; ++i) {
            this.ybeg = y;
        }
        this.neu = true;
        this.yneu[4] = this.tlast = t + this.h0;
    }

    double Potential(double x, double y) {
        double ret = 0.0;
        for (int i = 0; i <= this.MagAnz - 1; ++i) {
            ret -= this.MagPar[i] * 1.0 / Math.sqrt((x - this.MagX[i]) * (x - this.MagX[i]) + (y - this.MagY[i]) * (y - this.MagY[i]) + this.MagAbst * this.MagAbst);
        }
        return ret + this.GravConst * (x * x + y * y);
    }

    public void dgl(double t, double[] y) {
        this.nenner = 0.0;
        this.magpowx = 0.0;
        this.magpowy = 0.0;
        for (int i = 0; i <= this.MagAnz - 1; ++i) {
            this.nenner = Math.pow((this.MagX[i] - y[0]) * (this.MagX[i] - y[0]) + (this.MagY[i] - y[2]) * (this.MagY[i] - y[2]) + this.MagAbst * this.MagAbst, 1.5);
            this.magpowx += this.MagPar[i] * (this.MagX[i] - y[0]) / this.nenner;
            this.magpowy += this.MagPar[i] * (this.MagY[i] - y[2]) / this.nenner;
        }
        this.ys[0] = y[1];
        this.ys[1] = -this.ReibKoeff * y[1] + this.magpowx - this.GravConst * y[0];
        this.ys[2] = y[3];
        this.ys[3] = -this.ReibKoeff * y[3] + this.magpowy - this.GravConst * y[2];
    }
}

