/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JPanel;

class Trajektorie
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected Magnetpendel Main;
    protected BufferedImage hintergrundBild;
    protected BufferedImage bild;
    protected RungeKutta rk;
    protected double XMin = -7.0;
    protected double XMax = 7.0;
    protected double YMin = -4.9;
    protected double YMax = 4.9;
    protected double ReibKoeff = 0.15;
    protected double GravConst = 0.3;
    protected double MagAbst = 0.01;
    protected int MagAnz = 3;
    protected double[] MagX = new double[3];
    protected double[] MagY = new double[3];
    protected double[] MagPar = new double[3];
    protected Color[] MagnetFarben = new Color[4];
    protected double Genauigkeit = 1.0E-6;
    protected double AnfangsSchrittweite = 0.05;
    protected double ZeichenSchrittweite = 0.001;
    protected double MagEntf = 0.1;
    protected double XVersch;
    protected double YVersch;
    protected double XFaktor;
    protected double YFaktor;
    protected int startwerteAnzahl = 0;
    protected int startwerteMax = 20;
    protected int schrittZaehler;
    protected double[][] startwerte = new double[100][2];
    protected double[][][] trajektorien = new double[this.startwerteMax][900][2];
    protected double[][][] ztrajektorien = new double[this.startwerteMax][900][2];
    protected int whatToDo = 0;
    protected int ausgewaehlterMagnet = -1;
    protected boolean zuschauer = false;
    int x3 = -1;
    int y3 = -1;
    int x1 = -1;
    int x2 = -1;
    int y1;
    int y2;
    boolean mouseGedrueckt = false;

    public Trajektorie(Magnetpendel parent) {
        this.Main = parent;
        this.rk = new RungeKutta(this);
        this.hintergrundBild = new BufferedImage(800, 600, 1);
        this.hintergrundBild.createGraphics();
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Trajektorie.this.keyEventHandler((KeyEvent)event);
            }
        }, 8L);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Trajektorie.this.resizedHandler(e);
            }
        });
        this.setToolTipText("Zur Eingabe der Startwerte klicken Sie in die Ebene (Shift-Klick f\u00fcr numerische Eingabe).");
    }

    protected void CalcFakVersch(JPanel gp) {
        this.XFaktor = (this.XMax - this.XMin) / (double)gp.getWidth();
        this.YFaktor = -(this.YMax - this.YMin) / (double)gp.getHeight();
        this.XVersch = this.XMin;
        this.YVersch = this.YMax;
    }

    protected Point XyToScreen(double x, double y) {
        Point point = new Point();
        point.x = (int)((x - this.XVersch) / this.XFaktor);
        point.y = (int)((y - this.YVersch) / this.YFaktor);
        return point;
    }

    protected double[] ScreenToXy(int xscreen, int yscreen) {
        double[] v = new double[]{(double)xscreen * this.XFaktor + this.XVersch, (double)yscreen * this.YFaktor + this.YVersch};
        return v;
    }

    int postest(double[] tsvec) {
        int j = 0;
        for (j = 0; j < this.MagAnz; ++j) {
            if (this.MagPar[j] == 0.0 || !(Math.abs(tsvec[0] - this.MagX[j]) < this.MagEntf) || !(Math.abs(tsvec[2] - this.MagY[j]) < this.MagEntf)) continue;
            return j + 1;
        }
        return 0;
    }

    void Trajectory(double xstart, double ystart, int trajNr) {
        double tneu;
        int counter = 1;
        double t = 0.0;
        double tstern = 0.1;
        double[] PhaseVector = new double[5];
        double[] PhaseVectorNeu = new double[5];
        double[] PhaseVectorStern = new double[4];
        int magnet = this.WhichMagnet(this.startwerte[trajNr][0], this.startwerte[trajNr][1]);
        PhaseVector[0] = xstart;
        PhaseVector[1] = 0.0;
        PhaseVector[2] = ystart;
        PhaseVector[3] = 0.0;
        Point pointAlt = this.XyToScreen(xstart, ystart);
        double SattelWert = this.Potential(-0.5, 0.0);
        this.rk.rkinit(true, 4, this.Genauigkeit, 200.0, this.AnfangsSchrittweite);
        this.ZeichenSchrittweite = this.AnfangsSchrittweite / 10.0;
        do {
            double EpsGeschwquad;
            double vquad;
            PhaseVectorNeu = this.rk.rkstep(t, PhaseVector);
            tneu = PhaseVectorNeu[4];
            while (tstern < tneu) {
                PhaseVectorStern = this.rk.rkipol(tstern);
                Point point = this.XyToScreen(PhaseVectorStern[0], PhaseVectorStern[2]);
                if (Math.abs(point.x - pointAlt.x) > 3 || Math.abs(point.y - pointAlt.y) > 3) {
                    if (counter < 899) {
                        this.trajektorien[trajNr][counter][0] = PhaseVectorStern[0];
                        this.trajektorien[trajNr][counter][1] = PhaseVectorStern[2];
                        ++counter;
                    }
                    pointAlt = point;
                }
                tstern += this.ZeichenSchrittweite;
            }
            int MagKoor = this.postest(PhaseVector);
            if (MagKoor != 0 && (vquad = PhaseVector[1] * PhaseVector[1] + PhaseVector[3] * PhaseVector[3]) < (EpsGeschwquad = 2.0 * Math.abs(this.Potential(PhaseVector[0], PhaseVector[2]) - SattelWert))) {
                tneu = 200.0;
            }
            t = tneu;
            for (int i = 0; i < 4; ++i) {
                PhaseVector[i] = PhaseVectorNeu[i];
            }
        } while (tneu < 200.0);
        if (counter < 900 && magnet > 0) {
            this.trajektorien[trajNr][counter][0] = this.MagX[magnet - 1];
            this.trajektorien[trajNr][counter][1] = this.MagY[magnet - 1];
            ++counter;
        }
        this.trajektorien[trajNr][0][0] = counter;
        this.trajektorien[trajNr][0][1] = magnet;
    }

    void ZTrajectory(double xstart, double ystart, int trajNr) {
        double tneu;
        int counter = 1;
        double t = 0.0;
        double tstern = 0.1;
        double[] PhaseVector = new double[5];
        double[] PhaseVectorNeu = new double[5];
        double[] PhaseVectorStern = new double[4];
        this.GravConst += 0.001;
        int magnet = this.WhichMagnet(this.startwerte[trajNr][0], this.startwerte[trajNr][1]);
        PhaseVector[0] = xstart;
        PhaseVector[1] = 0.0;
        PhaseVector[2] = ystart;
        PhaseVector[3] = 0.0;
        Point pointAlt = this.XyToScreen(xstart, ystart);
        double SattelWert = this.Potential(-0.5, 0.0);
        this.rk.rkinit(true, 4, this.Genauigkeit, 200.0, this.AnfangsSchrittweite);
        do {
            double EpsGeschwquad;
            double vquad;
            PhaseVectorNeu = this.rk.rkstep(t, PhaseVector);
            tneu = PhaseVectorNeu[4];
            while (tstern < tneu) {
                PhaseVectorStern = this.rk.rkipol(tstern);
                Point point = this.XyToScreen(PhaseVectorStern[0], PhaseVectorStern[2]);
                if (Math.abs(point.x - pointAlt.x) > 3 || Math.abs(point.y - pointAlt.y) > 3) {
                    if (counter < 899) {
                        this.ztrajektorien[trajNr][counter][0] = PhaseVectorStern[0];
                        this.ztrajektorien[trajNr][counter][1] = PhaseVectorStern[2];
                        ++counter;
                    }
                    pointAlt = point;
                }
                tstern += this.ZeichenSchrittweite;
            }
            int MagKoor = this.postest(PhaseVector);
            if (MagKoor != 0 && (vquad = PhaseVector[1] * PhaseVector[1] + PhaseVector[3] * PhaseVector[3]) < (EpsGeschwquad = 2.0 * Math.abs(this.Potential(PhaseVector[0], PhaseVector[2]) - SattelWert))) {
                tneu = 200.0;
            }
            t = tneu;
            for (int i = 0; i < 4; ++i) {
                PhaseVector[i] = PhaseVectorNeu[i];
            }
        } while (tneu < 200.0);
        if (counter < 900 && magnet > 0) {
            this.ztrajektorien[trajNr][counter][0] = this.MagX[magnet - 1];
            this.ztrajektorien[trajNr][counter][1] = this.MagY[magnet - 1];
            ++counter;
        }
        this.ztrajektorien[trajNr][0][0] = counter;
        this.ztrajektorien[trajNr][0][1] = magnet;
        this.GravConst -= 0.001;
    }

    int WhichMagnet(double xstart, double ystart) {
        double tneu;
        int MagKoor = 0;
        double t = 0.0;
        double tstern = 0.1;
        double[] PhaseVector = new double[5];
        double[] PhaseVectorNeu = new double[5];
        PhaseVector[0] = xstart;
        PhaseVector[1] = 0.0;
        PhaseVector[2] = ystart;
        PhaseVector[3] = 0.0;
        double SattelWert = this.Potential(-0.5, 0.0);
        this.rk.rkinit(true, 4, this.Genauigkeit, 200.0, this.AnfangsSchrittweite);
        do {
            double DeltaE;
            double vquad;
            PhaseVectorNeu = this.rk.rkstep(t, PhaseVector);
            tneu = PhaseVectorNeu[4];
            for (int i = 0; i < 4; ++i) {
                PhaseVector[i] = PhaseVectorNeu[i];
            }
            MagKoor = this.postest(PhaseVector);
            if (MagKoor != 0 && (vquad = PhaseVector[1] * PhaseVector[1] + PhaseVector[3] * PhaseVector[3]) < (DeltaE = 2.0 * Math.abs(this.Potential(PhaseVector[0], PhaseVector[2]) - SattelWert))) {
                tneu = 200.0;
            }
            t = tneu;
        } while (tneu < 200.0);
        return MagKoor;
    }

    public void keyEventHandler(KeyEvent event) {
        if (event.getID() == 401) {
            if (event.getKeyCode() == 32) {
                // empty if block
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.whatToDo != 0 && this.whatToDo != 4) {
            Graphics gra = this.getGraphics();
            gra.setXORMode(Color.white);
            if (e.getX() != this.x2 && e.getY() != this.y2) {
                if (this.x3 != -1) {
                    gra.drawLine(0, this.y3, this.getWidth(), this.y3);
                    gra.drawLine(this.x3, 0, this.x3, this.getHeight());
                }
                gra.drawLine(0, e.getY(), this.getWidth(), e.getY());
                gra.drawLine(e.getX(), 0, e.getX(), this.getHeight());
                this.x3 = e.getX();
                this.y3 = e.getY();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.whatToDo == 0) {
            return;
        }
        Graphics gra = this.getGraphics();
        gra.setXORMode(Color.white);
        if (e.getX() != this.x2 && e.getY() != this.y2) {
            if (this.whatToDo != 4) {
                if (this.x3 != -1) {
                    gra.drawLine(0, this.y3, this.getWidth(), this.y3);
                    gra.drawLine(this.x3, 0, this.x3, this.getHeight());
                    this.x3 = -1;
                }
                gra.drawLine(0, e.getY(), this.getWidth(), e.getY());
                gra.drawLine(e.getX(), 0, e.getX(), this.getHeight());
                this.x3 = e.getX();
                this.y3 = e.getY();
            }
            switch (this.whatToDo) {
                case 1: 
                case 2: {
                    if (this.x2 >= 0) {
                        gra.drawLine(this.x1, this.y1, this.x2, this.y1);
                        gra.drawLine(this.x1, this.y1, this.x1, this.y2);
                    }
                    this.x2 = e.getX();
                    this.y2 = e.getY();
                    gra.drawLine(this.x1, this.y1, this.x2, this.y1);
                    gra.drawLine(this.x1, this.y1, this.x1, this.y2);
                    break;
                }
                case 3: {
                    if (this.x2 >= 0) {
                        gra.drawLine(this.x1, this.y1, this.x2, this.y2);
                    }
                    this.x2 = e.getX();
                    this.y2 = e.getY();
                    gra.drawLine(this.x1, this.y1, this.x2, this.y2);
                    break;
                }
                case 4: {
                    if (this.ausgewaehlterMagnet < 0) break;
                    if (this.x2 >= 0) {
                        gra.fillOval(this.x2 - 3, this.y2 - 3, 5, 5);
                    }
                    this.x2 = e.getX();
                    this.y2 = e.getY();
                    gra.fillOval(this.x2 - 3, this.y2 - 3, 5, 5);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.whatToDo != 0) {
            return;
        }
        if (this.schrittZaehler > 0) {
            return;
        }
        if (this.startwerteAnzahl >= this.startwerteMax) {
            return;
        }
        if (e.isShiftDown()) {
            double[] vect1 = this.ScreenToXy(e.getX(), e.getY());
            StartwertEingabe eingabe = new StartwertEingabe(this.Main, true, vect1[0], vect1[1]);
            eingabe.setLocation(e.getX(), e.getY());
            eingabe.showEingabe();
            if (eingabe.canceled) return;
            this.startwerte[this.startwerteAnzahl][0] = eingabe.xwert;
            this.startwerte[this.startwerteAnzahl][1] = eingabe.ywert;
            ++this.startwerteAnzahl;
        } else {
            double[] vect1 = this.ScreenToXy(e.getX(), e.getY());
            this.startwerte[this.startwerteAnzahl][0] = vect1[0];
            this.startwerte[this.startwerteAnzahl][1] = vect1[1];
            ++this.startwerteAnzahl;
        }
        int i = this.startwerteAnzahl - 1;
        this.Trajectory(this.startwerte[i][0], this.startwerte[i][1], i);
        this.ZTrajectory(this.startwerte[i][0], this.startwerte[i][1], i);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Graphics gra = this.getGraphics();
        this.x1 = e.getX();
        this.y1 = e.getY();
        this.x2 = -1;
        this.y2 = -1;
        this.mouseGedrueckt = true;
        if (this.whatToDo == 4) {
            this.ausgewaehlterMagnet = -1;
            for (int i = 0; i < this.MagAnz; ++i) {
                Point point = this.XyToScreen(this.MagX[i], this.MagY[i]);
                if (Math.abs(e.getX() - point.x) >= 5 || Math.abs(e.getY() - point.y) >= 5) continue;
                gra.setXORMode(Color.white);
                gra.fillOval(point.x - 3, point.y - 3, 5, 5);
                this.ausgewaehlterMagnet = i;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseGedrueckt = false;
        if (this.whatToDo == 0) {
            return;
        }
        Graphics gra = this.getGraphics();
        gra.setXORMode(Color.white);
        this.x2 = e.getX();
        this.y2 = e.getY();
        switch (this.whatToDo) {
            case 1: {
                gra.drawRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                break;
            }
            case 2: {
                gra.drawRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                break;
            }
            case 3: {
                gra.drawLine(this.x1, this.y1, this.x2, this.y2);
            }
        }
        if (Math.abs(this.x1 - this.x2) < 5 && Math.abs(this.y1 - this.y2) < 5) {
            return;
        }
        double[] vect1 = this.ScreenToXy(this.x1, this.y1);
        double[] vect2 = this.ScreenToXy(this.x2, this.y2);
        switch (this.whatToDo) {
            case 1: {
                if (vect1[0] < vect2[0]) {
                    this.XMin = vect1[0];
                    this.XMax = vect2[0];
                } else {
                    this.XMin = vect2[0];
                    this.XMax = vect1[0];
                }
                if (vect1[1] < vect2[1]) {
                    this.YMin = vect1[1];
                    this.YMax = vect2[1];
                    break;
                }
                this.YMin = vect2[1];
                this.YMax = vect1[1];
                break;
            }
            case 2: {
                double help;
                if (vect1[0] > vect2[0]) {
                    help = vect1[0];
                    vect1[0] = vect2[0];
                    vect2[0] = help;
                }
                if (vect1[1] > vect2[1]) {
                    help = vect1[1];
                    vect1[1] = vect2[1];
                    vect2[1] = help;
                }
                double fakt = (this.XMax - this.XMin) / (vect2[0] - vect1[0]);
                help = this.XMax - this.XMin;
                this.XMin -= fakt * (vect1[0] - this.XMin);
                this.XMax = this.XMin + fakt * help;
                fakt = (this.YMax - this.YMin) / (vect2[1] - vect1[1]);
                help = this.YMax - this.YMin;
                this.YMin -= fakt * (vect1[1] - this.YMin);
                this.YMax = this.YMin + fakt * help;
                break;
            }
            case 3: {
                this.XMin -= vect2[0] - vect1[0];
                this.XMax -= vect2[0] - vect1[0];
                this.YMin -= vect2[1] - vect1[1];
                this.YMax -= vect2[1] - vect1[1];
                break;
            }
            case 4: {
                if (this.ausgewaehlterMagnet >= 0) {
                    this.MagX[this.ausgewaehlterMagnet] = vect2[0];
                    this.MagY[this.ausgewaehlterMagnet] = vect2[1];
                    break;
                }
                return;
            }
        }
        this.whatToDo = 0;
        this.x1 = -1;
        this.x2 = -1;
        this.x3 = -1;
        this.CalcFakVersch(this);
        this.CalcBackground(this.hintergrundBild, this);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void resizedHandler(ComponentEvent event) {
    }

    @Override
    public void paint(Graphics g) {
        Point pointAlt;
        int j;
        Point point;
        int i;
        this.CalcFakVersch(this);
        g.drawImage(this.hintergrundBild, 0, 0, this.getWidth(), this.getHeight(), this);
        for (i = 0; i < this.MagAnz; ++i) {
            point = this.XyToScreen(this.MagX[i], this.MagY[i]);
            g.setColor(this.MagnetFarben[i + 1]);
            if (this.MagPar[i] == 0.0) continue;
            g.fillOval(point.x - 3, point.y - 3, 5, 5);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (j = 0; j < this.startwerteAnzahl; ++j) {
            g.setColor(this.MagnetFarben[(int)this.trajektorien[j][0][1]]);
            pointAlt = this.XyToScreen(this.startwerte[j][0], this.startwerte[j][1]);
            g.fillOval(pointAlt.x - 2, pointAlt.y - 2, 3, 3);
            i = 2;
            while ((double)i < this.trajektorien[j][0][0]) {
                point = this.XyToScreen(this.trajektorien[j][i][0], this.trajektorien[j][i][1]);
                g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                pointAlt = point;
                ++i;
            }
        }
        if (this.zuschauer) {
            for (j = 0; j < this.startwerteAnzahl; ++j) {
                g.setColor(this.MagnetFarben[(int)this.ztrajektorien[j][0][1]]);
                pointAlt = this.XyToScreen(this.startwerte[j][0], this.startwerte[j][1]);
                g.fillOval(pointAlt.x - 2, pointAlt.y - 2, 3, 3);
                i = 2;
                while ((double)i < this.ztrajektorien[j][0][0]) {
                    point = this.XyToScreen(this.ztrajektorien[j][i][0], this.ztrajektorien[j][i][1]);
                    g.drawLine(pointAlt.x, pointAlt.y, point.x, point.y);
                    pointAlt = point;
                    ++i;
                }
            }
        }
    }

    public void neu() {
        int i;
        this.XMin = -7.0;
        this.XMax = 7.0;
        this.YMin = -4.9;
        this.YMax = 4.9;
        this.ReibKoeff = 0.15;
        this.GravConst = 0.3;
        this.MagAbst = 0.01;
        this.MagAnz = 3;
        for (i = 0; i < this.MagAnz; ++i) {
            this.MagX[i] = Statics.MAGX[i];
        }
        for (i = 0; i < this.MagAnz; ++i) {
            this.MagY[i] = Statics.MAGY[i];
        }
        for (i = 0; i < this.MagAnz; ++i) {
            this.MagPar[i] = Statics.MAGST[i];
        }
        for (i = 0; i < this.MagAnz + 1; ++i) {
            this.MagnetFarben[i] = Statics.MAGFARBE[i];
        }
        this.Genauigkeit = 1.0E-6;
        this.AnfangsSchrittweite = 0.05;
        this.MagEntf = 0.1;
        this.startwerteAnzahl = 0;
        this.Main.buttonLeiste.update();
        this.CalcBackground(this.hintergrundBild, this);
    }

    public void open(File file) {
        try {
            int i;
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream stream = new ObjectInputStream(fis);
            String dummy = (String)stream.readObject();
            this.XMin = stream.readDouble();
            this.XMax = stream.readDouble();
            this.YMin = stream.readDouble();
            this.YMax = stream.readDouble();
            this.ReibKoeff = stream.readDouble();
            this.GravConst = stream.readDouble();
            this.MagAbst = stream.readDouble();
            this.MagAnz = stream.readInt();
            for (i = 0; i < this.MagAnz; ++i) {
                this.MagX[i] = stream.readDouble();
            }
            for (i = 0; i < this.MagAnz; ++i) {
                this.MagY[i] = stream.readDouble();
            }
            for (i = 0; i < this.MagAnz; ++i) {
                this.MagPar[i] = stream.readDouble();
            }
            for (i = 0; i < this.MagAnz + 1; ++i) {
                this.MagnetFarben[i] = (Color)stream.readObject();
            }
            this.Genauigkeit = stream.readDouble();
            this.AnfangsSchrittweite = stream.readDouble();
            this.MagEntf = stream.readDouble();
            this.startwerteAnzahl = stream.readInt();
            for (i = 0; i < this.startwerteAnzahl; ++i) {
                this.startwerte[i][0] = stream.readDouble();
                this.startwerte[i][1] = stream.readDouble();
            }
            stream.close();
        }
        catch (Exception ex) {
            new AutoDialog().display("Fehler!", "Kann die Datei nicht lesen." + ex);
            file = null;
        }
        this.Main.buttonLeiste.update();
        this.CalcBackground(this.hintergrundBild, this);
        this.Main.setVisible(true);
        this.trajektorienNeu();
    }

    public void save(File file) {
        try {
            int i;
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream stream = new ObjectOutputStream(fos);
            stream.writeObject("traj");
            stream.writeDouble(this.XMin);
            stream.writeDouble(this.XMax);
            stream.writeDouble(this.YMin);
            stream.writeDouble(this.YMax);
            stream.writeDouble(this.ReibKoeff);
            stream.writeDouble(this.GravConst);
            stream.writeDouble(this.MagAbst);
            stream.writeInt(this.MagAnz);
            for (i = 0; i < 3; ++i) {
                stream.writeDouble(this.MagX[i]);
            }
            for (i = 0; i < 3; ++i) {
                stream.writeDouble(this.MagY[i]);
            }
            for (i = 0; i < 3; ++i) {
                stream.writeDouble(this.MagPar[i]);
            }
            for (i = 0; i < 4; ++i) {
                stream.writeObject(this.MagnetFarben[i]);
            }
            stream.writeDouble(this.Genauigkeit);
            stream.writeDouble(this.AnfangsSchrittweite);
            stream.writeDouble(this.MagEntf);
            stream.writeInt(this.startwerteAnzahl);
            for (i = 0; i < this.startwerteAnzahl; ++i) {
                stream.writeDouble(this.startwerte[i][0]);
                stream.writeDouble(this.startwerte[i][1]);
            }
            stream.close();
        }
        catch (Exception ex) {
            new AutoDialog().display("Fehler!", "Kann die Datei nicht schreiben." + ex);
            file = null;
        }
    }

    public void trajektorienNeu() {
        for (int i = 0; i < this.startwerteAnzahl; ++i) {
            this.Trajectory(this.startwerte[i][0], this.startwerte[i][1], i);
            this.ZTrajectory(this.startwerte[i][0], this.startwerte[i][1], i);
        }
        this.repaint();
    }

    double Potential(double x, double y) {
        double ret = 0.0;
        for (int i = 0; i <= this.MagAnz - 1; ++i) {
            ret -= this.MagPar[i] * 1.0 / Math.sqrt((x - this.MagX[i]) * (x - this.MagX[i]) + (y - this.MagY[i]) * (y - this.MagY[i]) + this.MagAbst * this.MagAbst);
        }
        return ret + this.GravConst * (x * x + y * y);
    }

    void CalcBackground(BufferedImage bild, JPanel parent) {
        int Stufen = 50;
        Graphics g = bild.getGraphics();
        parent.setCursor(new Cursor(3));
        double min = this.Potential(this.MagX[1], this.MagY[1]);
        double max = 0.0;
        double faktor = 1.0 / (max - min);
        double deltaX = (this.XMax - this.XMin) / (double)bild.getWidth();
        double deltaY = (this.YMax - this.YMin) / (double)bild.getHeight();
        double y = this.YMax;
        int yKo = 0;
        do {
            y -= deltaY;
            double x = this.XMin;
            int xKo = 0;
            do {
                double pot = this.Potential(x += deltaX, y);
                float grauStufe = (float)((pot - min) * faktor - 0.2);
                if ((grauStufe = (float)((int)(grauStufe * (float)Stufen)) / (float)Stufen) < 0.0f) {
                    grauStufe = 0.0f;
                }
                if (grauStufe > 1.0f) {
                    grauStufe = 1.0f;
                }
                g.setColor(new Color(grauStufe, grauStufe, grauStufe));
                g.drawLine(xKo, yKo, xKo, yKo);
                ++xKo;
            } while (x < this.XMax);
            ++yKo;
        } while (y > this.YMin);
        this.trajektorienNeu();
        parent.setCursor(Cursor.getDefaultCursor());
    }

    public double[] dgl(double t, double[] y) {
        double[] ys = new double[4];
        double nenner = 0.0;
        double magpowx = 0.0;
        double magpowy = 0.0;
        for (int i = 0; i <= this.MagAnz - 1; i = (int)((short)(i + 1))) {
            nenner = Math.pow((this.MagX[i] - y[0]) * (this.MagX[i] - y[0]) + (this.MagY[i] - y[2]) * (this.MagY[i] - y[2]) + this.MagAbst * this.MagAbst, 1.5);
            magpowx += this.MagPar[i] * (this.MagX[i] - y[0]) / nenner;
            magpowy += this.MagPar[i] * (this.MagY[i] - y[2]) / nenner;
        }
        ys[0] = y[1];
        ys[1] = -this.ReibKoeff * y[1] + magpowx - this.GravConst * y[0];
        ys[2] = y[3];
        ys[3] = -this.ReibKoeff * y[3] + magpowy - this.GravConst * y[2];
        return ys;
    }
}

